/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.collect;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.javax.annotation.Nullable;

@Beta
public class IterableWithMarkers {
    public static final IterableWithMarker EMPTY = IterableWithMarkers.from(ImmutableSet.of());

    public static <T> IterableWithMarker<T> from(Iterable<T> elements) {
        return IterableWithMarkers.from(elements, null);
    }

    public static <T> IterableWithMarker<T> from(final Iterable<T> elements, final @Nullable Object marker) {
        return new ForwardingIterableWithMarker<T>(){

            @Override
            protected IterableWithMarker<T> delegate() {
                return new ForwardedIterableWithMarker(elements, marker);
            }
        };
    }

    private static abstract class ForwardingIterableWithMarker<T>
    extends IterableWithMarker<T> {
        private ForwardingIterableWithMarker() {
        }

        protected abstract IterableWithMarker<T> delegate();

        public Iterator<T> iterator() {
            return this.delegate().iterator();
        }

        @Override
        public Optional<Object> nextMarker() {
            return this.delegate().nextMarker();
        }
    }

    private static final class ForwardedIterableWithMarker<T>
    extends IterableWithMarker<T> {
        private final Iterable<T> elements;
        private final Optional<Object> marker;

        private ForwardedIterableWithMarker(Iterable<T> elements, @Nullable Object marker) {
            this.elements = (Iterable)Preconditions.checkNotNull(elements, (Object)"elements");
            this.marker = Optional.fromNullable((Object)marker);
        }

        public Iterator<T> iterator() {
            return this.elements.iterator();
        }

        @Override
        public Optional<Object> nextMarker() {
            return this.marker;
        }
    }
}

