/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.jmx.jmxmp;

import java.io.FileInputStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.registry.LocateRegistry;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class JmxmpAgent {
    public static final String JMXMP_PORT_PROPERTY = "brooklyn.jmxmp.port";
    public static final String RMI_HOSTNAME_PROPERTY = "java.rmi.server.hostname";
    public static final String JMX_SERVER_ADDRESS_WILDCARD_PROPERTY = "jmx.remote.server.address.wildcard";
    public static final String RMI_REGISTRY_PORT_PROPERTY = "brooklyn.jmxmp.rmi-port";
    public static final String USE_SSL_PROPERTY = "com.sun.management.jmxremote.ssl";
    public static final String AUTHENTICATE_CLIENTS_PROPERTY = "brooklyn.jmxmp.ssl.authenticate";
    public static final String JMXMP_KEYSTORE_FILE_PROPERTY = "brooklyn.jmxmp.ssl.keyStore";
    public static final String JMXMP_KEYSTORE_PASSWORD_PROPERTY = "brooklyn.jmxmp.ssl.keyStorePassword";
    public static final String JMXMP_KEYSTORE_KEY_PASSWORD_PROPERTY = "brooklyn.jmxmp.ssl.keyStore.keyPassword";
    public static final String JMXMP_KEYSTORE_TYPE_PROPERTY = "brooklyn.jmxmp.ssl.keyStoreType";
    public static final String JMXMP_TRUSTSTORE_FILE_PROPERTY = "brooklyn.jmxmp.ssl.trustStore";
    public static final String JMXMP_TRUSTSTORE_PASSWORD_PROPERTY = "brooklyn.jmxmp.ssl.trustStorePassword";
    public static final String JMXMP_TRUSTSTORE_TYPE_PROPERTY = "brooklyn.jmxmp.ssl.trustStoreType";
    public static final String TLS_NEED_AUTHENTICATE_CLIENTS_PROPERTY = "jmx.remote.tls.need.client.authentication";
    public static final String TLS_WANT_AUTHENTICATE_CLIENTS_PROPERTY = "jmx.remote.tls.want.client.authentication";
    public static final String TLS_SOCKET_FACTORY_PROPERTY = "jmx.remote.tls.socket.factory";
    public static final String TLS_JMX_REMOTE_PROFILES = "TLS";
    public static final int JMXMP_DEFAULT_PORT = 11099;

    public static void premain(String agentArgs) {
        JmxmpAgent.doMain(agentArgs);
    }

    public static void agentmain(String agentArgs) {
        JmxmpAgent.doMain(agentArgs);
    }

    public static void doMain(final String agentArgs) {
        Thread t = new Thread(){

            @Override
            public void run() {
                JmxmpAgent.doMainForeground(agentArgs);
            }
        };
        t.setDaemon(true);
        t.start();
    }

    public static void doMainForeground(String agentArgs) {
        final List<JMXConnectorServer> connectors = new JmxmpAgent().startConnectors(System.getProperties());
        if (!connectors.isEmpty()) {
            Runtime.getRuntime().addShutdownHook(new Thread("jmxmp-agent-shutdownHookThread"){

                @Override
                public void run() {
                    for (JMXConnectorServer connector : connectors) {
                        try {
                            connector.stop();
                        }
                        catch (Exception e) {
                            System.err.println("Error closing jmxmp connector " + connector + " in shutdown hook (continuing): " + e);
                        }
                    }
                }
            });
        }
    }

    public List<JMXConnectorServer> startConnectors(Properties properties) {
        ArrayList<JMXConnectorServer> connectors = new ArrayList<JMXConnectorServer>();
        JmxmpAgent.addIfNotNull(this.startJmxmpConnector(properties), connectors);
        JmxmpAgent.addIfNotNull(this.startNormalJmxRmiConnectorIfRequested(properties), connectors);
        return connectors;
    }

    private static <T> void addIfNotNull(T item, List<T> list) {
        if (item != null) {
            list.add(item);
        }
    }

    public JMXConnectorServer startJmxmpConnector(Properties properties) {
        try {
            int port = Integer.parseInt(properties.getProperty(JMXMP_PORT_PROPERTY, "11099"));
            String hostname = JmxmpAgent.getLocalhostHostname(properties);
            JMXServiceURL serviceUrl = new JMXServiceURL("service:jmx:jmxmp://" + hostname + ":" + port);
            LinkedHashMap<String, Object> env = new LinkedHashMap<String, Object>();
            JmxmpAgent.propagate(properties, env, JMX_SERVER_ADDRESS_WILDCARD_PROPERTY, null);
            if (this.asBoolean(properties, USE_SSL_PROPERTY, false, true)) {
                this.setSslEnvFromProperties(env, properties);
            } else if (this.asBoolean(properties, AUTHENTICATE_CLIENTS_PROPERTY, false, true)) {
                throw new IllegalStateException("Client authentication not supported when not using SSL");
            }
            MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            JMXConnectorServer connector = JMXConnectorServerFactory.newJMXConnectorServer(serviceUrl, env, platformMBeanServer);
            connector.start();
            System.out.println("JmxmpAgent active at: " + serviceUrl);
            return connector;
        }
        catch (RuntimeException e) {
            System.err.println("Unable to start JmxmpAgent: " + e);
            throw e;
        }
        catch (Exception e) {
            System.err.println("Unable to start JmxmpAgent: " + e);
            throw new RuntimeException(e);
        }
    }

    public JMXConnectorServer startNormalJmxRmiConnectorIfRequested(Properties properties) {
        try {
            String rmiPortS = properties.getProperty(RMI_REGISTRY_PORT_PROPERTY);
            if (rmiPortS == null || rmiPortS.length() == 0) {
                return null;
            }
            int rmiPort = Integer.parseInt(rmiPortS);
            LocateRegistry.createRegistry(rmiPort);
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            String svc = "service:jmx:rmi:///jndi/rmi://localhost:" + rmiPort + "/jmxrmi";
            JMXServiceURL url = new JMXServiceURL(svc);
            RMIConnectorServer rmiServer = new RMIConnectorServer(url, null, mbeanServer);
            rmiServer.start();
            return rmiServer;
        }
        catch (Exception e) {
            System.err.println("Unable to start JmxmpAgent: " + e);
            throw new RuntimeException(e);
        }
    }

    public static String getLocalhostHostname(Properties properties) throws UnknownHostException {
        String hostname;
        String string = hostname = properties == null ? null : properties.getProperty(RMI_HOSTNAME_PROPERTY);
        if (hostname == null || hostname.isEmpty()) {
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                System.err.println("Misconfigured hostname when setting JmxmpAgent; reverting to 127.0.0.1: " + e);
                hostname = "127.0.0.1";
            }
        }
        return hostname;
    }

    private static boolean propagate(Properties source, Map<String, Object> target, String key, Object defaultValueIfNotNull) {
        Object v = source.getProperty(key);
        if (v == null) {
            v = defaultValueIfNotNull;
        }
        if (v == null) {
            return false;
        }
        target.put(key, v);
        return true;
    }

    private boolean asBoolean(Properties properties, String key, Boolean valueIfNull, Boolean valueIfUnknownText) {
        Object v = properties.get(key);
        if (v == null) {
            if (valueIfNull == null) {
                throw new IllegalStateException("Property '" + key + "' is required.");
            }
            return valueIfNull;
        }
        String vv = v.toString();
        if ("true".equalsIgnoreCase(vv)) {
            return true;
        }
        if ("false".equalsIgnoreCase(vv)) {
            return false;
        }
        if (valueIfUnknownText == null) {
            throw new IllegalStateException("Property '" + key + "' has illegal value '" + vv + "'; should be true or false");
        }
        return valueIfUnknownText;
    }

    public void setSslEnvFromProperties(Map<String, Object> env, Properties properties) throws Exception {
        env.put("jmx.remote.profiles", TLS_JMX_REMOTE_PROFILES);
        boolean authenticating = this.asBoolean(properties, AUTHENTICATE_CLIENTS_PROPERTY, true, null);
        if (authenticating) {
            env.put(AUTHENTICATE_CLIENTS_PROPERTY, "true");
            JmxmpAgent.propagate(properties, env, TLS_NEED_AUTHENTICATE_CLIENTS_PROPERTY, "true");
            JmxmpAgent.propagate(properties, env, TLS_WANT_AUTHENTICATE_CLIENTS_PROPERTY, "true");
        }
        if (!JmxmpAgent.propagate(properties, env, TLS_SOCKET_FACTORY_PROPERTY, null)) {
            TrustManager[] tms;
            String keyStoreFile = properties.getProperty(JMXMP_KEYSTORE_FILE_PROPERTY);
            String keyStorePass = properties.getProperty(JMXMP_KEYSTORE_PASSWORD_PROPERTY, "");
            String keyStoreType = properties.getProperty(JMXMP_KEYSTORE_TYPE_PROPERTY, KeyStore.getDefaultType());
            String keyStoreKeyPass = properties.getProperty(JMXMP_KEYSTORE_KEY_PASSWORD_PROPERTY, "");
            KeyStore ks = KeyStore.getInstance(keyStoreType);
            if (keyStoreFile != null) {
                ks.load(new FileInputStream(keyStoreFile), keyStorePass.toCharArray());
            } else {
                ks.load(null, null);
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, keyStoreKeyPass.toCharArray());
            String trustStoreFile = properties.getProperty(JMXMP_TRUSTSTORE_FILE_PROPERTY);
            String trustStorePass = properties.getProperty(JMXMP_TRUSTSTORE_PASSWORD_PROPERTY, "");
            String trustStoreType = properties.getProperty(JMXMP_TRUSTSTORE_TYPE_PROPERTY, KeyStore.getDefaultType());
            if (trustStoreFile != null) {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                KeyStore ts = KeyStore.getInstance(trustStoreType);
                ts.load(new FileInputStream(trustStoreFile), trustStorePass.toCharArray());
                tmf.init(ts);
                tms = new TrustManager[]{JmxmpAgent.newInspectAllTrustManager((X509TrustManager)tmf.getTrustManagers()[0])};
            } else {
                tms = null;
                if (authenticating) {
                    System.err.println("Authentication required but no truststore supplied to JmxmpAgent. Client connections will likely fail.");
                }
            }
            SSLContext ctx = SSLContext.getInstance("TLSv1");
            ctx.init(kmf.getKeyManagers(), tms, null);
            SSLSocketFactory ssf = ctx.getSocketFactory();
            env.put(TLS_SOCKET_FACTORY_PROPERTY, ssf);
        }
    }

    public static final TrustManager newInspectAllTrustManager(final X509TrustManager delegate) {
        return new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                delegate.checkClientTrusted(chain, authType);
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                delegate.checkServerTrusted(chain, authType);
            }
        };
    }

    public static void main(String[] args) {
        JmxmpAgent.premain("");
    }
}

