/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.catalog.internal;

import com.google.common.annotations.Beta;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.typereg.ManagedBundle;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.core.catalog.internal.BasicBrooklynCatalog;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.typereg.RegisteredTypePredicates;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.osgi.VersionedName;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.Strings;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class CatalogBundleLoader {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogBundleLoader.class);
    private static final String CATALOG_BOM_URL = "catalog.bom";
    private ManagementContext managementContext;

    public CatalogBundleLoader(ManagementContext managementContext) {
        this.managementContext = managementContext;
    }

    public void scanForCatalog(Bundle bundle, boolean force, boolean validate) {
        this.scanForCatalog(bundle, force, validate, null);
    }

    public void scanForCatalog(Bundle bundle, boolean force, boolean validate, Map<RegisteredType, RegisteredType> result) {
        this.scanForCatalog(bundle, null, force, validate, result);
    }

    public void scanForCatalog(Bundle bundle, String bomText, boolean force, boolean validate, Map<RegisteredType, RegisteredType> result) {
        this.scanForCatalogInternal(bundle, bomText, force, validate, false, result);
    }

    @Deprecated
    public Iterable<? extends CatalogItem<?, ?>> scanForCatalogLegacy(Bundle bundle, boolean force) {
        LOG.warn("Bundle " + bundle + " being loaded with deprecated legacy loader");
        return this.scanForCatalogInternal((Bundle)bundle, null, (boolean)force, (boolean)true, (boolean)true, null).legacyResult;
    }

    private TemporaryInternalScanResult scanForCatalogInternal(Bundle bundle, String bomText, boolean force, boolean validate, boolean legacy, Map<RegisteredType, RegisteredType> resultNewFormat) {
        URL bomUrl;
        ManagedBundle mb = ((OsgiManager)((ManagementContextInternal)this.managementContext).getOsgiManager().get()).getManagedBundle(new VersionedName(bundle));
        TemporaryInternalScanResult result = new TemporaryInternalScanResult();
        result.legacyResult = MutableList.of();
        result.mapOfNewToReplaced = resultNewFormat;
        URL uRL = bomUrl = bomText != null ? null : bundle.getResource(CATALOG_BOM_URL);
        if (null != bomUrl) {
            LOG.debug("Catalog load, found catalog BOM in {} {} {}", (Object[])CatalogUtils.bundleIds(bundle));
            bomText = this.readBom(bomUrl);
        }
        if (null != bomText) {
            if (mb == null) {
                LOG.warn("Bundle " + bundle + " containing BOM is not managed by Brooklyn; using legacy item installation");
                legacy = true;
            }
            if (legacy) {
                result.legacyResult = this.managementContext.getCatalog().addItems(bomText, mb, force);
                for (CatalogItem<?, ?> item : result.legacyResult) {
                    LOG.debug("Added to catalog: {}, {}", (Object)item.getSymbolicName(), (Object)item.getVersion());
                }
            } else {
                this.managementContext.getCatalog().addTypesFromBundleBom(bomText, mb, force, result.mapOfNewToReplaced);
                if (validate) {
                    Map validationErrors;
                    MutableSet matches = MutableSet.copyOf((Iterable)this.managementContext.getTypeRegistry().getMatching(RegisteredTypePredicates.containingBundle(mb.getVersionedName())));
                    Set resultNames = result.mapOfNewToReplaced.keySet().stream().map(type -> type.getId()).collect(Collectors.toSet());
                    Set matchesNames = matches.stream().map(type -> type.getId()).collect(Collectors.toSet());
                    if (!matchesNames.containsAll(resultNames) || !resultNames.containsAll(matchesNames)) {
                        LOG.warn("Discrepancy in list of Brooklyn items found for " + mb.getVersionedName() + ": installer gave " + result + " (of " + result.mapOfNewToReplaced.keySet().size() + " total installed), but registry search gave " + matches + " (from " + matches.size() + " total found for this bundle)");
                    }
                    if (!(validationErrors = this.managementContext.getCatalog().validateTypes((Iterable)matches)).isEmpty()) {
                        throw Exceptions.propagate((String)("Failed to install " + mb.getVersionedName() + ", types " + validationErrors.keySet() + " gave errors"), (Iterable)Iterables.concat(validationErrors.values()));
                    }
                }
            }
            if (!legacy && BasicBrooklynCatalog.isNoBundleOrSimpleWrappingBundle(this.managementContext, mb)) {
                ((OsgiManager)((ManagementContextInternal)this.managementContext).getOsgiManager().get()).addInstalledWrapperBundle(mb);
            }
        } else {
            LOG.debug("No BOM found in {} {} {}", (Object[])CatalogUtils.bundleIds(bundle));
        }
        return result;
    }

    public void removeFromCatalog(CatalogItem<?, ?> item) {
        try {
            this.managementContext.getCatalog().deleteCatalogItem(item.getSymbolicName(), item.getVersion());
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            LOG.warn(Strings.join((Object[])new String[]{"Failed to remove", item.getSymbolicName(), item.getVersion(), "from catalog"}, (String)" "), (Throwable)e);
        }
    }

    public void removeFromCatalog(VersionedName n) {
        ((OsgiManager)((ManagementContextInternal)this.managementContext).getOsgiManager().get()).uninstallCatalogItemsFromBundle(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readBom(URL bom) {
        try (InputStream ins = bom.openStream();){
            String string = Streams.readFullyString((InputStream)ins);
            return string;
        }
        catch (IOException e) {
            throw Exceptions.propagateAnnotated((String)("Error loading Catalog BOM from " + bom), (Throwable)e);
        }
    }

    private static class TemporaryInternalScanResult {
        Iterable<? extends CatalogItem<?, ?>> legacyResult;
        Map<RegisteredType, RegisteredType> mapOfNewToReplaced;

        private TemporaryInternalScanResult() {
        }
    }
}

