/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.catalog.internal;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.mgmt.rebind.RebindSupport;
import org.apache.brooklyn.api.mgmt.rebind.mementos.CatalogItemMemento;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.typereg.OsgiBundleWithUrl;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.catalog.internal.CatalogBundleDto;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.core.mgmt.rebind.BasicCatalogItemRebindSupport;
import org.apache.brooklyn.core.objs.AbstractBrooklynObject;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.core.relations.EmptyRelationSupport;
import org.apache.brooklyn.core.typereg.RegisteredTypeNaming;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.flags.FlagUtils;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.http.auth.Credentials;
import org.apache.brooklyn.util.http.auth.UsernamePassword;
import org.apache.brooklyn.util.osgi.VersionedName;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CatalogItemDtoAbstract<T, SpecT>
extends AbstractBrooklynObject
implements CatalogItem<T, SpecT> {
    private static Logger LOG = LoggerFactory.getLogger(CatalogItemDtoAbstract.class);
    @SetFromFlag
    private String symbolicName;
    @SetFromFlag
    private String version = "0.0.0-SNAPSHOT";
    @SetFromFlag
    private String containingBundle;
    @SetFromFlag
    private String displayName;
    @SetFromFlag
    private String description;
    @SetFromFlag
    private String iconUrl;
    @SetFromFlag
    private String javaType;
    @Deprecated
    @SetFromFlag
    private String type;
    @SetFromFlag
    private String planYaml;
    @SetFromFlag
    private Collection<CatalogItem.CatalogBundle> libraries;
    @SetFromFlag
    private Set<Object> tags = Sets.newLinkedHashSet();
    @SetFromFlag
    private boolean deprecated;
    @SetFromFlag
    private boolean disabled;

    @Override
    public BrooklynObjectInternal.ConfigurationSupportInternal config() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BrooklynObjectInternal.SubscriptionSupportInternal subscriptions() {
        throw new UnsupportedOperationException();
    }

    public <U> U getConfig(ConfigKey<U> key) {
        return (U)this.config().get(key);
    }

    @Override
    public String getId() {
        return this.getCatalogItemId();
    }

    @Override
    public String getCatalogItemId() {
        return CatalogUtils.getVersionedId(this.getSymbolicName(), this.getVersion());
    }

    public String getJavaType() {
        if (this.javaType != null) {
            return this.javaType;
        }
        return this.type;
    }

    public String getContainingBundle() {
        return this.containingBundle;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public String getSymbolicName() {
        if (this.symbolicName != null) {
            return this.symbolicName;
        }
        return this.getJavaType();
    }

    public String getVersion() {
        if (this.version != null) {
            return this.version;
        }
        return "0.0.0-SNAPSHOT";
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Nonnull
    public Collection<CatalogItem.CatalogBundle> getLibraries() {
        if (this.libraries != null) {
            return ImmutableList.copyOf(this.libraries);
        }
        return Collections.emptyList();
    }

    @Nullable
    public String getPlanYaml() {
        return this.planYaml;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.symbolicName, this.containingBundle, this.planYaml, this.javaType, CatalogItemDtoAbstract.nullIfEmpty(this.libraries), this.version, this.getCatalogItemId(), this.getCatalogItemIdSearchPath()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CatalogItemDtoAbstract other = (CatalogItemDtoAbstract)obj;
        if (!Objects.equal((Object)this.symbolicName, (Object)other.symbolicName)) {
            return false;
        }
        if (!Objects.equal((Object)this.containingBundle, (Object)other.containingBundle)) {
            return false;
        }
        if (!Objects.equal((Object)this.planYaml, (Object)other.planYaml)) {
            return false;
        }
        if (!Objects.equal((Object)this.javaType, (Object)other.javaType)) {
            return false;
        }
        if (!Objects.equal(CatalogItemDtoAbstract.nullIfEmpty(this.libraries), CatalogItemDtoAbstract.nullIfEmpty(other.libraries))) {
            return false;
        }
        if (!Objects.equal((Object)this.getCatalogItemId(), (Object)other.getCatalogItemId())) {
            return false;
        }
        if (!Objects.equal(this.getCatalogItemIdSearchPath(), other.getCatalogItemIdSearchPath())) {
            return false;
        }
        if (!Objects.equal((Object)this.version, (Object)other.version)) {
            return false;
        }
        if (!Objects.equal((Object)this.deprecated, (Object)other.deprecated)) {
            return false;
        }
        if (!Objects.equal((Object)this.description, (Object)other.description)) {
            return false;
        }
        if (!Objects.equal((Object)this.displayName, (Object)other.displayName)) {
            return false;
        }
        if (!Objects.equal((Object)this.iconUrl, (Object)other.iconUrl)) {
            return false;
        }
        return Objects.equal(this.tags, other.tags);
    }

    private static <T> Collection<T> nullIfEmpty(Collection<T> coll) {
        if (coll == null || coll.isEmpty()) {
            return null;
        }
        return coll;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getId() + "/" + this.getDisplayName() + "]";
    }

    public abstract Class<SpecT> getSpecType();

    public RebindSupport<CatalogItemMemento> getRebindSupport() {
        return new BasicCatalogItemRebindSupport(this);
    }

    @Override
    public BrooklynObjectInternal.RelationSupportInternal<CatalogItem<T, SpecT>> relations() {
        return new EmptyRelationSupport<CatalogItem<T, SpecT>>(this);
    }

    @Override
    public void setDisplayName(String newName) {
        this.displayName = newName;
    }

    @Override
    protected CatalogItemDtoAbstract<T, SpecT> configure(Map<?, ?> flags) {
        FlagUtils.setFieldsFromFlags(flags, this);
        return this;
    }

    @Override
    public BrooklynObject.TagSupport tags() {
        return new BasicTagSupport();
    }

    @Override
    @Deprecated
    public void setCatalogItemId(String id) {
    }

    protected void setSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    protected void setVersion(String version) {
        this.version = version;
    }

    public void setContainingBundle(VersionedName versionedName) {
        this.containingBundle = Strings.toString((Object)versionedName);
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    protected void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    protected void setJavaType(String javaType) {
        this.javaType = javaType;
        this.type = null;
    }

    protected void setPlanYaml(String planYaml) {
        this.planYaml = planYaml;
    }

    protected void setLibraries(Collection<CatalogItem.CatalogBundle> libraries) {
        this.libraries = libraries;
    }

    protected void setTags(Set<Object> tags) {
        this.tags = tags;
    }

    public static Collection<CatalogItem.CatalogBundle> parseLibraries(Collection<?> possibleLibraries) {
        MutableList dto = MutableList.of();
        for (Object object : possibleLibraries) {
            String url;
            String version;
            String name;
            if (object instanceof Map) {
                Map entry = (Map)object;
                name = CatalogItemDtoAbstract.stringValOrNull(entry, "name");
                version = CatalogItemDtoAbstract.stringValOrNull(entry, "version");
                url = CatalogItemDtoAbstract.stringValOrNull(entry, "url");
                UsernamePassword cred = null;
                if (entry.containsKey("auth") && entry.get("auth") instanceof Map) {
                    Map auth = (Map)entry.get("auth");
                    cred = new UsernamePassword(CatalogItemDtoAbstract.stringValOrNull(auth, "username"), CatalogItemDtoAbstract.stringValOrNull(auth, "password"));
                }
                dto.add(new CatalogBundleDto(name, version, url, (Credentials)cred));
                continue;
            }
            if (object instanceof String) {
                String inlineRef = (String)object;
                if (inlineRef.contains("/") || inlineRef.contains("\\")) {
                    name = null;
                    version = null;
                    url = inlineRef;
                } else if (RegisteredTypeNaming.isGoodBrooklynTypeColonVersion(inlineRef) || RegisteredTypeNaming.isValidOsgiTypeColonVersion(inlineRef)) {
                    name = CatalogUtils.getSymbolicNameFromVersionedId(inlineRef);
                    version = CatalogUtils.getVersionFromVersionedId(inlineRef);
                    url = null;
                } else if (CatalogUtils.looksLikeVersionedId(inlineRef)) {
                    LOG.warn("Reference to library " + inlineRef + " is being treated as type but deprecated version syntax means in subsequent versions it will be treated as a URL.");
                    name = CatalogUtils.getSymbolicNameFromVersionedId(inlineRef);
                    version = CatalogUtils.getVersionFromVersionedId(inlineRef);
                    url = null;
                } else {
                    if (RegisteredTypeNaming.isUsableTypeColonVersion(inlineRef)) {
                        LOG.warn("Ambiguous library reference " + inlineRef + " is being treated as a URL even though it looks a bit like a bundle with a non-osgi-version.  Use strict OSGi versions to treat as a bundle. To suppress this message and force URL use a slash in the reference ");
                    }
                    name = null;
                    version = null;
                    url = inlineRef;
                }
                dto.add(new CatalogBundleDto(name, version, url));
                continue;
            }
            if (object instanceof OsgiBundleWithUrl) {
                OsgiBundleWithUrl bwu = (OsgiBundleWithUrl)object;
                dto.add(new CatalogBundleDto(bwu.getSymbolicName(), bwu.getSuppliedVersionString(), bwu.getUrl(), bwu.getUrlCredential(), bwu.getDeleteable()));
                continue;
            }
            if (object instanceof VersionedName) {
                dto.add(new CatalogBundleDto(((VersionedName)object).getSymbolicName(), ((VersionedName)object).getVersionString(), null));
                continue;
            }
            LOG.debug("Unexpected entry in libraries list neither string nor map: " + object);
        }
        return dto;
    }

    private static String stringValOrNull(Map<?, ?> map, String key) {
        Object val = map.get(key);
        return val != null ? String.valueOf(val) : null;
    }

    private class BasicTagSupport
    implements BrooklynObject.TagSupport {
        private BasicTagSupport() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setTagsIfNull() {
            CatalogItemDtoAbstract catalogItemDtoAbstract = CatalogItemDtoAbstract.this;
            synchronized (catalogItemDtoAbstract) {
                if (CatalogItemDtoAbstract.this.tags == null) {
                    CatalogItemDtoAbstract.this.tags = Sets.newLinkedHashSet();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nonnull
        public Set<Object> getTags() {
            CatalogItemDtoAbstract catalogItemDtoAbstract = CatalogItemDtoAbstract.this;
            synchronized (catalogItemDtoAbstract) {
                this.setTagsIfNull();
                return ImmutableSet.copyOf((Collection)CatalogItemDtoAbstract.this.tags);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsTag(Object tag) {
            CatalogItemDtoAbstract catalogItemDtoAbstract = CatalogItemDtoAbstract.this;
            synchronized (catalogItemDtoAbstract) {
                this.setTagsIfNull();
                return CatalogItemDtoAbstract.this.tags.contains(tag);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addTag(Object tag) {
            boolean result;
            CatalogItemDtoAbstract catalogItemDtoAbstract = CatalogItemDtoAbstract.this;
            synchronized (catalogItemDtoAbstract) {
                this.setTagsIfNull();
                result = CatalogItemDtoAbstract.this.tags.add(tag);
            }
            CatalogItemDtoAbstract.this.onTagsChanged();
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addTags(Iterable<?> newTags) {
            boolean result;
            CatalogItemDtoAbstract catalogItemDtoAbstract = CatalogItemDtoAbstract.this;
            synchronized (catalogItemDtoAbstract) {
                this.setTagsIfNull();
                result = Iterables.addAll((Collection)CatalogItemDtoAbstract.this.tags, newTags);
            }
            CatalogItemDtoAbstract.this.onTagsChanged();
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addTagsAtStart(Iterable<?> newTags) {
            boolean result;
            Set set = CatalogItemDtoAbstract.this.tags;
            synchronized (set) {
                MutableSet oldTags = MutableSet.copyOf((Iterable)CatalogItemDtoAbstract.this.tags);
                CatalogItemDtoAbstract.this.tags.clear();
                Iterables.addAll((Collection)CatalogItemDtoAbstract.this.tags, newTags);
                result = Iterables.addAll((Collection)CatalogItemDtoAbstract.this.tags, (Iterable)oldTags);
            }
            CatalogItemDtoAbstract.this.onTagsChanged();
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeTag(Object tag) {
            boolean result;
            CatalogItemDtoAbstract catalogItemDtoAbstract = CatalogItemDtoAbstract.this;
            synchronized (catalogItemDtoAbstract) {
                this.setTagsIfNull();
                result = CatalogItemDtoAbstract.this.tags.remove(tag);
            }
            CatalogItemDtoAbstract.this.onTagsChanged();
            return result;
        }
    }
}

