/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.config.external.vault;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Map;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.config.external.vault.VaultExternalConfigSupplier;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaultAppIdExternalConfigSupplier
extends VaultExternalConfigSupplier {
    private static final Logger LOG = LoggerFactory.getLogger(VaultAppIdExternalConfigSupplier.class);

    public VaultAppIdExternalConfigSupplier(ManagementContext managementContext, String name, Map<String, String> config) {
        super(managementContext, name, config);
    }

    @Override
    protected String initAndLogIn(Map<String, String> config) {
        ArrayList errors = Lists.newArrayListWithCapacity((int)1);
        String appId = config.get("appId");
        if (Strings.isBlank((CharSequence)appId)) {
            errors.add("missing configuration 'appId'");
        }
        if (!errors.isEmpty()) {
            String message = String.format("Problem configuration Vault external config supplier '%s': %s", this.name, Joiner.on((String)System.lineSeparator()).join((Iterable)errors));
            throw new IllegalArgumentException(message);
        }
        String userId = this.getUserId(config);
        LOG.info("Config supplier named {} using Vault at {} appID {} userID {} path {}", new Object[]{this.name, this.endpoint, appId, userId, this.path});
        String path = "v1/auth/app-id/login";
        ImmutableMap requestData = ImmutableMap.of((Object)"app_id", (Object)appId, (Object)"user_id", (Object)userId);
        ImmutableMap headers = MINIMAL_HEADERS;
        JsonObject response = this.apiPost(path, (ImmutableMap<String, String>)headers, (ImmutableMap<String, String>)requestData);
        return response.getAsJsonObject("auth").get("client_token").getAsString();
    }

    private String getUserId(Map<String, String> config) {
        String userId = config.get("userId");
        if (Strings.isBlank((CharSequence)userId)) {
            userId = VaultAppIdExternalConfigSupplier.getUserIdFromMacAddress();
        }
        return userId;
    }

    private static String getUserIdFromMacAddress() {
        byte[] mac;
        try {
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            mac = network.getHardwareAddress();
        }
        catch (Throwable t) {
            throw Exceptions.propagate((Throwable)t);
        }
        StringBuilder sb = new StringBuilder();
        for (byte aMac : mac) {
            sb.append(String.format("%02x", aMac));
        }
        return sb.toString();
    }
}

