/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.entity.internal;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.brooklyn.api.objs.Configurable;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtilsInternal {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigUtilsInternal.class);

    public static Map<?, ?> setAllConfigKeys(Map<?, ?> flags, Iterable<? extends ConfigKey<?>> configKeys, Configurable obj) {
        MutableMap unusedFlags = MutableMap.copyOf(flags);
        for (ConfigKey<?> key : configKeys) {
            ConfigValue values = ConfigUtilsInternal.getValue(unusedFlags, key);
            Maybe<Object> valueToUse = values.preferredValue();
            if (!valueToUse.isPresent()) continue;
            ConfigUtilsInternal.setValue(obj, key, valueToUse.get());
            values.logIfDeprecatedValue(obj, key);
        }
        return unusedFlags;
    }

    private static void setValue(Configurable obj, ConfigKey<?> key, Object val) {
        obj.config().set(key, val);
    }

    private static ConfigValue getValue(Map<?, ?> flags, ConfigKey<?> key) {
        Maybe val;
        String keyName = key.getName();
        if (flags.containsKey(keyName)) {
            val = Maybe.of(flags.get(keyName));
            flags.remove(keyName);
        } else {
            val = Maybe.absent();
        }
        LinkedHashMap<String, Object> deprecatedValues = new LinkedHashMap<String, Object>(key.getDeprecatedNames().size());
        for (String deprecatedName : key.getDeprecatedNames()) {
            if (!flags.containsKey(deprecatedName)) continue;
            deprecatedValues.put(deprecatedName, flags.get(deprecatedName));
            flags.remove(deprecatedName);
        }
        return new ConfigValue((Maybe<Object>)val, deprecatedValues);
    }

    public static <T> Map<String, ConfigKey<?>> findConfigKeys(Class<? extends T> clazz, T optionalInstance) {
        try {
            LinkedHashMap result = Maps.newLinkedHashMap();
            LinkedHashMap configFields = Maps.newLinkedHashMap();
            for (Field f : clazz.getFields()) {
                boolean isConfigKey = ConfigKey.class.isAssignableFrom(f.getType());
                if (!isConfigKey && !ConfigKey.HasConfigKey.class.isAssignableFrom(f.getType())) continue;
                if (!Modifier.isStatic(f.getModifiers())) {
                    LOG.warn("Discouraged use of non-static config key " + f + " defined in " + (optionalInstance != null ? optionalInstance : clazz));
                    if (optionalInstance == null) continue;
                }
                ConfigKey k = isConfigKey ? (ConfigKey)f.get(optionalInstance) : ((ConfigKey.HasConfigKey)f.get(optionalInstance)).getConfigKey();
                Field alternativeField = (Field)configFields.get(k.getName());
                Field definitiveField = alternativeField != null ? Reflections.inferSubbestField((Field)alternativeField, (Field)f) : f;
                boolean skip = false;
                if (definitiveField != f && alternativeField.get(optionalInstance) == f.get(optionalInstance)) {
                    skip = true;
                }
                if (skip) continue;
                if (definitiveField == f) {
                    result.put(k.getName(), k);
                    configFields.put(k.getName(), f);
                    continue;
                }
                if (definitiveField != null) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("multiple definitions for config key {} on {}; preferring that in sub-class: {} to {}", new Object[]{k.getName(), optionalInstance != null ? optionalInstance : clazz, alternativeField, f});
                    continue;
                }
                if (definitiveField != null) continue;
                LOG.warn("multiple definitions for config key {} on {}; preferring {} to {}", new Object[]{k.getName(), optionalInstance != null ? optionalInstance : clazz, alternativeField, f});
            }
            return result;
        }
        catch (IllegalAccessException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private static class ConfigValue {
        final Maybe<Object> val;
        final Map<String, Object> deprecatedValues;

        ConfigValue(Maybe<Object> val, Map<String, Object> deprecatedValues) {
            this.val = val;
            this.deprecatedValues = deprecatedValues;
        }

        Maybe<Object> preferredValue() {
            if (this.val.isPresent()) {
                return this.val;
            }
            return this.deprecatedValues.isEmpty() ? Maybe.absent() : Maybe.of((Object)Iterables.get(this.deprecatedValues.values(), (int)0));
        }

        void logIfDeprecatedValue(Configurable obj, ConfigKey<?> key) {
            if (this.deprecatedValues.isEmpty()) {
                return;
            }
            if (this.val.isPresent()) {
                LOG.warn("Ignoring deprecated config value(s) on " + obj + " because contains value for '" + key.getName() + "', other deprecated name(s) present were: " + this.deprecatedValues.keySet());
            } else if (this.deprecatedValues.size() == 1) {
                LOG.warn("Using deprecated config value on " + obj + ", should use '" + key.getName() + "', but used '" + (String)Iterables.getOnlyElement(this.deprecatedValues.keySet()) + "'");
            } else {
                LOG.warn("Using deprecated config value on " + obj + ", should use '" + key.getName() + "', but used '" + (String)Iterables.get(this.deprecatedValues.keySet(), (int)1) + "' and ignored values present for other deprecated name(s) " + Iterables.skip(this.deprecatedValues.keySet(), (int)1));
            }
        }
    }
}

