/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location;

import com.google.common.annotations.Beta;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.io.CharStreams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.apache.brooklyn.api.location.HardwareDetails;
import org.apache.brooklyn.api.location.MachineDetails;
import org.apache.brooklyn.api.location.OsDetails;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.core.location.BasicHardwareDetails;
import org.apache.brooklyn.core.location.BasicOsDetails;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.TaskTags;
import org.apache.brooklyn.util.core.task.ssh.internal.AbstractSshExecTaskFactory;
import org.apache.brooklyn.util.core.task.ssh.internal.PlainSshExecTaskFactory;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.stream.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class BasicMachineDetails
implements MachineDetails {
    public static final Logger LOG = LoggerFactory.getLogger(BasicMachineDetails.class);
    private final HardwareDetails hardwareDetails;
    private final OsDetails osDetails;

    public BasicMachineDetails(HardwareDetails hardwareDetails, OsDetails osDetails) {
        this.hardwareDetails = (HardwareDetails)Preconditions.checkNotNull((Object)hardwareDetails, (Object)"hardwareDetails");
        this.osDetails = (OsDetails)Preconditions.checkNotNull((Object)osDetails, (Object)"osDetails");
    }

    @Nonnull
    public HardwareDetails getHardwareDetails() {
        return this.hardwareDetails;
    }

    @Nonnull
    public OsDetails getOsDetails() {
        return this.osDetails;
    }

    public String toString() {
        return MoreObjects.toStringHelper(MachineDetails.class).add("os", (Object)this.osDetails).add("hardware", (Object)this.hardwareDetails).toString();
    }

    @Beta
    public static BasicMachineDetails forSshMachineLocationLive(SshMachineLocation location) {
        return DynamicTasks.get(TaskTags.markInessential(BasicMachineDetails.taskForSshMachineLocation(location)));
    }

    public static Task<BasicMachineDetails> taskForSshMachineLocation(SshMachineLocation location) {
        List script;
        BufferedReader reader = new BufferedReader(Streams.reader((InputStream)new ResourceUtils(BasicMachineDetails.class).getResourceFromUrl("classpath://org/apache/brooklyn/location/basic/os-details.sh")));
        try {
            script = CharStreams.readLines((Readable)reader);
        }
        catch (IOException e) {
            LOG.error("Error reading os-details script", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                LOG.error("Error closing os-details script reader", (Throwable)e);
            }
        }
        Task task = ((AbstractSshExecTaskFactory)((PlainSshExecTaskFactory)((PlainSshExecTaskFactory)new PlainSshExecTaskFactory(location, (List<String>)script).summary("Getting machine details for: " + location)).requiringZeroAndReturningStdout()).returning((java.util.function.Function)BasicMachineDetails.taskToMachineDetailsFunction(location))).newTask().asTask();
        return task;
    }

    private static Function<ProcessTaskWrapper<?>, BasicMachineDetails> taskToMachineDetailsFunction(final SshMachineLocation location) {
        return new Function<ProcessTaskWrapper<?>, BasicMachineDetails>(){

            public BasicMachineDetails apply(ProcessTaskWrapper<?> input) {
                if (input.getExitCode() != 0) {
                    LOG.warn("Non-zero exit code when fetching machine details for {}; guessing anonymous linux", (Object)location);
                    return new BasicMachineDetails(new BasicHardwareDetails(null, null), BasicOsDetails.Factory.ANONYMOUS_LINUX);
                }
                String stdout = input.getStdout();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found following details at {}: {}", (Object)location, (Object)stdout);
                }
                Iterable lines = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"\r\n")).omitEmptyStrings().split((CharSequence)stdout);
                HashMap details = Maps.newHashMap();
                for (String line : lines) {
                    Optional<Map.Entry<String, String>> detail = this.splitLine(line, ":");
                    if (!detail.isPresent()) continue;
                    details.put(((Map.Entry)detail.get()).getKey(), ((Map.Entry)detail.get()).getValue());
                }
                String name = (String)details.remove("name");
                String version = (String)details.remove("version");
                String architecture = (String)details.remove("architecture");
                Integer ram = this.intOrNull(details, "ram");
                Integer cpuCount = this.intOrNull(details, "cpus");
                if (!details.isEmpty()) {
                    LOG.debug("Unused keys from os-details script: " + Joiner.on((String)", ").join(details.keySet()));
                }
                BasicOsDetails osDetails = new BasicOsDetails(name, architecture, version);
                BasicHardwareDetails hardwareDetails = new BasicHardwareDetails(cpuCount, ram);
                BasicMachineDetails machineDetails = new BasicMachineDetails(hardwareDetails, osDetails);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Machine details for {}: {}", (Object)location, (Object)machineDetails);
                }
                return machineDetails;
            }

            private Integer intOrNull(Map<String, String> details, String key) {
                try {
                    return Integer.valueOf(details.remove(key));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            private Optional<Map.Entry<String, String>> splitLine(String sequence, String separator) {
                int index = sequence.indexOf(separator);
                if (index < 0) {
                    return Optional.absent();
                }
                String key = sequence.substring(0, index).trim();
                String value = sequence.substring(index + 1).trim();
                return Optional.of(new AbstractMap.SimpleEntry<String, String>(key, value));
            }
        };
    }
}

