/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.rebind.dto;

import java.util.Collection;
import java.util.Map;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.EntityMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.TreeNode;

public class MementoValidators {
    private MementoValidators() {
    }

    public static void validateMemento(BrooklynMemento memento) {
        Collection locationIds = memento.getLocationIds();
        MementoValidators.validateParentChildRelations(memento.getLocationMementos());
        MementoValidators.validateParentChildRelations(memento.getEntityMementos());
        for (String id : memento.getEntityIds()) {
            EntityMemento entityMemento = memento.getEntityMemento(id);
            for (String location : entityMemento.getLocations()) {
                if (locationIds.contains(location)) continue;
                throw new IllegalStateException("Location " + location + " missing, for entity " + entityMemento);
            }
        }
    }

    private static void validateParentChildRelations(Map<String, ? extends TreeNode> nodes) {
        for (Map.Entry<String, ? extends TreeNode> entry : nodes.entrySet()) {
            TreeNode node = entry.getValue();
            if (node.getParent() != null && !nodes.containsKey(node.getParent())) {
                throw new IllegalStateException("Parent " + node.getParent() + " missing, for " + node);
            }
            for (String childId : node.getChildren()) {
                if (childId == null) {
                    throw new IllegalStateException("Null child, for " + node);
                }
                if (nodes.containsKey(childId)) continue;
                throw new IllegalStateException("Child " + childId + " missing, for " + node);
            }
        }
    }
}

