/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.rebind.transformer;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.mgmt.rebind.RebindExceptionHandler;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoPersister;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoRawData;
import org.apache.brooklyn.api.objs.BrooklynObjectType;
import org.apache.brooklyn.core.mgmt.rebind.transformer.RawDataTransformer;
import org.apache.brooklyn.core.mgmt.rebind.transformer.impl.XsltTransformer;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.text.TemplateProcessor;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class CompoundTransformer {
    private static final Logger LOG = LoggerFactory.getLogger(CompoundTransformer.class);
    public static final CompoundTransformer NOOP = CompoundTransformer.builder().build();
    private final Multimap<BrooklynObjectType, RawDataTransformer> rawDataTransformers;
    private final Multimap<BrooklynObjectType, String> deletions;

    public static Builder builder() {
        return new Builder();
    }

    protected CompoundTransformer(Builder builder) {
        this.rawDataTransformers = builder.rawDataTransformers;
        this.deletions = builder.deletions;
    }

    public BrooklynMementoRawData transform(BrooklynMementoPersister reader, RebindExceptionHandler exceptionHandler) throws Exception {
        BrooklynMementoRawData rawData = reader.loadMementoRawData(exceptionHandler);
        return this.transform(rawData);
    }

    public BrooklynMementoRawData transform(BrooklynMementoRawData rawData) throws Exception {
        MutableMap entities = MutableMap.copyOf((Map)rawData.getEntities());
        MutableMap locations = MutableMap.copyOf((Map)rawData.getLocations());
        MutableMap policies = MutableMap.copyOf((Map)rawData.getPolicies());
        MutableMap enrichers = MutableMap.copyOf((Map)rawData.getEnrichers());
        MutableMap feeds = MutableMap.copyOf((Map)rawData.getFeeds());
        MutableMap catalogItems = MutableMap.copyOf((Map)rawData.getCatalogItems());
        MutableMap bundles = MutableMap.copyOf((Map)rawData.getBundles());
        MutableMap bundleJars = MutableMap.copyOf((Map)rawData.getBundleJars());
        block20: for (BrooklynObjectType type : BrooklynObjectType.values()) {
            ImmutableSet itemsToDelete = ImmutableSet.copyOf((Collection)this.deletions.get((Object)type));
            switch (type) {
                case ENTITY: {
                    Sets.SetView missing = Sets.difference((Set)itemsToDelete, entities.keySet());
                    if (missing.size() > 0) {
                        LOG.warn("Unable to delete " + type + " id" + Strings.s((int)missing.size()) + " (" + missing + "), because not found in persisted state (continuing)");
                    }
                    entities.keySet().removeAll((Collection<?>)itemsToDelete);
                    continue block20;
                }
                case LOCATION: {
                    Sets.SetView missing = Sets.difference((Set)itemsToDelete, locations.keySet());
                    if (missing.size() > 0) {
                        LOG.warn("Unable to delete " + type + " id" + Strings.s((int)missing.size()) + " (" + missing + "), because not found in persisted state (continuing)");
                    }
                    locations.keySet().removeAll((Collection<?>)itemsToDelete);
                    continue block20;
                }
                case POLICY: {
                    Sets.SetView missing = Sets.difference((Set)itemsToDelete, policies.keySet());
                    if (missing.size() > 0) {
                        LOG.warn("Unable to delete " + type + " id" + Strings.s((int)missing.size()) + " (" + missing + "), because not found in persisted state (continuing)");
                    }
                    policies.keySet().removeAll((Collection<?>)itemsToDelete);
                    continue block20;
                }
                case ENRICHER: {
                    Sets.SetView missing = Sets.difference((Set)itemsToDelete, enrichers.keySet());
                    if (missing.size() > 0) {
                        LOG.warn("Unable to delete " + type + " id" + Strings.s((int)missing.size()) + " (" + missing + "), because not found in persisted state (continuing)");
                    }
                    enrichers.keySet().removeAll((Collection<?>)itemsToDelete);
                    continue block20;
                }
                case FEED: {
                    Sets.SetView missing = Sets.difference((Set)itemsToDelete, feeds.keySet());
                    if (missing.size() > 0) {
                        LOG.warn("Unable to delete " + type + " id" + Strings.s((int)missing.size()) + " (" + missing + "), because not found in persisted state (continuing)");
                    }
                    feeds.keySet().removeAll((Collection<?>)itemsToDelete);
                    continue block20;
                }
                case CATALOG_ITEM: {
                    Sets.SetView missing = Sets.difference((Set)itemsToDelete, catalogItems.keySet());
                    if (missing.size() > 0) {
                        LOG.warn("Unable to delete " + type + " id" + Strings.s((int)missing.size()) + " (" + missing + "), because not found in persisted state (continuing)");
                    }
                    catalogItems.keySet().removeAll((Collection<?>)itemsToDelete);
                    continue block20;
                }
                case MANAGED_BUNDLE: {
                    Sets.SetView missing = Sets.difference((Set)itemsToDelete, bundles.keySet());
                    if (missing.size() > 0) {
                        LOG.warn("Unable to delete " + type + " id" + Strings.s((int)missing.size()) + " (" + missing + "), because not found in persisted state (continuing)");
                    }
                    bundles.keySet().removeAll((Collection<?>)itemsToDelete);
                    for (String item : itemsToDelete) {
                        bundleJars.remove(item + ".jar");
                    }
                    continue block20;
                }
                case UNKNOWN: {
                    continue block20;
                }
                default: {
                    throw new IllegalStateException("Unexpected brooklyn object type " + type);
                }
            }
        }
        for (BrooklynObjectType type : BrooklynObjectType.values()) {
            Collection transformers = this.rawDataTransformers.get((Object)type);
            block23: for (RawDataTransformer transformer : transformers) {
                switch (type) {
                    case ENTITY: {
                        for (Map.Entry entry : entities.entrySet()) {
                            entry.setValue(transformer.transform((String)entry.getValue()));
                        }
                        continue block23;
                    }
                    case LOCATION: {
                        for (Map.Entry entry : locations.entrySet()) {
                            entry.setValue(transformer.transform((String)entry.getValue()));
                        }
                        continue block23;
                    }
                    case POLICY: {
                        for (Map.Entry entry : policies.entrySet()) {
                            entry.setValue(transformer.transform((String)entry.getValue()));
                        }
                        continue block23;
                    }
                    case ENRICHER: {
                        for (Map.Entry entry : enrichers.entrySet()) {
                            entry.setValue(transformer.transform((String)entry.getValue()));
                        }
                        continue block23;
                    }
                    case FEED: {
                        for (Map.Entry entry : feeds.entrySet()) {
                            entry.setValue(transformer.transform((String)entry.getValue()));
                        }
                        continue block23;
                    }
                    case CATALOG_ITEM: {
                        for (Map.Entry entry : catalogItems.entrySet()) {
                            entry.setValue(transformer.transform((String)entry.getValue()));
                        }
                        continue block23;
                    }
                    case MANAGED_BUNDLE: {
                        break;
                    }
                    case UNKNOWN: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected brooklyn object type " + type);
                    }
                }
            }
        }
        return BrooklynMementoRawData.builder().planeId(rawData.getPlaneId()).entities((Map)entities).locations((Map)locations).policies((Map)policies).enrichers((Map)enrichers).feeds((Map)feeds).catalogItems((Map)catalogItems).bundles((Map)bundles).bundleJars((Map)bundleJars).build();
    }

    @VisibleForTesting
    Multimap<BrooklynObjectType, RawDataTransformer> getRawDataTransformers() {
        return ArrayListMultimap.create(this.rawDataTransformers);
    }

    @VisibleForTesting
    Multimap<BrooklynObjectType, String> getDeletions() {
        return HashMultimap.create(this.deletions);
    }

    public static class Builder {
        private final Multimap<BrooklynObjectType, RawDataTransformer> rawDataTransformers = ArrayListMultimap.create();
        private final Multimap<BrooklynObjectType, String> deletions = HashMultimap.create();

        public Builder rawDataTransformer(RawDataTransformer val) {
            for (BrooklynObjectType type : BrooklynObjectType.values()) {
                this.rawDataTransformer(type, val);
            }
            return this;
        }

        public Builder rawDataTransformer(BrooklynObjectType type, RawDataTransformer val) {
            this.rawDataTransformers.put(Preconditions.checkNotNull((Object)type, (Object)"type"), Preconditions.checkNotNull((Object)val, (Object)"val"));
            return this;
        }

        public Builder xsltTransformer(String xslt) {
            XsltTransformer xsltTransformer = new XsltTransformer(xslt);
            for (BrooklynObjectType type : BrooklynObjectType.values()) {
                this.rawDataTransformer(type, xsltTransformer);
            }
            return this;
        }

        public Builder xsltTransformer(BrooklynObjectType type, String xslt) {
            XsltTransformer xsltTransformer = new XsltTransformer(xslt);
            this.rawDataTransformer(type, xsltTransformer);
            return this;
        }

        protected Builder xsltTransformerFromXsltFreemarkerTemplateUrl(String templateUrl, Map<String, String> vars) {
            String xsltTemplate = ResourceUtils.create(this).getResourceAsString(templateUrl);
            String xslt = TemplateProcessor.processTemplateContents("xslt from url " + templateUrl, xsltTemplate, vars);
            return this.xsltTransformer(xslt);
        }

        protected Builder xsltTransformerRecursiveCopyWithExtraRules(String ... rules) {
            String xsltTemplate = ResourceUtils.create(this).getResourceAsString("classpath://org/apache/brooklyn/core/mgmt/rebind/transformer/recursiveCopyWithExtraRules.xslt");
            String xslt = TemplateProcessor.processTemplateContents("xslt recursive copy from url", xsltTemplate, (Map<String, ? extends Object>)ImmutableMap.of((Object)"extra_rules", (Object)Strings.join((Object[])rules, (String)"\n")));
            return this.xsltTransformer(xslt);
        }

        public Builder xmlReplaceItem(String xpathToMatch, String newValue) {
            return this.xsltTransformerRecursiveCopyWithExtraRules("<xsl:template match=\"" + xpathToMatch + "\">" + newValue + "</xsl:template>");
        }

        public Builder xmlDeleteItem(String xpathToMatch) {
            return this.xsltTransformerRecursiveCopyWithExtraRules("<xsl:template match=\"" + xpathToMatch + "\"></xsl:template>");
        }

        public Builder xmlRenameTag(String xpathToMatch, String newValue) {
            return this.xmlReplaceItem(xpathToMatch, "<" + newValue + "><xsl:apply-templates select=\"@*|node()\" /></" + newValue + ">");
        }

        public Builder xmlChangeAttribute(String xpathToMatch, String newValue) {
            return this.xmlReplaceItem(xpathToMatch, "<xsl:attribute name='{local-name()}'>" + newValue + "</xsl:attribute>");
        }

        public Builder renameType(String oldVal, String newVal) {
            return this.xmlReplaceItem("type/text()[.='" + this.toXstreamClassnameFormat(oldVal) + "']", this.toXstreamClassnameFormat(newVal));
        }

        public Builder renameClassTag(String oldVal, String newVal) {
            return this.xmlRenameTag(this.toXstreamClassnameFormat(oldVal), this.toXstreamClassnameFormat(newVal));
        }

        public Builder renameField(String clazz, String oldVal, String newVal) {
            return this.xmlRenameTag(this.toXstreamClassnameFormat(clazz) + "/" + this.toXstreamClassnameFormat(oldVal), this.toXstreamClassnameFormat(newVal));
        }

        public Builder changeCatalogItemId(String oldSymbolicName, String oldVersion, String newSymbolicName, String newVersion) {
            if (oldVersion == null) {
                return this.changeCatalogItemId(oldSymbolicName, newSymbolicName, newVersion);
            }
            return this.xmlReplaceItem("*[self::catalogItemId|parent::catalogItemIdSearchPath]/text()[.='" + (String)Preconditions.checkNotNull((Object)oldSymbolicName, (Object)"old_symbolic_name") + ":" + (String)Preconditions.checkNotNull((Object)oldVersion, (Object)"old_version") + "']", (String)Preconditions.checkNotNull((Object)newSymbolicName, (Object)"new_symbolic_name") + ":" + (String)Preconditions.checkNotNull((Object)newVersion, (Object)"new_version"));
        }

        public Builder changeCatalogItemId(String oldSymbolicName, String newSymbolicName, String newVersion) {
            return this.xmlReplaceItem("*[self::catalogItemId|parent::catalogItemIdSearchPath]/text()[starts-with(.,'" + (String)Preconditions.checkNotNull((Object)oldSymbolicName, (Object)"old_symbolic_name") + ":')]", (String)Preconditions.checkNotNull((Object)newSymbolicName, (Object)"new_symbolic_name") + ":" + (String)Preconditions.checkNotNull((Object)newVersion, (Object)"new_version"));
        }

        public Builder renameClass(String oldName, String newName) {
            return this.renameClassTag(oldName, newName).xmlChangeAttribute("//@class[.='" + oldName + "']", newName).renameType(oldName, newName);
        }

        private String toXstreamClassnameFormat(String val) {
            return val.contains("$") ? val.replace("$", "_-") : val;
        }

        public Builder deletion(BrooklynObjectType type, Iterable<? extends String> ids) {
            this.deletions.putAll((Object)type, ids);
            return this;
        }

        public CompoundTransformer build() {
            return new CompoundTransformer(this);
        }
    }
}

