/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.rebind.transformer.impl;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPathConstants;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoRawData;
import org.apache.brooklyn.api.objs.BrooklynObjectType;
import org.apache.brooklyn.core.mgmt.rebind.transformer.CompoundTransformer;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.xstream.XmlUtil;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Beta
public class DeleteOrphanedStateTransformer
extends CompoundTransformer {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteOrphanedStateTransformer.class);

    public static Builder builder() {
        return new Builder();
    }

    protected DeleteOrphanedStateTransformer(Builder builder) {
        super(builder);
    }

    @Override
    public BrooklynMementoRawData transform(BrooklynMementoRawData input) {
        ReferencedState stateReferencedFromXpath = new ReachabilityXpathInspector().inspect(input);
        ReferencedState stateToKeepFromGrep = new ReachabilityGrepInspector().inspect(input);
        ReferencedState stateToKeepFromXpath = stateReferencedFromXpath.filterForExtant(input);
        ReferencedState.warnOfDifferences(stateToKeepFromXpath, stateToKeepFromGrep);
        ReferencedState stateToKeep = ReferencedState.union(stateToKeepFromXpath, stateToKeepFromGrep);
        Map locationsToKeep = this.copyRetainingKeys(input.getLocations(), stateToKeep.locations);
        Map enrichersToKeep = this.copyRetainingKeys(input.getEnrichers(), stateToKeep.enrichers);
        Map policiesToKeep = this.copyRetainingKeys(input.getPolicies(), stateToKeep.policies);
        Map feedsToKeep = this.copyRetainingKeys(input.getFeeds(), stateToKeep.feeds);
        Sets.SetView locsToDelete = Sets.difference(input.getLocations().keySet(), locationsToKeep.keySet());
        Sets.SetView enrichersToDelete = Sets.difference(input.getEnrichers().keySet(), enrichersToKeep.keySet());
        Sets.SetView policiesToDelete = Sets.difference(input.getPolicies().keySet(), policiesToKeep.keySet());
        Sets.SetView feedsToDelete = Sets.difference(input.getFeeds().keySet(), feedsToKeep.keySet());
        LOG.info("Deleting {} orphaned location{} (of {}): {}", new Object[]{locsToDelete.size(), Strings.s((int)locsToDelete.size()), input.getLocations().size(), locsToDelete});
        LOG.info("Deleting {} orphaned enricher{} (of {}): {}", new Object[]{enrichersToDelete.size(), Strings.s((int)enrichersToDelete.size()), input.getEnrichers().size(), enrichersToDelete});
        LOG.info("Deleting {} orphaned polic{} (of {}): {}", new Object[]{policiesToDelete.size(), policiesToDelete.size() == 1 ? "y" : "ies", input.getPolicies().size(), policiesToDelete});
        LOG.info("Deleting {} orphaned feed{} (of {}): {}", new Object[]{feedsToDelete.size(), Strings.s((int)feedsToDelete.size()), input.getFeeds().size(), feedsToDelete});
        return BrooklynMementoRawData.builder().planeId(input.getPlaneId()).brooklynVersion(input.getBrooklynVersion()).catalogItems(input.getCatalogItems()).entities(input.getEntities()).locations(locationsToKeep).enrichers(enrichersToKeep).policies(policiesToKeep).feeds(feedsToKeep).build();
    }

    protected <K, V> Map<K, V> copyRetainingKeys(Map<K, V> orig, Set<? extends K> keysToKeep) {
        MutableMap result = MutableMap.of();
        for (Map.Entry<K, V> entry : orig.entrySet()) {
            if (!keysToKeep.contains(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    protected static class ReferencedState {
        protected Set<String> locations = ImmutableSet.of();
        protected Set<String> feeds = ImmutableSet.of();
        protected Set<String> enrichers = ImmutableSet.of();
        protected Set<String> policies = ImmutableSet.of();

        protected ReferencedState() {
        }

        public static ReferencedState union(ReferencedState s1, ReferencedState s2) {
            ReferencedState result = new ReferencedState();
            result.locations((Set<String>)ImmutableSet.copyOf((Iterable)Iterables.concat(s1.locations, s2.locations)));
            result.enrichers((Set<String>)ImmutableSet.copyOf((Iterable)Iterables.concat(s1.enrichers, s2.enrichers)));
            result.policies((Set<String>)ImmutableSet.copyOf((Iterable)Iterables.concat(s1.policies, s2.policies)));
            result.feeds((Set<String>)ImmutableSet.copyOf((Iterable)Iterables.concat(s1.feeds, s2.feeds)));
            return result;
        }

        public static void warnOfDifferences(ReferencedState s1, ReferencedState s2) {
            Sets.SetView locDiffs = Sets.symmetricDifference(s1.locations, s2.locations);
            Sets.SetView enricherDiffs = Sets.symmetricDifference(s1.enrichers, s2.enrichers);
            Sets.SetView policyDiffs = Sets.symmetricDifference(s1.policies, s2.policies);
            Sets.SetView feedDiffs = Sets.symmetricDifference(s1.feeds, s2.feeds);
            if (locDiffs.size() > 0) {
                LOG.warn("Deletion of orphan state found unusually referenced locations (keeping): " + locDiffs);
            }
            if (enricherDiffs.size() > 0) {
                LOG.warn("Deletion of orphan state found unusually referenced enrichers (keeping): " + enricherDiffs);
            }
            if (policyDiffs.size() > 0) {
                LOG.warn("Deletion of orphan state found unusually referenced policies (keeping): " + policyDiffs);
            }
            if (feedDiffs.size() > 0) {
                LOG.warn("Deletion of orphan state found unusually referenced feeds (keeping): " + feedDiffs);
            }
        }

        public ReferencedState filterForExtant(BrooklynMementoRawData input) {
            ReferencedState result = new ReferencedState();
            result.locations((Set<String>)Sets.intersection(this.locations, input.getLocations().keySet()));
            result.enrichers((Set<String>)Sets.intersection(this.enrichers, input.getEnrichers().keySet()));
            result.policies((Set<String>)Sets.intersection(this.policies, input.getPolicies().keySet()));
            result.feeds((Set<String>)Sets.intersection(this.feeds, input.getFeeds().keySet()));
            return result;
        }

        protected ReferencedState locations(Set<String> vals) {
            this.locations = vals;
            return this;
        }

        protected ReferencedState feeds(Set<String> vals) {
            this.feeds = vals;
            return this;
        }

        protected ReferencedState enrichers(Set<String> vals) {
            this.enrichers = vals;
            return this;
        }

        protected ReferencedState policies(Set<String> vals) {
            this.policies = vals;
            return this;
        }
    }

    protected static class ReachabilityGrepInspector {
        protected ReachabilityGrepInspector() {
        }

        protected ReferencedState inspect(BrooklynMementoRawData input) {
            LinkedHashSet locations = Sets.newLinkedHashSet();
            LinkedHashSet feeds = Sets.newLinkedHashSet();
            LinkedHashSet enrichers = Sets.newLinkedHashSet();
            LinkedHashSet policies = Sets.newLinkedHashSet();
            for (String string : input.getEnrichers().keySet()) {
                if (!this.isMentionedBy(string, BrooklynObjectType.ENTITY, input)) continue;
                enrichers.add(string);
            }
            for (String string : input.getPolicies().keySet()) {
                if (!this.isMentionedBy(string, BrooklynObjectType.ENTITY, input)) continue;
                policies.add(string);
            }
            for (String string : input.getFeeds().keySet()) {
                if (!this.isMentionedBy(string, BrooklynObjectType.ENTITY, input)) continue;
                feeds.add(string);
            }
            block3: for (Map.Entry entry : input.getLocations().entrySet()) {
                String id = (String)entry.getKey();
                String locationState = (String)entry.getValue();
                if (locationState.contains("PortForwardManager")) {
                    locations.add(id);
                    continue;
                }
                for (BrooklynObjectType type : ImmutableList.of((Object)BrooklynObjectType.ENTITY, (Object)BrooklynObjectType.ENRICHER, (Object)BrooklynObjectType.POLICY, (Object)BrooklynObjectType.FEED, (Object)BrooklynObjectType.CATALOG_ITEM)) {
                    if (!this.isMentionedBy(id, type, input)) continue;
                    locations.add(id);
                    continue block3;
                }
            }
            Object locsToInspect = MutableSet.copyOf((Iterable)locations);
            while (locsToInspect.size() > 0) {
                MutableMap mutableMap = MutableMap.copyOf((Map)input.getLocations());
                mutableMap.keySet().retainAll((Collection<?>)locsToInspect);
                Sets.SetView unreachedLocs = Sets.difference(input.getLocations().keySet(), (Set)locations);
                LinkedHashSet newlyDiscoveredLocs = Sets.newLinkedHashSet();
                for (String id : unreachedLocs) {
                    if (!this.isMentionedBy(id, mutableMap.values())) continue;
                    newlyDiscoveredLocs.add(id);
                }
                locations.addAll(newlyDiscoveredLocs);
                locsToInspect = newlyDiscoveredLocs;
            }
            return new ReferencedState().locations(locations).enrichers(enrichers).policies(policies).feeds(feeds);
        }

        protected boolean isMentionedBy(String id, BrooklynObjectType type, BrooklynMementoRawData input) {
            return this.isMentionedBy(id, input.getObjectsOfType(type).values());
        }

        protected boolean isMentionedBy(String id, Iterable<String> states) {
            for (String state : states) {
                if (!state.contains(id)) continue;
                return true;
            }
            return false;
        }
    }

    protected static class ReachabilityXpathInspector {
        protected ReachabilityXpathInspector() {
        }

        public ReferencedState inspect(BrooklynMementoRawData input) {
            return new ReferencedState().locations(this.findAllReferencedLocations(input)).enrichers(this.findAllReferencedEnrichers(input)).policies(this.findAllReferencedPolicies(input)).feeds(this.findAllReferencedFeeds(input));
        }

        protected Set<String> findAllReferencedEnrichers(BrooklynMementoRawData input) {
            return this.findAllReferencedAdjuncts(input.getEntities(), "entity/enrichers/string");
        }

        protected Set<String> findAllReferencedPolicies(BrooklynMementoRawData input) {
            return this.findAllReferencedAdjuncts(input.getEntities(), "entity/policies/string");
        }

        protected Set<String> findAllReferencedFeeds(BrooklynMementoRawData input) {
            return this.findAllReferencedAdjuncts(input.getEntities(), "entity/feeds/string");
        }

        protected Set<String> findAllReferencedAdjuncts(Map<String, String> items, String xpath) {
            LinkedHashSet result = Sets.newLinkedHashSet();
            for (Map.Entry<String, String> entry : items.entrySet()) {
                result.addAll(this.getAllNodesFromXpath((NodeList)XmlUtil.xpath(entry.getValue(), xpath, XPathConstants.NODESET)));
            }
            return result;
        }

        protected Set<String> findAllReferencedLocations(BrooklynMementoRawData input) {
            LinkedHashSet result = Sets.newLinkedHashSet();
            result.addAll(this.searchLocationsToKeep(input.getEntities(), "/entity"));
            result.addAll(this.searchLocationsToKeep(input.getPolicies(), "/policy"));
            result.addAll(this.searchLocationsToKeep(input.getEnrichers(), "/enricher"));
            result.addAll(this.searchLocationsToKeep(input.getFeeds(), "/feed"));
            result.addAll(this.searchLocationsToKeepInLocations(input.getLocations(), result));
            return result;
        }

        protected Set<String> searchLocationsToKeep(Map<String, String> items, String searchInTypePrefix) {
            String locationsXpath = searchInTypePrefix + "/locations/string";
            String locationProxyXpath = searchInTypePrefix + "//locationProxy";
            LinkedHashSet result = Sets.newLinkedHashSet();
            for (Map.Entry<String, String> entry : items.entrySet()) {
                result.addAll(this.getAllNodesFromXpath((NodeList)XmlUtil.xpath(entry.getValue(), locationsXpath, XPathConstants.NODESET)));
                result.addAll(this.getAllNodesFromXpath((NodeList)XmlUtil.xpath(entry.getValue(), locationProxyXpath, XPathConstants.NODESET)));
            }
            return result;
        }

        protected Set<String> searchLocationsToKeepInLocations(Map<String, String> locations, Set<String> alreadyReferencedLocations) {
            LinkedHashSet result = Sets.newLinkedHashSet();
            String prefix = "/location";
            String locationTypeXpath = prefix + "/type";
            String locationChildrenXpath = prefix + "/children/string";
            String locationParentDirectTagXpath = prefix + "/parent";
            String locationProxyXpath = prefix + "//locationProxy";
            MutableSet locsToInspect = MutableSet.copyOf(alreadyReferencedLocations);
            for (Map.Entry<String, String> entry : locations.entrySet()) {
                String locType;
                String locId = entry.getKey();
                if (alreadyReferencedLocations.contains(locId) || (locType = XmlUtil.xpath((String)entry.getValue(), locationTypeXpath)) == null || !locType.contains("PortForwardManager")) continue;
                result.add(locId);
                locsToInspect.add(locId);
            }
            while (locsToInspect.size() > 0) {
                LinkedHashSet referencedLocs = Sets.newLinkedHashSet();
                for (String id : locsToInspect) {
                    String xmlData = locations.get(id);
                    if (xmlData == null) continue;
                    referencedLocs.addAll(this.getAllNodesFromXpath((NodeList)XmlUtil.xpath(xmlData, locationChildrenXpath, XPathConstants.NODESET)));
                    referencedLocs.addAll(this.getAllNodesFromXpath((NodeList)XmlUtil.xpath(xmlData, locationParentDirectTagXpath, XPathConstants.NODESET)));
                    referencedLocs.addAll(this.getAllNodesFromXpath((NodeList)XmlUtil.xpath(xmlData, locationProxyXpath, XPathConstants.NODESET)));
                }
                MutableSet newlyDiscoveredLocs = MutableSet.builder().addAll((Iterable)referencedLocs).removeAll(alreadyReferencedLocations).removeAll((Iterable)result).build();
                result.addAll(newlyDiscoveredLocs);
                locsToInspect = newlyDiscoveredLocs;
            }
            return result;
        }

        protected Set<String> getAllNodesFromXpath(NodeList nodeList) {
            LinkedHashSet result = Sets.newLinkedHashSet();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node nextNode = nodeList.item(i);
                if (nextNode == null) continue;
                result.add(nextNode.getTextContent());
            }
            return result;
        }
    }

    public static class Builder
    extends CompoundTransformer.Builder {
        @Override
        public DeleteOrphanedStateTransformer build() {
            return new DeleteOrphanedStateTransformer(this);
        }
    }
}

