/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.objs;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.EntityAdjunct;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigConstraints;
import org.apache.brooklyn.core.config.internal.AbstractConfigMapImpl;
import org.apache.brooklyn.core.objs.AbstractEntityAdjunct;
import org.apache.brooklyn.util.guava.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdjunctConfigMap
extends AbstractConfigMapImpl<EntityAdjunct> {
    private static final Logger LOG = LoggerFactory.getLogger(AdjunctConfigMap.class);
    @Deprecated
    private AbstractEntityAdjunct adjunct;

    public AdjunctConfigMap(AbstractEntityAdjunct adjunct) {
        super((BrooklynObject)Preconditions.checkNotNull((Object)adjunct, (Object)"AbstractEntityAdjunct must be specified"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntityAdjunct getContainer() {
        EntityAdjunct result = (EntityAdjunct)super.getContainer();
        if (result != null) {
            return result;
        }
        AdjunctConfigMap adjunctConfigMap = this;
        synchronized (adjunctConfigMap) {
            result = (EntityAdjunct)super.getContainer();
            if (result != null) {
                return result;
            }
            this.bo = this.adjunct;
            this.adjunct = null;
        }
        return (EntityAdjunct)super.getContainer();
    }

    @Override
    public <T> void assertValid(ConfigKey<T> key, T val) {
        ConfigConstraints.assertValid(this.getContainer(), key, val);
    }

    @Override
    protected void postLocalEvaluate(ConfigKey<?> key, BrooklynObject bo, Maybe<?> rawValue, Maybe<?> resolvedValue) {
    }

    @Override
    protected void postSetConfig() {
    }

    @Override
    protected ExecutionContext getExecutionContext(BrooklynObject bo) {
        return ((AbstractEntityAdjunct)bo).getExecutionContext();
    }

    public AdjunctConfigMap submap(Predicate<ConfigKey<?>> filter) {
        AdjunctConfigMap m = new AdjunctConfigMap((AbstractEntityAdjunct)this.getContainer());
        for (Map.Entry entry : this.ownConfig.entrySet()) {
            if (!filter.apply(entry.getKey())) continue;
            m.ownConfig.put(entry.getKey(), entry.getValue());
        }
        return m;
    }

    @Override
    protected EntityAdjunct getParentOfContainer(EntityAdjunct container) {
        return null;
    }

    @Override
    protected <T> ConfigKey<?> getKeyAtContainerImpl(EntityAdjunct container, ConfigKey<T> queryKey) {
        return ((AbstractEntityAdjunct)container).getAdjunctType().getConfigKey(queryKey.getName());
    }

    @Override
    protected Set<ConfigKey<?>> getKeysAtContainer(EntityAdjunct container) {
        return ((AbstractEntityAdjunct)container).getAdjunctType().getConfigKeys();
    }
}

