/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.resolve.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.SerializerFactoryConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.TypeDeserializerBase;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.PropertyBuilder;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.resolve.jackson.BrooklynJacksonSerializationUtils;
import org.apache.brooklyn.core.resolve.jackson.BrooklynRegisteredTypeJacksonSerialization;
import org.apache.brooklyn.core.resolve.jackson.WrappedValue;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.javalang.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrappedValuesSerialization {
    private static final Logger log = LoggerFactory.getLogger(WrappedValuesSerialization.class);

    private static JavaType getGenericType(TypeDeserializer typeDeserializer) {
        if (!(typeDeserializer instanceof TypeDeserializerBase)) {
            return null;
        }
        return WrappedValuesSerialization.getSingleGenericArgumentJavaType(((TypeDeserializerBase)typeDeserializer).baseType());
    }

    private static JavaType getGenericType(TypeSerializer typeSerializer) {
        if (typeSerializer == null) {
            return null;
        }
        if (!(typeSerializer.getTypeIdResolver() instanceof BrooklynRegisteredTypeJacksonSerialization.BrooklynRegisteredTypeAndClassNameIdResolver)) {
            return null;
        }
        return WrappedValuesSerialization.getSingleGenericArgumentJavaType(((BrooklynRegisteredTypeJacksonSerialization.BrooklynRegisteredTypeAndClassNameIdResolver)typeSerializer.getTypeIdResolver()).getBaseType());
    }

    private static JavaType getSingleGenericArgumentJavaType(JavaType x) {
        return x.getBindings().getTypeParameters().stream().findFirst().orElse(null);
    }

    public static <T> T ensureWrappedValuesInitialized(T x) {
        if (x == null) {
            return x;
        }
        Reflections.findFields(x.getClass(), f -> WrappedValue.class.isAssignableFrom(f.getType()), null).forEach(f -> {
            try {
                if (Reflections.getFieldValueMaybe((Object)x, (Field)f).isNull()) {
                    f.set(x, WrappedValue.of(null));
                }
            }
            catch (IllegalAccessException e) {
                Exceptions.propagate((Throwable)e);
            }
        });
        return x;
    }

    public static ObjectMapper apply(ObjectMapper mapper, ManagementContext mgmt) {
        if (mapper.getSerializationConfig().getDefaultTyper(null) == null) {
            throw new IllegalStateException("Mapper must be set up to use a TypeResolverBuilder including type info for wrapped value serialization to work.");
        }
        return mapper.setSerializerFactory((SerializerFactory)NullWrappedValueSuppressingBeanSerializerFactory.extending(mapper.getSerializerFactory())).setVisibility((VisibilityChecker)new VisibilityChecker.Std(JsonAutoDetect.Visibility.ANY, JsonAutoDetect.Visibility.ANY, JsonAutoDetect.Visibility.ANY, JsonAutoDetect.Visibility.ANY, JsonAutoDetect.Visibility.ANY)).registerModule((Module)new SimpleModule().addSerializer(WrappedValue.class, new WrappedValueSerializer()).addDeserializer(WrappedValue.class, (JsonDeserializer)new WrappedValueDeserializer(mgmt)));
    }

    static /* synthetic */ JavaType access$000(TypeDeserializer x0) {
        return WrappedValuesSerialization.getGenericType(x0);
    }

    static class NullWrappedValueSuppressingBeanSerializerFactory
    extends BeanSerializerFactory {
        protected NullWrappedValueSuppressingBeanSerializerFactory(SerializerFactoryConfig config) {
            super(config);
        }

        public static NullWrappedValueSuppressingBeanSerializerFactory extending(SerializerFactory factory) {
            if (factory == null) {
                return new NullWrappedValueSuppressingBeanSerializerFactory(null);
            }
            if (factory instanceof NullWrappedValueSuppressingBeanSerializerFactory) {
                return (NullWrappedValueSuppressingBeanSerializerFactory)factory;
            }
            if (factory.getClass() == BeanSerializerFactory.class) {
                return new NullWrappedValueSuppressingBeanSerializerFactory(((BeanSerializerFactory)factory).getFactoryConfig());
            }
            throw new IllegalStateException("Cannot extend " + factory);
        }

        public SerializerFactory withConfig(SerializerFactoryConfig config) {
            if (this._factoryConfig == config) {
                return this;
            }
            return new NullWrappedValueSuppressingBeanSerializerFactory(config);
        }

        protected PropertyBuilder constructPropertyBuilder(SerializationConfig config, BeanDescription beanDesc) {
            return new NullWrappedValueSuppressingPropertyBuilder(config, beanDesc);
        }
    }

    static class NullWrappedValueSuppressingPropertyBuilder
    extends PropertyBuilder {
        public NullWrappedValueSuppressingPropertyBuilder(SerializationConfig config, BeanDescription beanDesc) {
            super(config, beanDesc);
        }

        protected BeanPropertyWriter buildWriter(SerializerProvider prov, BeanPropertyDefinition propDef, JavaType declaredType, JsonSerializer<?> ser, TypeSerializer typeSer, TypeSerializer contentTypeSer, AnnotatedMember am, boolean defaultUseStaticTyping) throws JsonMappingException {
            BeanPropertyWriter bpw = super.buildWriter(prov, propDef, declaredType, ser, typeSer, contentTypeSer, am, defaultUseStaticTyping);
            if (WrappedValue.class.isAssignableFrom(bpw.getMember().getRawType())) {
                bpw = new BeanPropertyWriter(propDef, am, this._beanDesc.getClassAnnotations(), declaredType, ser, typeSer, bpw.getSerializationType(), bpw.willSuppressNulls(), WrappedValue.ofNull(), bpw.getViews());
            }
            return bpw;
        }
    }

    public static class WrappedValueSerializer<T>
    extends JsonSerializer<WrappedValue<T>> {
        public void serialize(WrappedValue<T> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            this.serializeWithType(value, gen, serializers, null);
        }

        public void serializeWithType(WrappedValue<T> value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            Object valueToWrite;
            JavaType baseType = WrappedValuesSerialization.getGenericType(typeSer);
            if (value.getSupplier() != null) {
                baseType = serializers.constructType(Supplier.class);
                valueToWrite = value.getSupplier();
            } else {
                if (baseType == null) {
                    baseType = serializers.constructType(Object.class);
                }
                valueToWrite = value.get();
            }
            if (valueToWrite == null) {
                gen.writeNull();
            } else {
                if (!baseType.getRawClass().isInstance(valueToWrite)) {
                    baseType = serializers.constructType(Object.class);
                }
                JsonSerializer vs = serializers.findValueSerializer(serializers.constructType(valueToWrite.getClass()), null);
                vs.serializeWithType(valueToWrite, gen, serializers, serializers.findTypeSerializer(baseType));
            }
        }
    }

    public static class WrappedValueDeserializer
    extends JsonDeserializer {
        ManagementContext mgmt;

        public WrappedValueDeserializer(ManagementContext mgmt) {
            this.mgmt = mgmt;
        }

        public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return this.deserializeWithType(p, ctxt, null);
        }

        public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
            Object v = this.deserializeWithTypeUnwrapped(p, ctxt, typeDeserializer);
            if (BrooklynJacksonSerializationUtils.JsonDeserializerForCommonBrooklynThings.BROOKLYN_PARSE_DSL_FUNCTION != null && this.mgmt != null && this.looksLikeDsl(v)) {
                v = BrooklynJacksonSerializationUtils.JsonDeserializerForCommonBrooklynThings.BROOKLYN_PARSE_DSL_FUNCTION.apply(this.mgmt, v);
            }
            return WrappedValue.of(v);
        }

        private boolean looksLikeDsl(Object v) {
            if (v instanceof String) {
                return ((String)v).startsWith("$brooklyn:");
            }
            if (v instanceof Map && ((Map)v).size() == 1) {
                return this.looksLikeDsl(Iterables.getOnlyElement(((Map)v).keySet()));
            }
            return false;
        }

        /*
         * Exception decompiling
         */
        Object deserializeWithTypeUnwrapped(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static /* synthetic */ void lambda$deserializeWithTypeUnwrapped$1(Exception e) {
            log.trace("- ", (Throwable)e);
        }

        private static /* synthetic */ boolean lambda$deserializeWithTypeUnwrapped$0(Exception err) {
            return !(err instanceof JsonProcessingException);
        }
    }
}

