/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.sensor;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.SubscriptionHandle;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.sensor.ReleaseableLatch;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.task.BasicExecutionContext;
import org.apache.brooklyn.util.core.task.BasicTask;
import org.apache.brooklyn.util.core.task.DeferredSupplier;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.ImmediateSupplier;
import org.apache.brooklyn.util.core.task.ParallelTask;
import org.apache.brooklyn.util.core.task.TaskInternal;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.ValueResolver;
import org.apache.brooklyn.util.exceptions.CompoundRuntimeException;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.NotManagedException;
import org.apache.brooklyn.util.exceptions.RuntimeTimeoutException;
import org.apache.brooklyn.util.groovy.GroovyJavaMethods;
import org.apache.brooklyn.util.guava.Functionals;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.text.StringFunctions;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependentConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(DependentConfiguration.class);

    private DependentConfiguration() {
    }

    public static <T> Task<T> attributeWhenReady(Entity source, AttributeSensor<T> sensor) {
        return DependentConfiguration.attributeWhenReady(source, sensor, JavaGroovyEquivalents.groovyTruthPredicate());
    }

    public static <T> Task<T> attributeWhenReadyAllowingOnFire(Entity source, AttributeSensor<T> sensor) {
        return DependentConfiguration.attributeWhenReadyAllowingOnFire(source, sensor, JavaGroovyEquivalents.groovyTruthPredicate());
    }

    @Deprecated
    public static <T> Task<T> attributeWhenReady(Entity source, AttributeSensor<T> sensor, Closure<Boolean> ready) {
        Predicate readyPredicate = ready != null ? GroovyJavaMethods.predicateFromClosure(ready) : JavaGroovyEquivalents.groovyTruthPredicate();
        return DependentConfiguration.attributeWhenReady(source, sensor, readyPredicate);
    }

    public static <T> Task<T> attributeWhenReady(Entity source, AttributeSensor<T> sensor, Predicate<? super T> ready) {
        Builder<? super T, ? super T> builder = DependentConfiguration.builder().attributeWhenReady(source, sensor);
        if (ready != null) {
            builder.readiness(ready);
        }
        return builder.build();
    }

    public static <T> Task<T> attributeWhenReadyAllowingOnFire(Entity source, AttributeSensor<T> sensor, Predicate<? super T> ready) {
        Builder<? super T, ? super T> builder = DependentConfiguration.builder().attributeWhenReadyAllowingOnFire(source, sensor);
        if (ready != null) {
            builder.readiness(ready);
        }
        return builder.build();
    }

    @Deprecated
    public static <T, V> Task<V> attributePostProcessedWhenReady(Entity source, AttributeSensor<T> sensor, Closure<Boolean> ready, Closure<V> postProcess) {
        Predicate readyPredicate = ready != null ? GroovyJavaMethods.predicateFromClosure(ready) : JavaGroovyEquivalents.groovyTruthPredicate();
        Function postProcessFunction = GroovyJavaMethods.functionFromClosure(postProcess);
        return DependentConfiguration.attributePostProcessedWhenReady(source, sensor, readyPredicate, postProcessFunction);
    }

    @Deprecated
    public static <T, V> Task<V> attributePostProcessedWhenReady(Entity source, AttributeSensor<T> sensor, Closure<V> postProcess) {
        return DependentConfiguration.attributePostProcessedWhenReady(source, sensor, JavaGroovyEquivalents.groovyTruthPredicate(), GroovyJavaMethods.functionFromClosure(postProcess));
    }

    public static <T> Task<T> valueWhenAttributeReady(Entity source, AttributeSensor<T> sensor, T value) {
        return DependentConfiguration.attributePostProcessedWhenReady(source, sensor, JavaGroovyEquivalents.groovyTruthPredicate(), Functions.constant(value));
    }

    public static <T, V> Task<V> valueWhenAttributeReady(Entity source, AttributeSensor<T> sensor, Function<? super T, V> valueProvider) {
        return DependentConfiguration.attributePostProcessedWhenReady(source, sensor, JavaGroovyEquivalents.groovyTruthPredicate(), valueProvider);
    }

    @Deprecated
    public static <T, V> Task<V> valueWhenAttributeReady(Entity source, AttributeSensor<T> sensor, Closure<V> valueProvider) {
        return DependentConfiguration.attributePostProcessedWhenReady(source, sensor, JavaGroovyEquivalents.groovyTruthPredicate(), valueProvider);
    }

    @Deprecated
    public static <T, V> Task<V> attributePostProcessedWhenReady(Entity source, AttributeSensor<T> sensor, Predicate<? super T> ready, Closure<V> postProcess) {
        return DependentConfiguration.attributePostProcessedWhenReady(source, sensor, ready, GroovyJavaMethods.functionFromClosure(postProcess));
    }

    public static <T, V> Task<V> attributePostProcessedWhenReady(Entity source, AttributeSensor<T> sensor, Predicate<? super T> ready, Function<? super T, V> postProcess) {
        Builder<? super T, ? super T> builder1 = DependentConfiguration.builder().attributeWhenReady(source, sensor);
        Builder<Object, Object> builder = postProcess != null ? builder1.postProcess(postProcess) : builder1;
        if (ready != null) {
            builder.readiness(ready);
        }
        return builder.build();
    }

    public static <T> T waitInTaskForAttributeReady(Entity source, AttributeSensor<T> sensor, Predicate<? super T> ready) {
        return DependentConfiguration.waitInTaskForAttributeReady(source, sensor, ready, ImmutableList.of());
    }

    public static <T> T waitInTaskForAttributeReady(Entity source, AttributeSensor<T> sensor, Predicate<? super T> ready, List<AttributeAndSensorCondition<?>> abortConditions) {
        String blockingDetails = "Waiting for ready from " + source + " " + sensor + " (subscription)";
        return DependentConfiguration.waitInTaskForAttributeReady(source, sensor, ready, abortConditions, blockingDetails);
    }

    public static <T> T waitInTaskForAttributeReady(Entity source, AttributeSensor<T> sensor, Predicate<? super T> ready, List<AttributeAndSensorCondition<?>> abortConditions, String blockingDetails) {
        return (T)new WaitInTaskForAttributeReady(source, sensor, ready, abortConditions, blockingDetails).call();
    }

    @Deprecated
    public static <T> Task<T> whenDone(Callable<T> job) {
        return new BasicTask<T>((Map<?, ?>)MutableMap.of((Object)"tag", (Object)"whenDone", (Object)"displayName", (Object)"waiting for job"), job);
    }

    public static <U, T> Task<T> transform(Task<U> task, Function<U, T> transformer) {
        return DependentConfiguration.transform((Map)MutableMap.of((Object)"displayName", (Object)("transforming " + task)), task, transformer);
    }

    @Deprecated
    public static <U, T> Task<T> transform(Task<U> task, Closure transformer) {
        return DependentConfiguration.transform(task, GroovyJavaMethods.functionFromClosure((Closure)transformer));
    }

    public static <U, T> Task<T> transform(Map flags, final TaskAdaptable<U> task, final Function<U, T> transformer) {
        return new BasicTask(flags, new Callable<T>(){

            @Override
            public T call() throws Exception {
                if (!task.asTask().isSubmitted()) {
                    BasicExecutionContext.getCurrentExecutionContext().submit(task);
                }
                return transformer.apply(task.asTask().get());
            }
        });
    }

    public static <U, T> Task<T> transformMultiple(Function<List<U>, T> transformer, TaskAdaptable<U> ... tasks) {
        return DependentConfiguration.transformMultiple((Map)MutableMap.of((Object)"displayName", (Object)"transforming multiple"), transformer, tasks);
    }

    @Deprecated
    public static <U, T> Task<T> transformMultiple(Closure transformer, TaskAdaptable<U> ... tasks) {
        return DependentConfiguration.transformMultiple(GroovyJavaMethods.functionFromClosure((Closure)transformer), tasks);
    }

    @Deprecated
    public static <U, T> Task<T> transformMultiple(Map flags, Closure transformer, TaskAdaptable<U> ... tasks) {
        return DependentConfiguration.transformMultiple(flags, GroovyJavaMethods.functionFromClosure((Closure)transformer), tasks);
    }

    public static <U, T> Task<T> transformMultiple(Map flags, Function<List<U>, T> transformer, TaskAdaptable<U> ... tasks) {
        return DependentConfiguration.transformMultiple(flags, transformer, Arrays.asList(tasks));
    }

    public static <U, T> Task<T> transformMultiple(Map flags, final Function<List<U>, T> transformer, Collection<? extends TaskAdaptable<U>> tasks) {
        if (tasks.size() == 1) {
            return DependentConfiguration.transform(flags, (TaskAdaptable)Iterables.getOnlyElement(tasks), new Function<U, T>(){

                @Nullable
                public T apply(@Nullable U input) {
                    return transformer.apply((Object)MutableList.of(input).asUnmodifiable());
                }
            });
        }
        return DependentConfiguration.transform(flags, new ParallelTask(tasks), transformer);
    }

    public static Task<String> formatString(Object spec, Object ... args) {
        Object[] newArgs;
        ArrayList taskArgs = Lists.newArrayList();
        for (Object arg : newArgs = Lists.asList((Object)spec, (Object[])args).toArray()) {
            if (arg instanceof TaskAdaptable) {
                taskArgs.add((TaskAdaptable)arg);
                continue;
            }
            if (!(arg instanceof TaskFactory)) continue;
            taskArgs.add(((TaskFactory)arg).newTask());
        }
        return DependentConfiguration.transformMultiple((Map)MutableMap.of((Object)"displayName", (Object)("formatting '" + spec.toString() + "' with " + taskArgs.size() + " task" + (taskArgs.size() != 1 ? "s" : ""))), new Function<List<Object>, String>(){

            public String apply(List<Object> input) {
                Iterator<Object> tri = input.iterator();
                Object[] vv = new Object[newArgs.length];
                int i = 0;
                for (Object arg : newArgs) {
                    vv[i] = arg instanceof TaskAdaptable || arg instanceof TaskFactory ? tri.next() : (arg instanceof DeferredSupplier ? ((DeferredSupplier)arg).get() : arg);
                    ++i;
                }
                return String.format(vv[0].toString(), Arrays.copyOfRange(vv, 1, vv.length));
            }
        }, taskArgs);
    }

    public static Maybe<String> formatStringImmediately(Object spec, Object ... args) {
        String pattern = "";
        Maybe<?> resolvedSpec = DependentConfiguration.resolveImmediately(spec);
        if (resolvedSpec.isPresent()) {
            pattern = resolvedSpec.get().toString();
        }
        ArrayList resolvedArgs = Lists.newArrayList();
        for (Object arg : args) {
            Maybe<?> argVal = DependentConfiguration.resolveImmediately(arg);
            if (argVal.isAbsent()) {
                return Maybe.Absent.castAbsent(argVal);
            }
            resolvedArgs.add(argVal.get());
        }
        return Maybe.of((Object)String.format(pattern, resolvedArgs.toArray()));
    }

    public static Maybe<String> urlEncodeImmediately(Object arg) {
        Maybe<?> resolvedArg = DependentConfiguration.resolveImmediately(arg);
        if (resolvedArg.isAbsent()) {
            return Maybe.Absent.castAbsent(resolvedArg);
        }
        if (resolvedArg.isNull()) {
            return Maybe.of((Object)null);
        }
        String resolvedString = resolvedArg.get().toString();
        return Maybe.of((Object)Urls.encode((String)resolvedString));
    }

    public static Task<String> urlEncode(final Object arg) {
        ArrayList taskArgs = Lists.newArrayList();
        if (arg instanceof TaskAdaptable) {
            taskArgs.add((TaskAdaptable)arg);
        } else if (arg instanceof TaskFactory) {
            taskArgs.add(((TaskFactory)arg).newTask());
        }
        return DependentConfiguration.transformMultiple((Map)MutableMap.of((Object)"displayName", (Object)("url-escaping '" + arg)), new Function<List<Object>, String>(){

            @Nullable
            public String apply(@Nullable List<Object> input) {
                Object resolvedArg = arg instanceof TaskAdaptable || arg instanceof TaskFactory ? Iterables.getOnlyElement(input) : (arg instanceof DeferredSupplier ? ((DeferredSupplier)arg).get() : arg);
                if (resolvedArg == null) {
                    return null;
                }
                String resolvedString = resolvedArg.toString();
                return Urls.encode((String)resolvedString);
            }
        }, taskArgs);
    }

    protected static <T> Maybe<?> resolveImmediately(Object val) {
        if (val instanceof ImmediateSupplier) {
            return ((ImmediateSupplier)val).getImmediately();
        }
        if (val instanceof TaskAdaptable) {
            throw new ImmediateSupplier.ImmediateUnsupportedException("Cannot immediately resolve value " + val);
        }
        if (val instanceof TaskFactory) {
            throw new ImmediateSupplier.ImmediateUnsupportedException("Cannot immediately resolve value " + val);
        }
        if (val instanceof DeferredSupplier) {
            throw new ImmediateSupplier.ImmediateUnsupportedException("Cannot immediately resolve value " + val);
        }
        return Maybe.of((Object)val);
    }

    public static Maybe<String> regexReplacementImmediately(Object source, Object pattern, Object replacement) {
        Maybe<?> resolvedSource = DependentConfiguration.resolveImmediately(source);
        if (resolvedSource.isAbsent()) {
            return Maybe.Absent.castAbsent(resolvedSource);
        }
        String resolvedSourceStr = String.valueOf(resolvedSource.get());
        Maybe<?> resolvedPattern = DependentConfiguration.resolveImmediately(pattern);
        if (resolvedPattern.isAbsent()) {
            return Maybe.Absent.castAbsent(resolvedPattern);
        }
        String resolvedPatternStr = String.valueOf(resolvedPattern.get());
        Maybe<?> resolvedReplacement = DependentConfiguration.resolveImmediately(replacement);
        if (resolvedReplacement.isAbsent()) {
            return Maybe.Absent.castAbsent(resolvedReplacement);
        }
        String resolvedReplacementStr = String.valueOf(resolvedReplacement.get());
        String result = new StringFunctions.RegexReplacer(resolvedPatternStr, resolvedReplacementStr).apply(resolvedSourceStr);
        return Maybe.of((Object)result);
    }

    public static Task<String> regexReplacement(Object source, Object pattern, Object replacement) {
        List<TaskAdaptable<Object>> taskArgs = DependentConfiguration.getTaskAdaptable(source, pattern, replacement);
        RegexTransformerString transformer = new RegexTransformerString(source, pattern, replacement);
        return DependentConfiguration.transformMultiple((Map)MutableMap.of((Object)"displayName", (Object)String.format("creating regex replacement function (%s:%s)", pattern, replacement)), transformer, taskArgs);
    }

    public static Maybe<Function<String, String>> regexReplacementImmediately(Object pattern, Object replacement) {
        Maybe<?> resolvedPattern = DependentConfiguration.resolveImmediately(pattern);
        if (resolvedPattern.isAbsent()) {
            return Maybe.Absent.castAbsent(resolvedPattern);
        }
        String resolvedPatternStr = String.valueOf(resolvedPattern.get());
        Maybe<?> resolvedReplacement = DependentConfiguration.resolveImmediately(replacement);
        if (resolvedReplacement.isAbsent()) {
            return Maybe.Absent.castAbsent(resolvedReplacement);
        }
        String resolvedReplacementStr = String.valueOf(resolvedReplacement.get());
        StringFunctions.RegexReplacer result = new StringFunctions.RegexReplacer(resolvedPatternStr, resolvedReplacementStr);
        return Maybe.of((Object)result);
    }

    public static Task<Function<String, String>> regexReplacement(Object pattern, Object replacement) {
        List<TaskAdaptable<Object>> taskArgs = DependentConfiguration.getTaskAdaptable(pattern, replacement);
        RegexTransformerFunction transformer = new RegexTransformerFunction(pattern, replacement);
        return DependentConfiguration.transformMultiple((Map)MutableMap.of((Object)"displayName", (Object)String.format("creating regex replacement function (%s:%s)", pattern, replacement)), transformer, taskArgs);
    }

    public static Maybe<ReleaseableLatch> maxConcurrencyImmediately(Object maxThreads) {
        Maybe<?> resolvedMaxThreads = DependentConfiguration.resolveImmediately(maxThreads);
        if (resolvedMaxThreads.isAbsent()) {
            return Maybe.absent();
        }
        Integer resolvedMaxThreadsInt = TypeCoercions.coerce(resolvedMaxThreads, Integer.class);
        ReleaseableLatch result = ReleaseableLatch.Factory.newMaxConcurrencyLatch(resolvedMaxThreadsInt);
        return Maybe.of((Object)result);
    }

    public static Task<ReleaseableLatch> maxConcurrency(Object maxThreads) {
        List<TaskAdaptable<Object>> taskArgs = DependentConfiguration.getTaskAdaptable(maxThreads);
        MaxThreadsTransformerFunction transformer = new MaxThreadsTransformerFunction(maxThreads);
        return DependentConfiguration.transformMultiple((Map)MutableMap.of((Object)"displayName", (Object)String.format("creating max concurrency semaphore(%s)", maxThreads)), transformer, taskArgs);
    }

    private static List<TaskAdaptable<Object>> getTaskAdaptable(Object ... args) {
        ArrayList taskArgs = Lists.newArrayList();
        for (Object arg : args) {
            if (arg instanceof TaskAdaptable) {
                taskArgs.add((TaskAdaptable)arg);
                continue;
            }
            if (!(arg instanceof TaskFactory)) continue;
            taskArgs.add(((TaskFactory)arg).newTask());
        }
        return taskArgs;
    }

    private static String resolveArgument(Object argument, Iterator<?> taskArgsIterator) {
        return DependentConfiguration.resolveArgument(argument, taskArgsIterator, String.class);
    }

    private static <T> T resolveArgument(Object argument, Iterator<?> taskArgsIterator, Class<T> type) {
        Object resolvedArgument = argument instanceof TaskAdaptable ? taskArgsIterator.next() : (argument instanceof DeferredSupplier ? ((DeferredSupplier)argument).get() : argument);
        return TypeCoercions.coerce(resolvedArgument, type);
    }

    public static <T> Task<List<T>> listAttributesWhenReady(AttributeSensor<T> sensor, Iterable<Entity> entities) {
        return DependentConfiguration.listAttributesWhenReady(sensor, entities, JavaGroovyEquivalents.groovyTruthPredicate());
    }

    @Deprecated
    public static <T> Task<List<T>> listAttributesWhenReady(AttributeSensor<T> sensor, Iterable<Entity> entities, Closure<Boolean> readiness) {
        Predicate readinessPredicate = readiness != null ? GroovyJavaMethods.predicateFromClosure(readiness) : JavaGroovyEquivalents.groovyTruthPredicate();
        return DependentConfiguration.listAttributesWhenReady(sensor, entities, readinessPredicate);
    }

    public static <T> Task<List<T>> listAttributesWhenReady(AttributeSensor<T> sensor, Iterable<Entity> entities, Predicate<? super T> readiness) {
        if (readiness == null) {
            readiness = JavaGroovyEquivalents.groovyTruthPredicate();
        }
        return DependentConfiguration.builder().attributeWhenReadyFromMultiple(entities, sensor, readiness).build();
    }

    public static <T> T waitForTask(Task<T> t, Entity context) throws InterruptedException {
        return DependentConfiguration.waitForTask(t, context, null);
    }

    public static <T> T waitForTask(Task<T> t, Entity context, String contextMessage) throws InterruptedException {
        try {
            return (T)Tasks.resolveValue(t, Object.class, ((EntityInternal)context).getExecutionContext(), contextMessage);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static ProtoBuilder builder() {
        return new ProtoBuilder();
    }

    static /* synthetic */ Logger access$100() {
        return LOG;
    }

    @Beta
    public static class MultiBuilder<T, V, V2> {
        protected final String name;
        protected final String descriptionBase;
        protected final Builder<T, V> builder;
        protected final List<AttributeAndSensorCondition<?>> multiSource = Lists.newArrayList();
        protected Function<? super List<V>, V2> postProcessFromMultiple;

        @Beta
        protected MultiBuilder(Iterable<? extends Entity> sources, AttributeSensor<T> sensor) {
            this(sources, sensor, JavaGroovyEquivalents.groovyTruthPredicate());
        }

        @Beta
        protected MultiBuilder(Iterable<? extends Entity> sources, AttributeSensor<T> sensor, Predicate<? super T> readiness) {
            this.builder = new Builder(null, sensor);
            this.builder.readiness(readiness);
            for (Entity s : (Iterable)Preconditions.checkNotNull(sources, (Object)"sources")) {
                this.multiSource.add(new AttributeAndSensorCondition<T>(s, sensor, readiness));
            }
            this.name = "waiting on " + sensor.getName();
            this.descriptionBase = "waiting on " + sensor.getName() + " " + readiness + " from " + Iterables.size(sources) + " entit" + Strings.ies(sources);
        }

        public <V2b> MultiBuilder<T, V, V2b> postProcessFromMultiple(Function<? super List<V>, V2b> val) {
            this.postProcessFromMultiple = (Function)Preconditions.checkNotNull(val, (Object)"postProcessFromMulitple");
            return this;
        }

        public MultiBuilder<T, V, Boolean> postProcessFromMultiple(Predicate<? super List<V>> val) {
            return this.postProcessFromMultiple(Functions.forPredicate(val));
        }

        @Deprecated
        public <V1> MultiBuilder<T, V1, V2> postProcess(Closure<V1> val) {
            this.builder.postProcess(val);
            return this;
        }

        public <V1> MultiBuilder<T, V1, V2> postProcess(Function<? super T, V1> val) {
            this.builder.postProcess(val);
            return this;
        }

        public <T2> MultiBuilder<T, V, V2> abortIf(Entity source, AttributeSensor<T2> sensor) {
            this.builder.abortIf(source, sensor);
            return this;
        }

        public <T2> MultiBuilder<T, V, V2> abortIf(Entity source, AttributeSensor<T2> sensor, Predicate<? super T2> predicate) {
            this.builder.abortIf(source, sensor, predicate);
            return this;
        }

        public MultiBuilder<T, V, V2> abortIfOnFire() {
            this.builder.abortIfOnFire();
            return this;
        }

        public MultiBuilder<T, V, V2> blockingDetails(String val) {
            this.builder.blockingDetails(val);
            return this;
        }

        public MultiBuilder<T, V, V2> timeout(Duration val) {
            this.builder.timeout(val);
            return this;
        }

        public MultiBuilder<T, V, V2> onTimeoutReturn(V val) {
            this.builder.onTimeoutReturn(val);
            return this;
        }

        public MultiBuilder<T, V, V2> onTimeoutThrow() {
            this.builder.onTimeoutThrow();
            return this;
        }

        public MultiBuilder<T, V, V2> onUnmanagedReturn(V val) {
            this.builder.onUnmanagedReturn(val);
            return this;
        }

        public MultiBuilder<T, V, V2> onUnmanagedThrow() {
            this.builder.onUnmanagedThrow();
            return this;
        }

        public Task<V2> build() {
            MutableList tasks = MutableList.of();
            for (AttributeAndSensorCondition<?> source : this.multiSource) {
                this.builder.source(source.source);
                this.builder.sensor(source.sensor);
                this.builder.readiness(source.predicate);
                tasks.add(this.builder.build());
            }
            final Task parallelTask = Tasks.builder().parallel(true).addAll((Iterable<TaskAdaptable<?>>)tasks).displayName(this.name).description(this.descriptionBase + (this.builder.timeout != null ? ", timeout " + this.builder.timeout : "")).build();
            if (this.postProcessFromMultiple == null) {
                return parallelTask;
            }
            return Tasks.builder().displayName(this.name).description(this.descriptionBase).tag("attributeWhenReady").body(new Callable<V2>(){

                @Override
                public V2 call() throws Exception {
                    List prePostProgress = (List)DynamicTasks.queue(parallelTask).get();
                    return DynamicTasks.queue(Tasks.builder().displayName("post-processing").description("Applying " + postProcessFromMultiple).body(Functionals.callable(postProcessFromMultiple, (Object)prePostProgress)).build()).get();
                }
            }).build();
        }
    }

    public static class Builder<T, V> {
        protected Entity source;
        protected AttributeSensor<T> sensor;
        protected Predicate<? super T> readiness;
        protected Function<? super T, ? extends V> postProcess;
        protected List<AttributeAndSensorCondition<?>> abortSensorConditions = Lists.newArrayList();
        protected String blockingDetails;
        protected Duration timeout;
        protected Maybe<V> onTimeout = Maybe.absent();
        protected boolean ignoreUnmanaged = false;
        protected Maybe<V> onUnmanaged = Maybe.absent();

        protected Builder(Entity source, AttributeSensor<T> sensor) {
            this.source = source;
            this.sensor = sensor;
        }

        @Deprecated
        public Builder<T, V> readiness(Closure<Boolean> val) {
            this.readiness = GroovyJavaMethods.predicateFromClosure((Closure)((Closure)Preconditions.checkNotNull(val, (Object)"val")));
            return this;
        }

        public Builder<T, V> readiness(Predicate<? super T> val) {
            this.readiness = (Predicate)Preconditions.checkNotNull(val, (Object)"ready");
            return this;
        }

        @Deprecated
        public <V2> Builder<T, V2> postProcess(Closure<V2> val) {
            this.postProcess = GroovyJavaMethods.functionFromClosure((Closure)((Closure)Preconditions.checkNotNull(val, (Object)"postProcess")));
            return this;
        }

        public <V2> Builder<T, V2> postProcess(Function<? super T, V2> val) {
            this.postProcess = (Function)Preconditions.checkNotNull(val, (Object)"postProcess");
            return this;
        }

        public <T2> Builder<T, V> abortIf(Entity source, AttributeSensor<T2> sensor) {
            return this.abortIf(source, sensor, JavaGroovyEquivalents.groovyTruthPredicate());
        }

        public <T2> Builder<T, V> abortIf(Entity source, AttributeSensor<T2> sensor, Predicate<? super T2> predicate) {
            this.abortSensorConditions.add(new AttributeAndSensorCondition<T2>(source, sensor, predicate));
            return this;
        }

        public Builder<T, V> abortIfOnFire() {
            this.abortIf(this.source, Attributes.SERVICE_STATE_ACTUAL, Predicates.equalTo((Object)((Object)Lifecycle.ON_FIRE)));
            return this;
        }

        public Builder<T, V> timeoutIfStoppingOrDestroyed(Duration time) {
            this.timeoutIf(this.source, Attributes.SERVICE_STATE_ACTUAL, Predicates.equalTo((Object)((Object)Lifecycle.STOPPING)), time);
            this.timeoutIf(this.source, Attributes.SERVICE_STATE_ACTUAL, Predicates.equalTo((Object)((Object)Lifecycle.STOPPED)), time);
            this.timeoutIf(this.source, Attributes.SERVICE_STATE_ACTUAL, Predicates.equalTo((Object)((Object)Lifecycle.DESTROYED)), time);
            return this;
        }

        public Builder<T, V> blockingDetails(String val) {
            this.blockingDetails = val;
            return this;
        }

        public Builder<T, V> timeout(Duration val) {
            this.timeout = val;
            return this;
        }

        public <T2> Builder<T, V> timeoutIf(Entity source, AttributeSensor<T2> sensor, Predicate<? super T2> predicate, Duration val) {
            if (predicate.apply(source.sensors().get(sensor))) {
                this.timeout(val);
            }
            return this;
        }

        public Builder<T, V> onTimeoutReturn(V val) {
            this.onTimeout = Maybe.of(val);
            return this;
        }

        public Builder<T, V> onTimeoutThrow() {
            this.onTimeout = Maybe.absent();
            return this;
        }

        public Builder<T, V> onUnmanagedReturn(V val) {
            this.onUnmanaged = Maybe.of(val);
            return this;
        }

        public Builder<T, V> onUnmanagedThrow() {
            this.onUnmanaged = Maybe.absent();
            return this;
        }

        @Deprecated
        public Builder<T, V> onUnmanagedContinue() {
            this.ignoreUnmanaged = true;
            return this;
        }

        protected Builder<T, V> source(Entity source) {
            this.source = source;
            return this;
        }

        protected Builder<T, V> sensor(AttributeSensor<? extends T> sensor) {
            this.sensor = sensor;
            return this;
        }

        public Task<V> build() {
            this.validate();
            return Tasks.builder().dynamic(false).displayName("waiting on " + this.sensor.getName()).description("Waiting on sensor " + this.sensor.getName() + " from " + this.source).tag("attributeWhenReady").tag("TRANSIENT").body(new WaitInTaskForAttributeReady(this)).build();
        }

        public V runNow() {
            this.validate();
            return new WaitInTaskForAttributeReady(this).call();
        }

        private void validate() {
            Preconditions.checkNotNull((Object)this.source, (Object)"Entity source");
            Preconditions.checkNotNull(this.sensor, (Object)"Sensor");
            if (this.readiness == null) {
                this.readiness = JavaGroovyEquivalents.groovyTruthPredicate();
            }
            if (this.postProcess == null) {
                this.postProcess = Functions.identity();
            }
        }
    }

    @Beta
    public static class ProtoBuilder {
        public <T2> Builder<T2, T2> attributeWhenReady(Entity source, AttributeSensor<T2> sensor) {
            return new Builder(source, sensor).abortIfOnFire().timeoutIfStoppingOrDestroyed(Duration.ONE_MINUTE);
        }

        public <T2> Builder<T2, T2> attributeWhenReadyAllowingOnFire(Entity source, AttributeSensor<T2> sensor) {
            return new Builder(source, sensor);
        }

        @Beta
        public <T> MultiBuilder<T, T, List<T>> attributeWhenReadyFromMultiple(Iterable<? extends Entity> sources, AttributeSensor<T> sensor) {
            return this.attributeWhenReadyFromMultiple(sources, sensor, JavaGroovyEquivalents.groovyTruthPredicate());
        }

        @Beta
        public <T> MultiBuilder<T, T, List<T>> attributeWhenReadyFromMultiple(Iterable<? extends Entity> sources, AttributeSensor<T> sensor, Predicate<? super T> readiness) {
            return new MultiBuilder(sources, sensor, readiness);
        }
    }

    public static class AttributeAndSensorCondition<T> {
        protected final Entity source;
        protected final AttributeSensor<T> sensor;
        protected final Predicate<? super T> predicate;

        public AttributeAndSensorCondition(Entity source, AttributeSensor<T> sensor, Predicate<? super T> predicate) {
            this.source = (Entity)Preconditions.checkNotNull((Object)source, (Object)"source");
            this.sensor = (AttributeSensor)Preconditions.checkNotNull(sensor, (Object)"sensor");
            this.predicate = (Predicate)Preconditions.checkNotNull(predicate, (Object)"predicate");
        }

        public String toString() {
            return JavaClassNames.simpleClassName((Object)this) + "[" + this.source + "[" + this.sensor.getName() + "] " + this.predicate + "]";
        }
    }

    public static class MaxThreadsTransformerFunction
    implements Function<List<Object>, ReleaseableLatch> {
        private final Object maxThreads;

        public MaxThreadsTransformerFunction(Object maxThreads) {
            this.maxThreads = maxThreads;
        }

        public ReleaseableLatch apply(List<Object> input) {
            Iterator<Object> taskArgsIterator = input.iterator();
            Integer maxThreadsNum = (Integer)DependentConfiguration.resolveArgument(this.maxThreads, taskArgsIterator, Integer.class);
            return ReleaseableLatch.Factory.newMaxConcurrencyLatch(maxThreadsNum);
        }
    }

    @Beta
    public static class RegexTransformerFunction
    implements Function<List<Object>, Function<String, String>> {
        private final Object pattern;
        private final Object replacement;

        public RegexTransformerFunction(Object pattern, Object replacement) {
            this.pattern = pattern;
            this.replacement = replacement;
        }

        public Function<String, String> apply(List<Object> input) {
            Iterator<Object> taskArgsIterator = input.iterator();
            return new StringFunctions.RegexReplacer(DependentConfiguration.resolveArgument(this.pattern, taskArgsIterator), DependentConfiguration.resolveArgument(this.replacement, taskArgsIterator));
        }
    }

    public static class RegexTransformerString
    implements Function<List<Object>, String> {
        private final Object source;
        private final Object pattern;
        private final Object replacement;

        public RegexTransformerString(Object source, Object pattern, Object replacement) {
            this.source = source;
            this.pattern = pattern;
            this.replacement = replacement;
        }

        @Nullable
        public String apply(@Nullable List<Object> input) {
            Iterator<Object> taskArgsIterator = input.iterator();
            String resolvedSource = DependentConfiguration.resolveArgument(this.source, taskArgsIterator);
            String resolvedPattern = DependentConfiguration.resolveArgument(this.pattern, taskArgsIterator);
            String resolvedReplacement = DependentConfiguration.resolveArgument(this.replacement, taskArgsIterator);
            return new StringFunctions.RegexReplacer(resolvedPattern, resolvedReplacement).apply(resolvedSource);
        }
    }

    protected static class WaitInTaskForAttributeReady<T, V>
    implements Callable<V> {
        private static final boolean DEFAULT_IGNORE_UNMANAGED = false;
        protected final Entity source;
        protected final AttributeSensor<T> sensor;
        protected final Predicate<? super T> ready;
        protected final List<AttributeAndSensorCondition<?>> abortSensorConditions;
        protected final String blockingDetails;
        protected final Function<? super T, ? extends V> postProcess;
        protected final Duration timeout;
        protected final Maybe<V> onTimeout;
        protected final boolean ignoreUnmanaged;
        protected final Maybe<V> onUnmanaged;

        protected WaitInTaskForAttributeReady(Builder<T, V> builder) {
            this.source = builder.source;
            this.sensor = builder.sensor;
            this.ready = builder.readiness;
            this.abortSensorConditions = builder.abortSensorConditions;
            this.blockingDetails = builder.blockingDetails;
            this.postProcess = builder.postProcess;
            this.timeout = builder.timeout;
            this.onTimeout = builder.onTimeout;
            this.ignoreUnmanaged = builder.ignoreUnmanaged;
            this.onUnmanaged = builder.onUnmanaged;
        }

        private WaitInTaskForAttributeReady(Entity source, AttributeSensor<T> sensor, Predicate<? super T> ready, List<AttributeAndSensorCondition<?>> abortConditions, String blockingDetails) {
            this.source = source;
            this.sensor = sensor;
            this.ready = ready;
            this.abortSensorConditions = abortConditions;
            this.blockingDetails = blockingDetails;
            this.timeout = Duration.PRACTICALLY_FOREVER;
            this.onTimeout = Maybe.absent();
            this.ignoreUnmanaged = false;
            this.onUnmanaged = Maybe.absent();
            this.postProcess = null;
        }

        protected V postProcess(T value) {
            if (this.postProcess != null) {
                return (V)this.postProcess.apply(value);
            }
            return (V)value;
        }

        protected boolean ready(T value) {
            if (this.ready != null) {
                return this.ready.apply(value);
            }
            return JavaGroovyEquivalents.groovyTruth(value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public V call() {
            block39: {
                block38: {
                    block35: {
                        block36: {
                            Preconditions.checkNotNull((Object)this.source, (Object)"source");
                            Preconditions.checkNotNull(this.sensor, (Object)("sensor on " + this.source));
                            value = this.source.getAttribute(this.sensor);
                            if (this.ready(value)) {
                                return this.postProcess(value);
                            }
                            abortionExceptions = Lists.newCopyOnWriteArrayList();
                            start = System.currentTimeMillis();
                            for (AttributeAndSensorCondition<?> abortCondition : this.abortSensorConditions) {
                                currentValue = abortCondition.source.getAttribute(abortCondition.sensor);
                                if (!abortCondition.predicate.apply(currentValue)) continue;
                                abortionExceptions.add(new Exception("Abort due to " + abortCondition + ": " + currentValue));
                            }
                            if (!abortionExceptions.isEmpty()) {
                                throw new CompoundRuntimeException("Aborted waiting for ready value from " + this.source + " " + this.sensor.getName(), (Iterable)abortionExceptions);
                            }
                            current = (TaskInternal)Tasks.current();
                            if (current == null) {
                                throw new IllegalStateException("Should only be invoked in a running task");
                            }
                            entity = BrooklynTaskTags.getTargetOrContextEntity(current);
                            if (entity == null) {
                                throw new IllegalStateException("Should only be invoked in a running task with an entity tag; " + current + " has no entity tag (" + current.getStatusDetail(false) + ")");
                            }
                            publishedValues = new LinkedList<E>();
                            semaphore = new Semaphore(0);
                            subscription = null;
                            abortSubscriptions = Lists.newArrayList();
                            try {
                                subscription = entity.subscriptions().subscribe(this.source, this.sensor, (SensorEventListener)new SensorEventListener<T>(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void onEvent(SensorEvent<T> event) {
                                        LinkedList linkedList = publishedValues;
                                        synchronized (linkedList) {
                                            publishedValues.add(event.getValue());
                                        }
                                        semaphore.release();
                                    }
                                });
                                for (final AttributeAndSensorCondition<?> abortCondition : this.abortSensorConditions) {
                                    abortSubscriptions.add(entity.subscriptions().subscribe(abortCondition.source, abortCondition.sensor, (SensorEventListener)new SensorEventListener<Object>(){

                                        public void onEvent(SensorEvent<Object> event) {
                                            if (abortCondition.predicate.apply(event.getValue())) {
                                                abortionExceptions.add(new Exception("Abort due to " + abortCondition + ": " + event.getValue()));
                                                semaphore.release();
                                            }
                                        }
                                    }));
                                    currentValue = abortCondition.source.getAttribute(abortCondition.sensor);
                                    if (!abortCondition.predicate.apply(currentValue)) continue;
                                    abortionExceptions.add(new Exception("Abort due to " + abortCondition + ": " + currentValue));
                                }
                                if (!abortionExceptions.isEmpty()) {
                                    throw new CompoundRuntimeException("Aborted waiting for ready value from " + this.source + " " + this.sensor.getName(), (Iterable)abortionExceptions);
                                }
                                timer = this.timeout != null ? this.timeout.countdownTimer() : null;
                                maxPeriod = ValueResolver.PRETTY_QUICK_WAIT;
                                nextPeriod = ValueResolver.REAL_QUICK_PERIOD;
lbl43:
                                // 2 sources

                                while (!this.ready(value = this.source.getAttribute(this.sensor))) {
                                    if (timer == null) ** GOTO lbl82
                                    if (timer.getDurationRemaining().isShorterThan(nextPeriod)) {
                                        nextPeriod = timer.getDurationRemaining();
                                    }
                                    if (!timer.isExpired()) ** GOTO lbl82
                                    if (this.onTimeout.isPresent()) {
                                        var14_14 /* !! */  = this.onTimeout.get();
                                        if (subscription == null) break block35;
                                        break block36;
                                    }
                                    ** GOTO lbl-1000
                                }
                                ** GOTO lbl121
                            }
                            catch (InterruptedException e) {
                                try {
                                    throw Exceptions.propagate((Throwable)e);
                                }
                                catch (Throwable var19_21) {
                                    if (subscription != null) {
                                        entity.subscriptions().unsubscribe(subscription);
                                    }
                                    var20_22 = abortSubscriptions.iterator();
                                    while (true) {
                                        if (!var20_22.hasNext()) {
                                            throw var19_21;
                                        }
                                        handle = (SubscriptionHandle)var20_22.next();
                                        entity.subscriptions().unsubscribe(handle);
                                    }
                                }
                            }
                        }
                        entity.subscriptions().unsubscribe(subscription);
                    }
                    var15_15 = abortSubscriptions.iterator();
                    while (true) {
                        if (!var15_15.hasNext()) {
                            return var14_14 /* !! */ ;
                        }
                        handle = (SubscriptionHandle)var15_15.next();
                        entity.subscriptions().unsubscribe(handle);
                    }
lbl-1000:
                    // 1 sources

                    {
                        throw new RuntimeTimeoutException("Unsatisfied after " + Duration.sinceUtc((long)start));
lbl82:
                        // 2 sources

                        prevBlockingDetails = current.setBlockingDetails(this.blockingDetails);
                        try {
                            if (semaphore.tryAcquire(nextPeriod.toMilliseconds(), TimeUnit.MILLISECONDS)) {
                                semaphore.release();
                                semaphore.drainPermits();
                            }
                        }
                        finally {
                            current.setBlockingDetails(prevBlockingDetails);
                        }
                        do {
                            var15_15 = publishedValues;
                            synchronized (var15_15) {
                                if (publishedValues.isEmpty()) {
                                    break;
                                }
                                value = publishedValues.pop();
                            }
                        } while (!this.ready(value));
                        if (this.ignoreUnmanaged || !Entities.isNoLongerManaged(entity)) ** GOTO lbl117
                        if (!this.onUnmanaged.isPresent()) ** GOTO lbl-1000
                        var15_15 = this.onUnmanaged.get();
                        if (subscription == null) break block38;
                    }
                    entity.subscriptions().unsubscribe(subscription);
                }
                handle = abortSubscriptions.iterator();
                while (true) {
                    if (!handle.hasNext()) {
                        return (V)var15_15;
                    }
                    handle = (SubscriptionHandle)handle.next();
                    entity.subscriptions().unsubscribe(handle);
                }
lbl-1000:
                // 1 sources

                {
                    throw new NotManagedException((Object)entity);
lbl117:
                    // 1 sources

                    if (!abortionExceptions.isEmpty()) {
                        throw new CompoundRuntimeException("Aborted waiting for ready value from " + this.source + " " + this.sensor.getName(), (Iterable)abortionExceptions);
                    }
                    nextPeriod = nextPeriod.multiply(1.2).upperBound(maxPeriod);
                    ** GOTO lbl43
lbl121:
                    // 1 sources

                    if (DependentConfiguration.access$100().isDebugEnabled()) {
                        DependentConfiguration.access$100().debug("Attribute-ready for {} in entity {}", this.sensor, (Object)this.source);
                    }
                    var14_14 /* !! */  = this.postProcess(value);
                    if (subscription == null) break block39;
                }
                entity.subscriptions().unsubscribe(subscription);
            }
            var15_15 = abortSubscriptions.iterator();
            while (true) {
                if (!var15_15.hasNext()) {
                    return var14_14 /* !! */ ;
                }
                handle = (SubscriptionHandle)var15_15.next();
                entity.subscriptions().unsubscribe(handle);
            }
        }
    }
}

