/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.workflow.ShorthandProcessor;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowReplayUtils;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.util.collections.CollectionMerger;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.predicates.DslPredicates;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public abstract class WorkflowStepDefinition {
    private static final Logger log = LoggerFactory.getLogger(WorkflowStepDefinition.class);
    protected String id;
    protected String name;
    protected Object metadata;
    protected String userSuppliedShorthand;
    protected String shorthandTypeName;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected Map<String, Object> input = MutableMap.of();
    @JsonProperty(value="next")
    protected String next;
    protected Object condition;
    protected Object output;
    protected String replayable;
    protected String idempotent;
    @JsonProperty(value="timeout")
    protected Duration timeout;
    @JsonProperty(value="on-error")
    protected Object onError = MutableList.of();

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public Object getConditionRaw() {
        return this.condition;
    }

    @JsonIgnore
    public DslPredicates.DslPredicate getConditionResolved(WorkflowStepInstanceExecutionContext context) {
        try {
            return context.context.resolveCondition(this.getConditionRaw());
        }
        catch (Exception e) {
            throw Exceptions.propagateAnnotated((String)("Unresolveable condition (" + this.getConditionRaw() + ")"), (Throwable)e);
        }
    }

    protected boolean isOutputHandledByTask() {
        return false;
    }

    protected Pair<WorkflowReplayUtils.ReplayableAtStepOption, Boolean> validateReplayableAndIdempotent() {
        return WorkflowReplayUtils.validateReplayableAndIdempotentAtStep(this.replayable, this.idempotent, false);
    }

    @JsonIgnore
    public Duration getTimeout() {
        return this.timeout;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Object getOnError() {
        return this.onError;
    }

    @JsonAnySetter
    public void setInput(String key, Object value) {
        this.input.put(key, value);
    }

    public <T> void setInput(ConfigKey<T> key, T value) {
        this.input.put(key.getName(), value);
    }

    public void setInput(Map<String, Object> input) {
        this.input.putAll(input);
    }

    public Map<String, Object> getInput() {
        return this.input;
    }

    public abstract void populateFromShorthand(String var1);

    protected void populateFromShorthandTemplate(String template, String value) {
        this.populateFromShorthandTemplate(template, value, false, true, true);
    }

    protected Map<String, Object> populateFromShorthandTemplate(String template, String value, boolean finalMatchRaw, boolean failOnMismatch, boolean failOnError) {
        Maybe<Map<String, Object>> result = new ShorthandProcessor(template).withFinalMatchRaw(finalMatchRaw).withFailOnMismatch(failOnMismatch).process(value);
        if (result.isAbsent()) {
            if (failOnError) {
                throw new IllegalArgumentException("Invalid shorthand expression: '" + value + "'", Maybe.Absent.getException(result));
            }
            return null;
        }
        this.input.putAll(CollectionMerger.builder().build().merge(this.input, (Map)result.get()));
        return (Map)result.get();
    }

    final Task<?> newTask(WorkflowStepInstanceExecutionContext context) {
        return this.newTask(context, null, null, null);
    }

    public final Task<?> newTaskAsSubTask(WorkflowStepInstanceExecutionContext context, String specialName, BrooklynTaskTags.WorkflowTaskTag specialTag) {
        return this.newTask(context, null, specialName, specialTag);
    }

    final Task<?> newTaskContinuing(WorkflowStepInstanceExecutionContext context, ReplayContinuationInstructions continuationInstructions) {
        return this.newTask(context, (ReplayContinuationInstructions)Preconditions.checkNotNull((Object)continuationInstructions), null, null);
    }

    protected Task<?> newTask(WorkflowStepInstanceExecutionContext context, ReplayContinuationInstructions continuationInstructions, String specialName, BrooklynTaskTags.WorkflowTaskTag tagOverride) {
        Task<Object> t = Tasks.builder().displayName(specialName != null ? specialName : this.computeName(context, true)).tag(tagOverride != null ? tagOverride : BrooklynTaskTags.tagForWorkflow(context)).tag("WORKFLOW").tag("inessential").body(() -> {
            log.debug("Starting " + (specialName != null ? specialName : "step " + context.getWorkflowExectionContext().getWorkflowStepReference(context.stepIndex, this)) + (Strings.isNonBlank((CharSequence)this.name) ? " '" + this.name + "'" : "") + (continuationInstructions != null ? " (continuation" + (continuationInstructions.customBehaviorExplanation != null ? " - " + continuationInstructions.customBehaviorExplanation : "") + ")" : "") + " in task " + Tasks.current().getId());
            Callable<Object> handler = null;
            if (continuationInstructions != null && this instanceof WorkflowStepDefinitionWithSubWorkflow) {
                SubWorkflowsForReplay unfinished = ((WorkflowStepDefinitionWithSubWorkflow)((Object)this)).getSubWorkflowsForReplay(context, continuationInstructions.forced, false, true);
                if (unfinished.isResumableAtSubworkflows) {
                    handler = () -> ((WorkflowStepDefinitionWithSubWorkflow)((Object)this)).doTaskBodyWithSubWorkflowsForReplay(context, unfinished.subworkflows, continuationInstructions);
                } else if (!unfinished.isResumableOnlyAtParent && !continuationInstructions.forced) {
                    throw new IllegalStateException("Cannot continue, due to non-idempotent workflows and not forced");
                }
            }
            if (handler == null) {
                handler = () -> {
                    if (continuationInstructions != null && continuationInstructions.customBehavior != null) {
                        continuationInstructions.customBehavior.run();
                    }
                    return this.doTaskBody(context);
                };
            }
            Object result = handler.call();
            if (log.isTraceEnabled()) {
                log.trace("Completed task for " + this.computeName(context, true) + ", output " + result);
            }
            return result;
        }).build();
        context.taskId = t.getId();
        return t;
    }

    protected abstract Object doTaskBody(WorkflowStepInstanceExecutionContext var1);

    public String computeName(WorkflowStepInstanceExecutionContext context, boolean includeStepNumber) {
        MutableList parts = MutableList.of();
        if (includeStepNumber) {
            parts.add("" + (context.stepIndex + 1));
        }
        boolean hasId = false;
        if (context.stepDefinitionDeclaredId != null) {
            hasId = true;
            String s = context.stepDefinitionDeclaredId;
            if (!parts.isEmpty() && s.startsWith((String)parts.get(0)) && (Strings.isBlank((CharSequence)(s = Strings.removeFromStart((String)s, (String)((String)parts.get(0))))) || !Character.isDigit(s.charAt(0)))) {
                parts.remove(0);
            }
            parts.add(context.stepDefinitionDeclaredId);
        }
        if (Strings.isNonBlank((CharSequence)context.name)) {
            String last;
            String string = last = parts.isEmpty() ? null : (String)parts.get(parts.size() - 1);
            if (last != null && context.name.startsWith(last)) {
                parts.remove(parts.size() - 1);
            }
            parts.add(context.name);
        } else if (!hasId) {
            if (Strings.isNonBlank((CharSequence)this.userSuppliedShorthand)) {
                parts.add(this.userSuppliedShorthand);
            } else {
                parts.add(this.getShorthandTypeName());
            }
        }
        return Strings.join((Iterable)parts, (String)" - ");
    }

    public void setShorthandTypeName(String shorthandTypeDefinition) {
        this.shorthandTypeName = shorthandTypeDefinition;
    }

    @JsonProperty(value="shorthandTypeName")
    public String getShorthandTypeName() {
        if (Strings.isNonBlank((CharSequence)this.shorthandTypeName)) {
            return this.shorthandTypeName;
        }
        String name = this.getClass().getSimpleName();
        if (Strings.isBlank((CharSequence)name)) {
            return this.getClass().getCanonicalName();
        }
        name = Strings.removeFromEnd((String)name, (String)"WorkflowStep");
        return name;
    }

    public void validateStep(@Nullable ManagementContext mgmt, @Nullable WorkflowExecutionContext workflow) {
        this.validateReplayableAndIdempotent();
    }

    @JsonIgnore
    protected Object getStepState(WorkflowStepInstanceExecutionContext context) {
        return context.getStepState();
    }

    Boolean isIdempotent(WorkflowStepInstanceExecutionContext csi) {
        Boolean idempotence = (Boolean)this.validateReplayableAndIdempotent().getRight();
        if (idempotence == null && csi != null && csi.getWorkflowExectionContext() != null) {
            idempotence = csi.getWorkflowExectionContext().idempotentAll;
        }
        if (idempotence == null) {
            idempotence = this.isDefaultIdempotent();
        }
        return idempotence;
    }

    protected abstract Boolean isDefaultIdempotent();

    public static class ReplayContinuationInstructions {
        public final Integer stepToReplayFrom;
        public final String customBehaviorExplanation;
        public final Runnable customBehavior;
        public final boolean forced;
        public Map<String, Object> customWorkflowScratchVariables;

        public ReplayContinuationInstructions(Integer stepToReplayFrom, String customBehaviourExplanation, Runnable customBehavior, boolean forced) {
            this.stepToReplayFrom = stepToReplayFrom;
            this.customBehaviorExplanation = customBehaviourExplanation;
            this.customBehavior = customBehavior;
            this.forced = forced;
        }

        public String toString() {
            return "Replay[" + (Strings.isNonBlank((CharSequence)this.customBehaviorExplanation) ? this.customBehaviorExplanation : "(no explanation)") + (this.stepToReplayFrom != null ? "; step " + this.stepToReplayFrom : "; continuing from last") + (this.forced ? "; FORCED" : "") + "]";
        }
    }

    public static interface WorkflowStepDefinitionWithSubWorkflow {
        @JsonIgnore
        public SubWorkflowsForReplay getSubWorkflowsForReplay(WorkflowStepInstanceExecutionContext var1, boolean var2, boolean var3, boolean var4);

        public Object doTaskBodyWithSubWorkflowsForReplay(WorkflowStepInstanceExecutionContext var1, @Nonnull List<WorkflowExecutionContext> var2, ReplayContinuationInstructions var3);
    }

    public static class SubWorkflowsForReplay {
        public String notes;
        public boolean hasNonResumableWorkflows;
        public boolean isResumableOnlyAtParent;
        public boolean isResumableAtSubworkflows;
        public List<WorkflowExecutionContext> subworkflows;
    }

    public static interface WorkflowStepDefinitionWithSpecialDeserialization {
        public WorkflowStepDefinition applySpecialDefinition(ManagementContext var1, Object var2, String var3, WorkflowStepDefinitionWithSpecialDeserialization var4);
    }
}

