/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.flow;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.reflect.TypeToken;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.workflow.ShorthandProcessor;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowExpressionResolution;
import org.apache.brooklyn.core.workflow.WorkflowReplayUtils;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.QuotedStringTokenizer;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryWorkflowStep
extends WorkflowStepDefinition {
    private static final Logger log = LoggerFactory.getLogger(RetryWorkflowStep.class);
    public static final String SHORTHAND = "[ ?${replay} \"replay\" ] [ \" from \" ${next} ] [ \" limit \" ${limit...} ] [ \" backoff \" ${backoff...} ] [ \" timeout \" ${timeout} ]";
    public static final ConfigKey<RetryReplayOption> REPLAY = ConfigKeys.newConfigKey(RetryReplayOption.class, "replay");
    public static final ConfigKey<List<RetryLimit>> LIMIT = ConfigKeys.newConfigKey(new TypeToken<List<RetryLimit>>(){}, "limit");
    public static final ConfigKey<RetryBackoff> BACKOFF = ConfigKeys.newConfigKey(RetryBackoff.class, "backoff");
    public static final ConfigKey<String> HASH = ConfigKeys.newStringConfigKey("hash");

    @Override
    public void populateFromShorthand(String expression) {
        Duration timeout;
        String next;
        this.populateFromShorthandTemplate(SHORTHAND, expression);
        Object limit = this.input.remove(LIMIT.getName());
        if (limit != null) {
            if (limit instanceof String) {
                this.setInput(LIMIT, MutableList.of((Object)RetryLimit.fromString((String)limit)));
            } else if (limit instanceof List) {
                this.setInput(LIMIT, (List)limit);
            } else {
                throw new IllegalStateException("Invalid value for limit: " + limit);
            }
        }
        if (Strings.isNonBlank((CharSequence)(next = TypeCoercions.coerce(this.input.remove("next"), String.class)))) {
            this.next = next;
        }
        if ((timeout = TypeCoercions.coerce(this.input.remove("timeout"), Duration.class)) != null) {
            this.timeout = timeout;
        }
        if (Boolean.FALSE.equals(this.input.get(REPLAY.getName()))) {
            this.input.remove(REPLAY.getName());
        }
    }

    @Override
    public void validateStep(@Nullable ManagementContext mgmt, @Nullable WorkflowExecutionContext workflow) {
        super.validateStep(mgmt, workflow);
        TypeCoercions.coerce(this.input.get(REPLAY.getName()), REPLAY.getTypeToken());
        TypeCoercions.coerce(this.input.get(LIMIT.getName()), LIMIT.getTypeToken());
        TypeCoercions.coerce(this.input.get(BACKOFF.getName()), BACKOFF.getTypeToken());
    }

    @Override
    @JsonIgnore
    public Duration getTimeout() {
        return null;
    }

    @JsonIgnore
    public Duration getMaximumRetryTimeout() {
        return super.getTimeout();
    }

    @Override
    protected Object doTaskBody(WorkflowStepInstanceExecutionContext context) {
        Duration sinceFirst;
        Instant oldest;
        Duration t;
        String hash = (String)Strings.firstNonBlank((CharSequence[])new String[]{context.getInput(HASH), context.getWorkflowExectionContext().getWorkflowStepReference(Tasks.current())});
        List retries = context.getWorkflowExectionContext().getRetryRecords().compute(hash, (k, v) -> v != null ? v : MutableList.of());
        List<RetryLimit> limit = context.getInput(LIMIT);
        if (limit != null) {
            limit.forEach(l -> {
                Maybe<String> reachedMessage = l.isReached(retries);
                if (reachedMessage.isPresent()) {
                    throw new RetriesExceeded((String)reachedMessage.get(), context.getError());
                }
            });
        }
        if ((t = this.getMaximumRetryTimeout()) != null && (oldest = (Instant)retries.stream().min((i1, i2) -> i1.compareTo((Instant)i2)).orElse(null)) != null && (sinceFirst = Duration.between((Instant)oldest, (Instant)Instant.now())).isLongerThan(t)) {
            throw Exceptions.propagate((Throwable)new TimeoutException("Workflow duration of " + sinceFirst + " exceeds timeout of " + t).initCause(context.getError()));
        }
        RetryBackoff backoff = context.getInput(BACKOFF);
        if (backoff != null) {
            Duration delay;
            int exponent = 0;
            if (backoff.initial != null && !backoff.initial.isEmpty()) {
                if (backoff.initial.size() > retries.size()) {
                    delay = backoff.initial.get(retries.size());
                } else {
                    delay = backoff.initial.get(backoff.initial.size() - 1);
                    exponent = 1 + retries.size() - backoff.initial.size();
                }
            } else {
                delay = Duration.ZERO;
            }
            if (backoff.factor != null) {
                while (exponent-- > 0) {
                    delay = delay.multiply(backoff.factor.doubleValue());
                }
            }
            if (backoff.increase != null) {
                delay = delay.add(backoff.increase.multiply((long)exponent));
            }
            if (backoff.jitter != null) {
                delay = delay.multiply(1.0 + Math.random() * backoff.jitter);
            }
            if (backoff.max != null && delay.isLongerThan(backoff.max)) {
                delay = backoff.max;
                if (backoff.jitter != null) {
                    delay = delay.multiply(1.0 / (1.0 + Math.random() * backoff.jitter));
                }
            }
            if (delay.isPositive()) {
                Duration ddelay = delay;
                try {
                    Tasks.withBlockingDetails("Waiting " + delay + " before retry #" + (retries.size() + 1), () -> {
                        log.debug("Waiting " + ddelay + " before retry #" + (retries.size() + 1));
                        Time.sleep((Duration)ddelay);
                        return null;
                    });
                }
                catch (Exception e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        }
        retries.add(Instant.now());
        context.getWorkflowExectionContext().getRetryRecords().put(hash, retries);
        boolean inErrorHandler = !context.equals(context.getWorkflowExectionContext().getCurrentStepInstance());
        RetryReplayOption replay = context.getInput(REPLAY);
        String next = this.next;
        if (replay == null) {
            RetryReplayOption retryReplayOption = replay = next == null ? RetryReplayOption.TRUE : RetryReplayOption.FALSE;
            if (next == null) {
                next = inErrorHandler ? "end" : "last";
            }
        } else if (next == null) {
            next = "last";
        }
        if (replay != RetryReplayOption.FALSE) {
            context.next = null;
            if ("end".equals(next)) {
                if (!inErrorHandler) {
                    log.warn("Retry target `end` is only permitted inside an error handler; using `last` instead");
                    next = "last";
                } else {
                    context.next = context.getWorkflowExectionContext().factory(true).makeInstructionsForReplayResuming("Retry replay from '" + next + "' per step " + context.getWorkflowExectionContext().getWorkflowStepReference(Tasks.current()), replay == RetryReplayOption.FORCE);
                }
            }
            if (context.next == null) {
                if ("last".equals(next)) {
                    int lastReplayStep;
                    context.next = null;
                    int n = lastReplayStep = context.getWorkflowExectionContext().getReplayableLastStep() != null ? context.getWorkflowExectionContext().getReplayableLastStep() : -1;
                    if (!inErrorHandler && context.getStepIndex() == lastReplayStep) {
                        lastReplayStep = WorkflowReplayUtils.findNearestReplayPoint(context.getWorkflowExectionContext(), lastReplayStep, false);
                    }
                    context.next = context.getWorkflowExectionContext().factory(true).makeInstructionsForReplayingFromStep(lastReplayStep, "Retry replay per step " + context.getWorkflowExectionContext().getWorkflowStepReference(Tasks.current()), replay == RetryReplayOption.FORCE);
                } else {
                    context.next = context.getWorkflowExectionContext().factory(true).makeInstructionsForReplayingFromStep((Integer)((Pair)context.getWorkflowExectionContext().getIndexOfStepId(next).get()).getLeft(), "Retry replay from '" + next + "' per step " + context.getWorkflowExectionContext().getWorkflowStepReference(Tasks.current()), replay == RetryReplayOption.FORCE);
                }
            }
            log.debug("Retrying with " + context.next);
        } else {
            if (next == null) {
                throw new IllegalStateException("Cannot retry with replay disabled and no specified next");
            }
            context.next = context.resolve(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_RUNNING, next);
            log.debug("Retrying from explicit next step '" + context.next + "'");
        }
        return context.getPreviousStepOutput();
    }

    @Override
    protected Boolean isDefaultIdempotent() {
        return true;
    }

    public static class RetriesExceeded
    extends RuntimeException {
        public RetriesExceeded(String message) {
            super(message);
        }

        public RetriesExceeded(String message, Throwable cause) {
            super(message, cause);
        }

        public RetriesExceeded(Throwable cause) {
            super(cause);
        }
    }

    public static class RetryBackoff {
        List<Duration> initial;
        Double factor;
        Duration increase;
        Double jitter;
        Duration max;

        public void setInitial(List<Duration> initial) {
            this.initial = initial;
        }

        public void setInitial(String initial) {
            this.initial = MutableList.of((Object)Duration.of((Object)initial));
        }

        public static RetryBackoff fromString(String s) {
            Maybe<Map<String, Object>> resultM = new ShorthandProcessor("${initial...} [ \" increasing \" ${factor} ] [ \" up to \" ${max}] [ \" jitter \" ${jitter} ]").process(s);
            if (resultM.isAbsent()) {
                throw new IllegalArgumentException("Invalid shorthand expression for backoff: '" + s + "'", Maybe.Absent.getException(resultM));
            }
            RetryBackoff result = new RetryBackoff();
            String initialS = TypeCoercions.coerce(((Map)resultM.get()).get("initial"), String.class);
            if (Strings.isBlank((CharSequence)initialS)) {
                throw new IllegalArgumentException("initial duration required for backoff");
            }
            result.initial = QuotedStringTokenizer.builder().includeQuotes(true).includeDelimiters(false).expectQuotesDelimited(true).failOnOpenQuote(true).build(initialS).remainderAsList().stream().map(Duration::of).collect(Collectors.toList());
            String factor = (String)((Map)resultM.get()).get("factor");
            if (factor != null) {
                if ((factor = factor.trim()).endsWith("x")) {
                    result.factor = TypeCoercions.coerce((Object)Strings.removeFromEnd((String)factor, (String)"x"), Double.class);
                } else if (factor.endsWith("%")) {
                    result.factor = 1.0 + TypeCoercions.coerce((Object)Strings.removeFromEnd((String)factor, (String)"%"), Double.class) / 100.0;
                } else {
                    result.increase = Duration.of((Object)factor);
                }
            }
            result.max = TypeCoercions.coerce(((Map)resultM.get()).get("max"), Duration.class);
            String j = (String)((Map)resultM.get()).get("jitter");
            if (j != null) {
                boolean percent = (j = j.trim()).endsWith("%");
                if (percent) {
                    j = Strings.removeFromEnd((String)j, (String)"%").trim();
                }
                result.jitter = TypeCoercions.coerce((Object)j, Double.class);
                if (percent) {
                    RetryBackoff retryBackoff = result;
                    retryBackoff.jitter = retryBackoff.jitter / 100.0;
                }
            }
            return result;
        }
    }

    public static class RetryLimit {
        public Integer count;
        public Duration duration;

        public static RetryLimit fromInteger(Integer i) {
            return RetryLimit.fromString("" + i);
        }

        public static RetryLimit fromString(String s) {
            RetryLimit result = new RetryLimit();
            String[] parts = s.trim().split(" +");
            if (parts.length >= 3 && "in".equals(parts[1])) {
                result.count = Integer.parseInt(parts[0]);
                result.duration = Duration.of((Object)Arrays.asList(parts).subList(2, parts.length).stream().collect(Collectors.joining(" ")));
            } else {
                Pair<Integer, Duration> parse = null;
                Exception problem = null;
                try {
                    parse = RetryLimit.parseCountOrDuration(s);
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    problem = e;
                }
                if (parse == null) {
                    throw new IllegalStateException("Illegal expression for retry limit, should be '${count}`, '${duration}', or '${count} in ${duration}': " + s, problem);
                }
                result.count = (Integer)parse.getLeft();
                result.duration = (Duration)parse.getRight();
            }
            return result;
        }

        public static Pair<Integer, Duration> parseCountOrDuration(String phrase) {
            if (phrase == null) {
                return null;
            }
            if ((phrase = phrase.trim()).isEmpty()) {
                return null;
            }
            if (Character.isLetter(phrase.charAt(phrase.length() - 1))) {
                return Pair.of(null, (Object)Duration.parse((String)phrase));
            }
            return Pair.of((Object)Integer.parseInt(phrase), null);
        }

        public Maybe<String> isReached(List<Instant> retries) {
            Instant now = Instant.now();
            if (this.count == null) {
                if (this.duration == null) {
                    return Maybe.absent((String)"No limit");
                }
                Optional oldest = retries.stream().min(Instant::compareTo);
                if (oldest.isPresent() && this.duration.isShorterThan(Duration.between((Instant)((Instant)oldest.get()), (Instant)now))) {
                    return Maybe.of((Object)((retries.size() == 1 ? "1 retry" : retries.size() + " retries") + " since " + Duration.between((Instant)((Instant)oldest.get()), (Instant)now) + " ago (limit " + this + ")"));
                }
            } else {
                List filtered = retries.stream().filter(r -> this.duration == null || this.duration.isLongerThan(Duration.between((Instant)r, (Instant)now))).collect(Collectors.toList());
                if (filtered.size() >= this.count) {
                    if (filtered.isEmpty()) {
                        return Maybe.of((Object)"Max count 0 reached");
                    }
                    return Maybe.of((Object)((filtered.size() < retries.size() ? retries.size() + " retries total, " + filtered.size() : (retries.size() == 1 ? "1 retry" : retries.size() + " retries") + " total") + " since " + Duration.between((Instant)((Instant)filtered.get(0)), (Instant)now) + " ago (limit " + this + ")"));
                }
            }
            return Maybe.absent((String)"Limit not reached");
        }

        public String toString() {
            return this.count != null && this.duration != null ? this.count + " in " + this.duration : (this.count != null ? "" + this.count : (this.duration != null ? "" + this.duration : "RetryLimit<unset>"));
        }
    }

    public static enum RetryReplayOption {
        TRUE,
        FALSE,
        FORCE;

    }
}

