/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.variables;

import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.workflow.WorkflowExpressionResolution;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.core.workflow.steps.variables.TypedValueToSet;
import org.apache.brooklyn.util.text.Strings;

public class ClearVariableWorkflowStep
extends WorkflowStepDefinition {
    public static final String SHORTHAND = "[ ${variable.type} ] ${variable.name}";
    public static final ConfigKey<TypedValueToSet> VARIABLE = ConfigKeys.newConfigKey(TypedValueToSet.class, "variable");

    @Override
    public void populateFromShorthand(String expression) {
        this.populateFromShorthandTemplate(SHORTHAND, expression);
    }

    @Override
    protected Object doTaskBody(WorkflowStepInstanceExecutionContext context) {
        TypedValueToSet variable = context.getInput(VARIABLE);
        if (variable == null) {
            throw new IllegalArgumentException("Variable name is required");
        }
        String name = context.resolve(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_INPUT, (Object)variable.name, String.class);
        if (Strings.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Variable name is required");
        }
        context.getWorkflowExectionContext().updateWorkflowScratchVariable(name, null);
        return context.getPreviousStepOutput();
    }

    @Override
    protected Boolean isDefaultIdempotent() {
        return true;
    }
}

