/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.store;

import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.store.WorkflowRetentionAndExpiration;
import org.apache.brooklyn.core.workflow.store.WorkflowStateActiveInMemory;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.guava.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowStatePersistenceViaSensors {
    private static final Logger log = LoggerFactory.getLogger(WorkflowStatePersistenceViaSensors.class);
    public static final ConfigKey<WorkflowStatePersistenceViaSensors> SENSOR_WORKFLOW_PERSISTER = ConfigKeys.newConfigKey(WorkflowStatePersistenceViaSensors.class, "internals.brooklyn.workflow.sensor_persister");
    public static final AttributeSensor<Map<String, WorkflowExecutionContext>> INTERNAL_WORKFLOWS = Sensors.newSensor(new TypeToken<Map<String, WorkflowExecutionContext>>(){}, "internals.brooklyn.workflow");
    private static final long GLOBAL_UPDATE_FREQUENCY = 300000L;
    private final ManagementContext mgmt;
    long lastInMemClear = System.currentTimeMillis();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkflowStatePersistenceViaSensors get(ManagementContext mgmt) {
        WorkflowStatePersistenceViaSensors sharedInstance = (WorkflowStatePersistenceViaSensors)mgmt.getScratchpad().get(SENSOR_WORKFLOW_PERSISTER);
        if (sharedInstance == null) {
            ConfigKey<WorkflowStatePersistenceViaSensors> configKey = SENSOR_WORKFLOW_PERSISTER;
            synchronized (configKey) {
                sharedInstance = (WorkflowStatePersistenceViaSensors)mgmt.getScratchpad().get(SENSOR_WORKFLOW_PERSISTER);
                if (sharedInstance == null) {
                    sharedInstance = new WorkflowStatePersistenceViaSensors(mgmt);
                    mgmt.getScratchpad().put(SENSOR_WORKFLOW_PERSISTER, (Object)sharedInstance);
                }
            }
        }
        return sharedInstance;
    }

    public WorkflowStatePersistenceViaSensors(ManagementContext mgmt) {
        this.mgmt = mgmt;
    }

    public void checkpoint(WorkflowExecutionContext context) {
        this.checkpoint(context, PersistenceWithQueuedTasks.WARN);
    }

    public void checkpoint(WorkflowExecutionContext context, PersistenceWithQueuedTasks expectQueuedTasks) {
        List tasks;
        this.doGlobalUpdateIfNeeded();
        Entity entity = context.getEntity();
        if (Entities.isUnmanagingOrNoLongerManaged(entity)) {
            log.debug("Skipping persistence of " + context + " as entity is no longer active here");
            return;
        }
        WorkflowStateActiveInMemory.get(context.getManagementContext()).checkpoint(context);
        if (Boolean.TRUE.equals(context.getRetentionSettings().disabled)) {
            if (this.getFromTag(BrooklynTaskTags.tagForWorkflow(context), false) != null) {
                this.updateMap(entity, false, true, v -> v.remove(context.getWorkflowId(), context));
            }
            return;
        }
        if (expectQueuedTasks != PersistenceWithQueuedTasks.ALLOW && DynamicTasks.getTaskQueuingContext() != null && !(tasks = DynamicTasks.getTaskQueuingContext().getQueue().stream().filter(t -> !t.isDone()).collect(Collectors.toList())).isEmpty()) {
            String msg = "Persisting " + context + " when there are still queued tasks (probably an error): " + tasks;
            if (expectQueuedTasks == PersistenceWithQueuedTasks.FAIL) {
                throw new IllegalStateException(msg);
            }
            log.warn(msg);
        }
        this.expireOldWorkflows(entity, context);
    }

    private void doGlobalUpdateIfNeeded() {
        if (this.lastInMemClear + 300000L > System.currentTimeMillis()) {
            return;
        }
        this.lastInMemClear = System.currentTimeMillis();
        AtomicInteger total = new AtomicInteger(0);
        Collection entities = this.mgmt.getEntityManager().getEntities();
        entities.forEach(entity -> {
            int change = this.expireOldWorkflows((Entity)entity, null);
            if (change != 0) {
                log.debug("Global entity workflow persistence update, removed " + -change + " workflows from " + entity);
            }
            total.addAndGet(change);
        });
        if (total.get() != 0) {
            log.debug("Global entity workflow persistence update, removed " + -total.get() + " workflows across all " + entities.size() + " entities");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int expireOldWorkflows(Entity entity, @Nullable WorkflowExecutionContext context) {
        boolean interrupted = Thread.interrupted();
        boolean doExpiry = WorkflowRetentionAndExpiration.isExpirationCheckNeeded(entity);
        try {
            int n = this.updateMap(entity, doExpiry, true, context == null ? null : v -> v.put(context.getWorkflowId(), context));
            return n;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean deleteWorkflow(WorkflowExecutionContext w) {
        if (w.getStatus() == null || w.getStatus().expirable || w.getStatus() == WorkflowExecutionContext.WorkflowStatus.STAGED) {
            log.debug("Explicit request to delete workflow " + w);
            AtomicBoolean result = new AtomicBoolean(false);
            this.updateMap(w.getEntity(), false, true, map -> {
                boolean removed = WorkflowRetentionAndExpiration.deleteWorkflowFromMap(map, w, true);
                if (removed) {
                    result.set(true);
                }
            });
            return result.get();
        }
        log.warn("Explicit request to delete non-expirable workflow " + w + "; ignoring");
        return false;
    }

    int updateMap(Entity entity, boolean doExpiry, boolean persist, Consumer<Map<String, WorkflowExecutionContext>> action) {
        AtomicInteger delta = new AtomicInteger(0);
        entity.sensors().modify(INTERNAL_WORKFLOWS, vo -> {
            Object v = MutableMap.copyOf((Map)vo);
            delta.set(-v.size());
            if (action != null) {
                action.accept((Map<String, WorkflowExecutionContext>)v);
            }
            if (doExpiry) {
                v = WorkflowRetentionAndExpiration.recomputeExpiration((Map<String, WorkflowExecutionContext>)v, null);
            }
            delta.getAndAdd(v.size());
            return Maybe.of((Object)v);
        });
        if (persist) {
            this.mgmt.getRebindManager().forcePersistNow(false, null);
        }
        return delta.get();
    }

    public Map<String, WorkflowExecutionContext> getWorkflows(Entity entity) {
        MutableMap<String, WorkflowExecutionContext> result = WorkflowStateActiveInMemory.get(this.mgmt).getWorkflowsCopy(entity);
        result.add((Map)entity.sensors().get(INTERNAL_WORKFLOWS));
        return result;
    }

    public void updateWithoutPersist(Entity entity, List<WorkflowExecutionContext> workflows) {
        if (workflows != null && !workflows.isEmpty()) {
            entity.sensors().modify(INTERNAL_WORKFLOWS, vo -> {
                if (vo == null) {
                    throw new IllegalStateException("Update workflows requested for " + workflows + " when none recorded against " + entity);
                }
                MutableMap v = MutableMap.copyOf((Map)vo);
                workflows.forEach(arg_0 -> WorkflowStatePersistenceViaSensors.lambda$null$6((Map)v, arg_0));
                return Maybe.of((Object)v);
            });
        }
    }

    public Maybe<WorkflowExecutionContext> getFromTag(BrooklynTaskTags.WorkflowTaskTag tag) {
        return this.getFromTag(tag, true);
    }

    private Maybe<WorkflowExecutionContext> getFromTag(BrooklynTaskTags.WorkflowTaskTag tag, boolean allowInMemory) {
        Entity targetEntity = (Entity)this.mgmt.lookup(tag.getEntityId(), Entity.class);
        if (targetEntity == null) {
            return Maybe.absent((String)("Entity " + tag.getWorkflowId() + " not found"));
        }
        WorkflowExecutionContext w = null;
        if (allowInMemory) {
            w = WorkflowStateActiveInMemory.get(this.mgmt).getFromTag(tag);
        }
        if (w == null) {
            w = new WorkflowStatePersistenceViaSensors(this.mgmt).getWorkflows(targetEntity).get(tag.getWorkflowId());
        }
        if (w == null) {
            return Maybe.absent((String)("Workflow " + tag.getWorkflowId() + " not found on entity " + targetEntity + "; possibly expired?"));
        }
        return Maybe.of((Object)w);
    }

    private static /* synthetic */ void lambda$null$6(Map v, WorkflowExecutionContext w) {
        v.put(w.getWorkflowId(), w);
    }

    static enum PersistenceWithQueuedTasks {
        ALLOW,
        WARN,
        FAIL;

    }
}

