/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.enricher.stock;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Map;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.enricher.stock.AbstractMultipleSensorAggregator;
import org.apache.brooklyn.util.collections.MutableMap;

@Catalog(name="Map Aggregator", description="Aggregates a pair of sensors on multiple children and/or members that are used as key-value pairs in a generated Map")
public class MapAggregator<U>
extends AbstractMultipleSensorAggregator<U> {
    public static final ConfigKey<Sensor<?>> KEY_SENSOR = ConfigKeys.newConfigKey(new TypeToken<Sensor<?>>(){}, "enricher.keySensor", "The sensor to use for the key in the map entry");
    public static final ConfigKey<Sensor<?>> VALUE_SENSOR = ConfigKeys.newConfigKey(new TypeToken<Sensor<?>>(){}, "enricher.valueSensor", "The sensor to use for the value in the map entry");
    private Sensor<?> keySensor;
    private Sensor<?> valueSensor;

    @Override
    protected Object compute() {
        MutableMap ks = MutableMap.copyOf((Map)Maps.filterValues(this.getValues(this.keySensor), (Predicate)this.valueFilter));
        MutableMap vs = MutableMap.copyOf((Map)Maps.filterValues(this.getValues(this.valueSensor), (Predicate)this.valueFilter));
        MutableMap result = MutableMap.of();
        for (Entity entity : ks.keySet()) {
            if (!vs.containsKey(entity)) continue;
            result.put(ks.get(entity), vs.get(entity));
        }
        return result;
    }

    @Override
    protected Collection<Sensor<?>> getSourceSensors() {
        this.keySensor = (Sensor)this.config().get(KEY_SENSOR);
        this.valueSensor = (Sensor)this.config().get(VALUE_SENSOR);
        return ImmutableList.of(this.keySensor, this.valueSensor);
    }
}

