/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.feed.ssh;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.feed.AbstractCommandFeed;
import org.apache.brooklyn.feed.CommandPollConfig;
import org.apache.brooklyn.feed.ssh.SshPollValue;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.core.internal.ssh.SshTool;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.ssh.SshTasks;
import org.apache.brooklyn.util.core.task.ssh.internal.PlainSshExecTaskFactory;
import org.apache.brooklyn.util.core.task.system.ProcessTaskFactory;
import org.apache.brooklyn.util.core.task.system.ProcessTaskStub;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.core.task.system.internal.AbstractProcessTaskFactory;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.text.Identifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshFeed
extends AbstractCommandFeed {
    public static final Logger log = LoggerFactory.getLogger(SshFeed.class);

    public static Builder builder() {
        return new Builder();
    }

    public SshFeed() {
    }

    public SshFeed(Builder builder) {
        super(builder);
    }

    @Override
    protected SshPollValue exec(String command, Map<String, String> env) throws IOException {
        SshMachineLocation machine = (SshMachineLocation)this.getMachine();
        if (log.isTraceEnabled()) {
            log.trace("Ssh polling for {}, executing {} with env {}", new Object[]{machine, command, env});
        }
        ProcessTaskFactory tf = ((PlainSshExecTaskFactory)((AbstractProcessTaskFactory)((PlainSshExecTaskFactory)((PlainSshExecTaskFactory)new PlainSshExecTaskFactory(machine, command).environmentVariables((Map)env)).summary("ssh-feed")).returning(ProcessTaskStub.ScriptReturnType.STDOUT_STRING)).allowingNonZeroExitCode()).configure(SshTool.PROP_NO_EXTRA_OUTPUT, (Object)true);
        Boolean execAsCommand = (Boolean)this.config().get(EXEC_AS_COMMAND);
        if (Boolean.TRUE.equals(execAsCommand)) {
            tf.runAsCommand();
        } else {
            tf.runAsScript();
        }
        tf.configure(this.config().getBag().getAllConfig());
        ProcessTaskWrapper task = (ProcessTaskWrapper)tf.newTask();
        DynamicTasks.queueIfPossible(task).orSubmitAndBlock((Entity)this.entity).andWaitForSuccess();
        return new SshPollValue(machine, task.getExitCode(), task.getStdout(), task.getStderr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SshPollValue installAndExec(String commandUrl, Map<String, String> env) throws IOException {
        String commandUrlCopiedAs = (String)this.config().get(COMMAND_URL_COPIED_AS);
        if (commandUrlCopiedAs == null) {
            SshFeed sshFeed = this;
            synchronized (sshFeed) {
                commandUrlCopiedAs = (String)this.config().get(COMMAND_URL_COPIED_AS);
                if (commandUrlCopiedAs == null) {
                    String installDir = (String)this.getEntity().sensors().get(BrooklynConfigKeys.INSTALL_DIR);
                    if (installDir == null) {
                        commandUrlCopiedAs = "brooklyn-ssh-command-url-" + this.entity.getApplicationId() + "-" + this.entity.getId() + "-" + Identifiers.makeRandomId((int)4) + ".sh";
                        log.debug("Install dir not available at " + this.getEntity() + "; will use default/home directory for " + this + ", in " + commandUrlCopiedAs);
                    } else {
                        commandUrlCopiedAs = Os.mergePathsUnix((String[])new String[]{installDir, "command-url-" + Identifiers.makeRandomId((int)4) + ".sh"});
                    }
                    Maybe<SshMachineLocation> locationMaybe = Locations.findUniqueSshMachineLocation(this.entity.getLocations());
                    if (!locationMaybe.isPresent()) {
                        throw new IllegalStateException("Ssh machine location not available at " + this.getEntity() + "; skipping run of " + this);
                    }
                    TaskFactory<?> install = SshTasks.installFromUrl((SshMachineLocation)locationMaybe.get(), commandUrl, commandUrlCopiedAs);
                    DynamicTasks.queueIfPossible(install.newTask()).orSubmitAsync((Entity)this.entity).andWaitForSuccess();
                    log.debug("Installed from " + commandUrl + " to " + commandUrlCopiedAs + " at " + this.getEntity());
                    this.config().set(COMMAND_URL_COPIED_AS, commandUrlCopiedAs);
                }
            }
        }
        return this.exec("bash " + commandUrlCopiedAs, env);
    }

    @Override
    protected <T> void doReconfigureConfig(ConfigKey<T> key, T val) {
        if (key.getName().equals(COMMAND_URL.getName())) {
            this.config().set(COMMAND_URL_COPIED_AS, null);
            return;
        }
        if (key.getName().equals(COMMAND_URL_COPIED_AS.getName())) {
            return;
        }
        super.doReconfigureConfig(key, val);
    }

    public static class Builder
    extends AbstractCommandFeed.Builder<SshFeed, Builder> {
        private List<CommandPollConfig<?>> polls = Lists.newArrayList();

        @Override
        public Builder poll(CommandPollConfig<?> config) {
            this.polls.add(config);
            return this.self();
        }

        @Override
        public List<CommandPollConfig<?>> getPolls() {
            return this.polls;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        protected SshFeed instantiateFeed() {
            return new SshFeed(this);
        }
    }
}

