/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.byon;

import java.util.Map;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationRegistry;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.core.location.AbstractLocationResolver;
import org.apache.brooklyn.core.location.LocationConfigUtils;
import org.apache.brooklyn.core.location.LocationPropertiesFromBrooklynProperties;
import org.apache.brooklyn.core.location.internal.LocationInternal;
import org.apache.brooklyn.location.byon.SingleMachineProvisioningLocation;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;

public class SingleMachineLocationResolver
extends AbstractLocationResolver {
    private static final String SINGLE = "single";

    @Override
    public LocationSpec<?> newLocationSpecFromString(String spec, Map<?, ?> locationFlags, LocationRegistry registry) {
        ConfigBag config = this.extractConfig(locationFlags, spec, registry);
        Map globalProperties = registry.getProperties();
        String namedLocation = (String)locationFlags.get(LocationInternal.NAMED_SPEC_NAME.getName());
        if (registry != null) {
            LocationPropertiesFromBrooklynProperties.setLocalTempDir(globalProperties, config);
        }
        if (config.getStringKey("target") == null) {
            throw new IllegalArgumentException("target must be specified in single-machine spec");
        }
        String target = config.getStringKey("target").toString();
        config.remove("target");
        Maybe testResolve = this.managementContext.getLocationRegistry().getLocationSpec(target);
        if (!testResolve.isPresent()) {
            throw new IllegalArgumentException("Invalid target location '" + target + "' for location '" + SINGLE + "': " + Exceptions.collapseText((Throwable)Maybe.getException((Maybe)testResolve)), Maybe.getException((Maybe)testResolve));
        }
        return (LocationSpec)((LocationSpec)((LocationSpec)LocationSpec.create(SingleMachineProvisioningLocation.class).configure((CharSequence)"location", (Object)target)).configure((CharSequence)"locationFlags", config.getAllConfig())).configure(LocationConfigUtils.finalAndOriginalSpecs(spec, locationFlags, globalProperties, namedLocation));
    }

    public String getPrefix() {
        return SINGLE;
    }

    @Override
    protected Class<? extends Location> getLocationType() {
        return SingleMachineProvisioningLocation.class;
    }

    @Override
    protected AbstractLocationResolver.SpecParser getSpecParser() {
        return new AbstractLocationResolver.SpecParser(this.getPrefix()).setExampleUsage("\"single(target=jclouds:aws-ec2:us-east-1)\"");
    }
}

