/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.util.core.osgi.SystemFrameworkLoader;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface LoaderDispatcher<T> {
    public Maybe<T> tryLoadFrom(Bundle var1, String var2);

    public Maybe<T> tryLoadFrom(BrooklynClassLoadingContext var1, String var2);

    public Maybe<T> tryLoadFrom(ClassLoader var1, String var2);

    public static class MultipleResourceLoaderDispatcher
    implements LoaderDispatcher<Iterable<URL>> {
        public static final MultipleResourceLoaderDispatcher INSTANCE = new MultipleResourceLoaderDispatcher();

        @Override
        public Maybe<Iterable<URL>> tryLoadFrom(Bundle bundle, String name) {
            try {
                return this.emptyToMaybeNull(SystemFrameworkLoader.get().getResourcesFromBundle(name, bundle));
            }
            catch (IOException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }

        @Override
        public Maybe<Iterable<URL>> tryLoadFrom(BrooklynClassLoadingContext loader, String name) {
            return this.emptyToMaybeNull(loader.getResources(name));
        }

        @Override
        public Maybe<Iterable<URL>> tryLoadFrom(ClassLoader classLoader, String name) {
            try {
                return this.emptyToMaybeNull(classLoader.getResources(name));
            }
            catch (IOException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }

        private Maybe<Iterable<URL>> emptyToMaybeNull(Iterable<URL> iter) {
            if (iter.iterator().hasNext()) {
                return Maybe.of(iter);
            }
            return Maybe.absentNull();
        }

        private Maybe<Iterable<URL>> emptyToMaybeNull(Enumeration<URL> res) {
            if (res == null) {
                return Maybe.absentNull();
            }
            return this.emptyToMaybeNull(Collections.list(res));
        }
    }

    public static class ResourceLoaderDispatcher
    implements LoaderDispatcher<URL> {
        public static final ResourceLoaderDispatcher INSTANCE = new ResourceLoaderDispatcher();

        @Override
        public Maybe<URL> tryLoadFrom(Bundle bundle, String name) {
            return Maybe.ofDisallowingNull((Object)SystemFrameworkLoader.get().getResourceFromBundle(name, bundle));
        }

        @Override
        public Maybe<URL> tryLoadFrom(BrooklynClassLoadingContext loader, String name) {
            return Maybe.ofDisallowingNull((Object)loader.getResource(name));
        }

        @Override
        public Maybe<URL> tryLoadFrom(ClassLoader classLoader, String name) {
            return Maybe.ofDisallowingNull((Object)classLoader.getResource(name));
        }
    }

    public static class ClassLoaderDispatcher
    implements LoaderDispatcher<Class<?>> {
        private static final Logger log = LoggerFactory.getLogger(LoaderDispatcher.class);
        public static final ClassLoaderDispatcher INSTANCE = new ClassLoaderDispatcher();

        @Override
        public Maybe<Class<?>> tryLoadFrom(Bundle bundle, String className) {
            try {
                return Maybe.of((Object)SystemFrameworkLoader.get().loadClassFromBundle(className, bundle));
            }
            catch (ClassNotFoundException e) {
                return Maybe.absent((String)("Failed to load class " + className + " from bundle " + bundle), (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                return Maybe.absent((String)("Failed to load class " + className + " from bundle " + bundle), (Throwable)e);
            }
        }

        @Override
        public Maybe<Class<?>> tryLoadFrom(BrooklynClassLoadingContext loader, String className) {
            try {
                return loader.tryLoadClass(className);
            }
            catch (IllegalStateException e) {
                this.propagateIfCauseNotClassNotFound(e);
                return Maybe.absent((String)("Failed to load class " + className + " from loader " + loader), (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                return Maybe.absent((String)("Failed to load class " + className + " from loader " + loader), (Throwable)e);
            }
        }

        @Override
        public Maybe<Class<?>> tryLoadFrom(ClassLoader classLoader, String className) {
            try {
                return Maybe.of(classLoader.loadClass(className));
            }
            catch (IllegalStateException e) {
                this.propagateIfCauseNotClassNotFound(e);
                return Maybe.absent((String)("Failed to load class " + className + " from class loader " + classLoader), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                return Maybe.absent((String)("Failed to load class " + className + " from class loader " + classLoader), (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                return Maybe.absent((String)("Failed to load class " + className + " from class loader " + classLoader), (Throwable)e);
            }
        }

        private void propagateIfCauseNotClassNotFound(IllegalStateException e) {
            BundleException bundleException;
            ClassNotFoundException cnfe = (ClassNotFoundException)Exceptions.getFirstThrowableOfType((Throwable)e, ClassNotFoundException.class);
            NoClassDefFoundError ncdfe = (NoClassDefFoundError)Exceptions.getFirstThrowableOfType((Throwable)e, NoClassDefFoundError.class);
            if (cnfe == null && ncdfe == null) {
                throw e;
            }
            if (ncdfe != null) {
                log.debug("Class loading failure", (Throwable)ncdfe);
            } else if (cnfe != null && (bundleException = (BundleException)Exceptions.getFirstThrowableOfType((Throwable)cnfe, BundleException.class)) != null) {
                log.debug("Class loading failure", (Throwable)cnfe);
            }
        }
    }
}

