/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.EntityAdjunct;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.core.entity.EntityAdjuncts;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.util.guava.Maybe;

public class BidiSerialization {
    protected static final ThreadLocal<Boolean> STRICT_SERIALIZATION = new ThreadLocal();

    public static void setStrictSerialization(Boolean value) {
        STRICT_SERIALIZATION.set(value);
    }

    public static void clearStrictSerialization() {
        STRICT_SERIALIZATION.remove();
    }

    public static boolean isStrictSerialization() {
        Boolean result = STRICT_SERIALIZATION.get();
        if (result != null) {
            return result;
        }
        return false;
    }

    public static class ClassLoaderSerialization
    extends AbstractWithManagementContextSerialization<ClassLoader> {
        public ClassLoaderSerialization(ManagementContext mgmt) {
            super(ClassLoader.class, mgmt);
        }

        @Override
        public void customWriteBody(ClassLoader value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        }

        @Override
        protected ClassLoader customReadBody(String type, Map<Object, Object> values, JsonParser jp, DeserializationContext ctxt) throws IOException {
            return null;
        }
    }

    public static class TaskSerialization
    extends AbstractWithManagementContextSerialization<Task<?>> {
        public TaskSerialization(ManagementContext mgmt) {
            super(Task.class, mgmt);
        }

        @Override
        protected String customType(Task<?> value) throws IOException {
            return this.type.getCanonicalName();
        }

        @Override
        public void customWriteBody(Task<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStringField("id", value.getId());
            jgen.writeStringField("displayName", value.getDisplayName());
        }

        @Override
        protected Task<?> customReadBody(String type, Map<Object, Object> values, JsonParser jp, DeserializationContext ctxt) throws IOException {
            return this.mgmt.getExecutionManager().getTask((String)values.get("id"));
        }
    }

    public static class FeedSerialization
    extends AbstractBrooklynAdjunctSerialization<Feed> {
        public FeedSerialization(ManagementContext mgmt) {
            super(Feed.class, mgmt);
        }

        @Override
        protected Feed getInstanceFromId(Maybe<Entity> entity, String id) {
            if (id == null || !entity.isPresent()) {
                return null;
            }
            for (Feed feed : ((EntityInternal)entity).feeds().getFeeds()) {
                if (!id.equals(feed.getId())) continue;
                return feed;
            }
            return null;
        }
    }

    public static class EnricherSerialization
    extends AbstractBrooklynAdjunctSerialization<Enricher> {
        public EnricherSerialization(ManagementContext mgmt) {
            super(Enricher.class, mgmt);
        }

        @Override
        protected Enricher getInstanceFromId(Maybe<Entity> entity, String id) {
            if (id == null || !entity.isPresent()) {
                return null;
            }
            for (Enricher enricher : ((Entity)entity.get()).enrichers()) {
                if (!id.equals(enricher.getId())) continue;
                return enricher;
            }
            return null;
        }
    }

    public static class PolicySerialization
    extends AbstractBrooklynAdjunctSerialization<Policy> {
        public PolicySerialization(ManagementContext mgmt) {
            super(Policy.class, mgmt);
        }

        @Override
        protected Policy getInstanceFromId(Maybe<Entity> entity, String id) {
            if (id == null || !entity.isPresent()) {
                return null;
            }
            for (Policy policy : ((Entity)entity.get()).policies()) {
                if (!id.equals(policy.getId())) continue;
                return policy;
            }
            return null;
        }
    }

    public static class LocationSerialization
    extends AbstractBrooklynObjectSerialization<Location> {
        public LocationSerialization(ManagementContext mgmt) {
            super(Location.class, mgmt);
        }

        @Override
        protected Location getInstanceFromId(String id) {
            return this.mgmt.getLocationManager().getLocation(id);
        }
    }

    public static class EntitySerialization
    extends AbstractBrooklynObjectSerialization<Entity> {
        public EntitySerialization(ManagementContext mgmt) {
            super(Entity.class, mgmt);
        }

        @Override
        protected Entity getInstanceFromId(String id) {
            return this.mgmt.getEntityManager().getEntity(id);
        }
    }

    public static abstract class AbstractBrooklynAdjunctSerialization<T extends BrooklynObject & EntityAdjunct>
    extends AbstractWithManagementContextSerialization<T> {
        public AbstractBrooklynAdjunctSerialization(Class<T> type, ManagementContext mgmt) {
            super(type, mgmt);
        }

        @Override
        protected String customType(T value) throws IOException {
            return this.type.getCanonicalName();
        }

        @Override
        public void customWriteBody(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            Maybe<String> entityId = this.getEntityId(value);
            jgen.writeStringField("id", ((EntityAdjunct)value).getId());
            if (entityId.isPresent()) {
                jgen.writeStringField("entityId", (String)entityId.get());
            }
        }

        @Override
        protected T customReadBody(String type, Map<Object, Object> values, JsonParser jp, DeserializationContext ctxt) throws IOException {
            Maybe entityId = Maybe.ofDisallowingNull((Object)((String)values.get("entityId")));
            Maybe entity = Maybe.ofDisallowingNull(entityId.isPresent() ? null : this.mgmt.getEntityManager().getEntity((String)entityId.get()));
            String id = (String)values.get("id");
            return this.getInstanceFromId((Maybe<Entity>)entity, id);
        }

        protected Maybe<String> getEntityId(T value) {
            return EntityAdjuncts.getEntity(value, true).map(Entity::getId);
        }

        protected abstract T getInstanceFromId(Maybe<Entity> var1, String var2);
    }

    public static abstract class AbstractBrooklynObjectSerialization<T extends BrooklynObject>
    extends AbstractWithManagementContextSerialization<T> {
        public AbstractBrooklynObjectSerialization(Class<T> type, ManagementContext mgmt) {
            super(type, mgmt);
        }

        @Override
        protected String customType(T value) throws IOException {
            return this.type.getCanonicalName();
        }

        @Override
        public void customWriteBody(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStringField("id", value.getId());
        }

        @Override
        protected T customReadBody(String type, Map<Object, Object> values, JsonParser jp, DeserializationContext ctxt) throws IOException {
            return this.getInstanceFromId((String)values.get("id"));
        }

        protected abstract T getInstanceFromId(String var1);
    }

    public static class ManagementContextSerialization
    extends AbstractWithManagementContextSerialization<ManagementContext> {
        public ManagementContextSerialization(ManagementContext mgmt) {
            super(ManagementContext.class, mgmt);
        }

        @Override
        protected String customType(ManagementContext value) throws IOException {
            return this.type.getCanonicalName();
        }

        @Override
        public void customWriteBody(ManagementContext value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        }

        @Override
        protected ManagementContext customReadBody(String type, Map<Object, Object> values, JsonParser jp, DeserializationContext ctxt) throws IOException {
            return this.mgmt;
        }
    }

    public static abstract class AbstractWithManagementContextSerialization<T> {
        protected final Serializer serializer = new Serializer();
        protected final Deserializer deserializer = new Deserializer();
        protected final Class<T> type;
        protected final ManagementContext mgmt;

        public AbstractWithManagementContextSerialization(Class<T> type, ManagementContext mgmt) {
            this.type = type;
            this.mgmt = mgmt;
        }

        public JsonSerializer<T> getSerializer() {
            return this.serializer;
        }

        public JsonDeserializer<T> getDeserializer() {
            return this.deserializer;
        }

        public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            this.writeBody(value, jgen, provider);
            jgen.writeEndObject();
        }

        protected void writeBody(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStringField("type", this.customType(value));
            this.customWriteBody(value, jgen, provider);
        }

        protected String customType(T value) throws IOException {
            return value.getClass().getCanonicalName();
        }

        public abstract void customWriteBody(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException;

        public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            Map values = (Map)jp.readValueAs(Map.class);
            String type = (String)values.get("type");
            return this.customReadBody(type, values, jp, ctxt);
        }

        protected abstract T customReadBody(String var1, Map<Object, Object> var2, JsonParser var3, DeserializationContext var4) throws IOException;

        public void install(SimpleModule module) {
            module.addSerializer(this.type, (JsonSerializer)this.serializer);
            module.addDeserializer(this.type, (JsonDeserializer)this.deserializer);
        }

        protected class Deserializer
        extends JsonDeserializer<T> {
            protected Deserializer() {
            }

            public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                return AbstractWithManagementContextSerialization.this.deserialize(jp, ctxt);
            }
        }

        protected class Serializer
        extends JsonSerializer<T> {
            protected Serializer() {
            }

            public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                AbstractWithManagementContextSerialization.this.serialize(value, jgen, provider);
            }
        }
    }
}

