/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.task.ssh;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.api.objs.Configurable;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.config.StringConfigMap;
import org.apache.brooklyn.core.config.ConfigPredicates;
import org.apache.brooklyn.core.config.ConfigUtils;
import org.apache.brooklyn.core.location.AbstractLocation;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.file.BrooklynOsCommands;
import org.apache.brooklyn.util.core.internal.ssh.SshTool;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.ssh.SshFetchTaskFactory;
import org.apache.brooklyn.util.core.task.ssh.SshPutTaskFactory;
import org.apache.brooklyn.util.core.task.ssh.internal.PlainSshExecTaskFactory;
import org.apache.brooklyn.util.core.task.ssh.internal.RemoteExecTaskConfigHelper;
import org.apache.brooklyn.util.core.task.system.ProcessTaskFactory;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.ssh.BashCommandsConfigurable;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class SshTasks {
    private static final Logger log = LoggerFactory.getLogger(SshTasks.class);

    public static ProcessTaskFactory<Integer> newSshExecTaskFactory(SshMachineLocation machine, String ... commands) {
        return SshTasks.newSshExecTaskFactory(machine, Arrays.asList(commands));
    }

    public static ProcessTaskFactory<Integer> newSshExecTaskFactory(RemoteExecTaskConfigHelper.RemoteExecCapability config, String ... commands) {
        return SshTasks.newSshExecTaskFactory(config, Arrays.asList(commands));
    }

    public static ProcessTaskFactory<Integer> newSshExecTaskFactory(SshMachineLocation machine, boolean useMachineConfig, String ... commands) {
        return SshTasks.newSshExecTaskFactory(machine, useMachineConfig, Arrays.asList(commands));
    }

    public static ProcessTaskFactory<Integer> newSshExecTaskFactory(SshMachineLocation machine, List<String> commands) {
        return SshTasks.newSshExecTaskFactory(machine, true, commands);
    }

    public static ProcessTaskFactory<Integer> newSshExecTaskFactory(RemoteExecTaskConfigHelper.RemoteExecCapability config, List<String> commands) {
        return SshTasks.newSshExecTaskFactory(config, true, commands);
    }

    public static ProcessTaskFactory<Integer> newSshExecTaskFactory(SshMachineLocation machine, final boolean useMachineConfig, List<String> commands) {
        return new PlainSshExecTaskFactory<Integer>(machine, commands){
            {
                super(machine, (List<String>)commands);
                if (useMachineConfig) {
                    this.config.putIfAbsent(SshTasks.getSshFlags((Location)this.machine));
                }
            }
        };
    }

    public static ProcessTaskFactory<Integer> newSshExecTaskFactory(RemoteExecTaskConfigHelper.RemoteExecCapability remoteExecCapability, final boolean useMachineConfig, List<String> commands) {
        return new PlainSshExecTaskFactory<Integer>(remoteExecCapability, commands){
            {
                super(config, (List<String>)commands);
                if (useMachineConfig) {
                    this.config.putIfAbsent(SshTasks.getSshFlags(this.remoteExecCapability.getManagementContext(), this.remoteExecCapability.getExtraConfiguration()));
                }
            }
        };
    }

    public static SshPutTaskFactory newSshPutTaskFactory(SshMachineLocation machine, String remoteFile) {
        return SshTasks.newSshPutTaskFactory(machine, true, remoteFile);
    }

    public static SshPutTaskFactory newSshPutTaskFactory(SshMachineLocation machine, final boolean useMachineConfig, String remoteFile) {
        return new SshPutTaskFactory(machine, remoteFile){
            {
                super(machine, remoteFile);
                if (useMachineConfig) {
                    this.config.putIfAbsent(SshTasks.getSshFlags(this.machine));
                }
            }
        };
    }

    public static SshFetchTaskFactory newSshFetchTaskFactory(SshMachineLocation machine, String remoteFile) {
        return SshTasks.newSshFetchTaskFactory(machine, true, remoteFile);
    }

    public static SshFetchTaskFactory newSshFetchTaskFactory(SshMachineLocation machine, final boolean useMachineConfig, String remoteFile) {
        return new SshFetchTaskFactory(machine, remoteFile){
            {
                super(machine, remoteFile);
                if (useMachineConfig) {
                    this.config.putIfAbsent(SshTasks.getSshFlags(this.machine));
                }
            }
        };
    }

    private static Map<String, Object> getSshFlags(Location location) {
        return SshTasks.getSshFlags(location instanceof AbstractLocation ? ((AbstractLocation)location).getManagementContext() : null, location.config());
    }

    private static Map<String, Object> getSshFlags(ManagementContext mgmt, Configurable.ConfigurationSupport config) {
        MutableSet sshConfig = MutableSet.of();
        StringConfigMap mgmtConfig = null;
        sshConfig.addAll(config.findKeysPresent(ConfigPredicates.nameStartsWith("brooklyn.ssh.config.")));
        if (mgmt != null && mgmt != null) {
            mgmtConfig = mgmt.getConfig();
            sshConfig.addAll(mgmtConfig.findKeysPresent(ConfigPredicates.nameStartsWith("brooklyn.ssh.config.")));
        }
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (ConfigKey key : sshConfig) {
            Maybe v = config instanceof BrooklynObjectInternal.ConfigurationSupportInternal ? ((BrooklynObjectInternal.ConfigurationSupportInternal)config).getRaw(key) : Maybe.of(config.findKeysPresent(k -> key.equals(key)).stream().findFirst().map(k -> config.get(k)));
            if (v.isAbsent() && mgmtConfig != null) {
                v = Maybe.of((Object)mgmtConfig.getConfig(key));
            }
            if (v.isAbsent()) continue;
            result.put(ConfigUtils.unprefixedKey("brooklyn.ssh.config.", key).getName(), v.get());
        }
        return result;
    }

    public static ProcessTaskFactory<Boolean> dontRequireTtyForSudo(SshMachineLocation machine, boolean failIfCantSudo) {
        return SshTasks.dontRequireTtyForSudo(machine, failIfCantSudo ? OnFailingTask.FAIL : OnFailingTask.WARN_IN_LOG_ONLY);
    }

    public static ProcessTaskFactory<Boolean> dontRequireTtyForSudo(SshMachineLocation machine, OnFailingTask onFailingTaskRequested) {
        final OnFailingTask onFailingTask = onFailingTaskRequested == OnFailingTask.WARN_OR_IF_DYNAMIC_FAIL_MARKING_INESSENTIAL ? (DynamicTasks.getTaskQueuingContext() != null ? onFailingTaskRequested : OnFailingTask.WARN_IN_LOG_ONLY) : onFailingTaskRequested;
        final String id = Identifiers.makeRandomId((int)6);
        return SshTasks.newSshExecTaskFactory(machine, "(commands to modify sudo config to allow tty)").commandModifier(x -> {
            Entity entity = BrooklynTaskTags.getTargetOrContextEntity(Tasks.current());
            BashCommandsConfigurable bash = entity != null ? BrooklynOsCommands.bash(machine) : BrooklynOsCommands.bash(machine);
            return MutableList.of((Object)bash.dontRequireTtyForSudo(), (Object)bash.sudo("echo \"sudo\"-is-working-" + id));
        }).summary("patch /etc/sudoers to disable requiretty").configure(SshTool.PROP_ALLOCATE_PTY, true).allowingNonZeroExitCode().returning(new Function<ProcessTaskWrapper<?>, Boolean>(){

            @Override
            public Boolean apply(ProcessTaskWrapper<?> task) {
                if (task.getExitCode() == 0 && task.getStdout().contains("sudo-is-working-" + id)) {
                    return true;
                }
                Entity entity = BrooklynTaskTags.getTargetOrContextEntity(Tasks.current());
                if (onFailingTask != OnFailingTask.IGNORE) {
                    String message = "Error setting up sudo for " + task.getRemoteExecCapability().getConnectionSummary() + "  (exit code " + task.getExitCode() + (entity != null ? ", entity " + entity : "") + ")";
                    DynamicTasks.queueIfPossible(Tasks.warning(message, null));
                }
                Streams.logStreamTail((Logger)log, (String)"STDERR of sudo setup problem", (ByteArrayOutputStream)Streams.byteArrayOfString((String)task.getStderr()), (int)1024);
                if (onFailingTask == OnFailingTask.WARN_OR_IF_DYNAMIC_FAIL_MARKING_INESSENTIAL) {
                    Tasks.markInessential();
                }
                if (onFailingTask == OnFailingTask.FAIL || onFailingTask == OnFailingTask.WARN_OR_IF_DYNAMIC_FAIL_MARKING_INESSENTIAL) {
                    throw new IllegalStateException("Passwordless sudo is required for " + task.getRemoteExecCapability().getConnectionSummary() + (entity != null ? " (" + entity + ")" : ""));
                }
                return false;
            }
        });
    }

    public static Function<ProcessTaskWrapper<?>, String> returningStdoutLoggingInfo(final Logger logger, final boolean requireZero) {
        return new Function<ProcessTaskWrapper<?>, String>(){

            @Override
            public String apply(@Nullable ProcessTaskWrapper<?> input) {
                if (logger != null) {
                    logger.info(input + " COMMANDS:\n" + Strings.join(input.getCommands(true), (String)"\n"));
                }
                if (logger != null) {
                    logger.info(input + " STDOUT:\n" + input.getStdout());
                }
                if (logger != null) {
                    logger.info(input + " STDERR:\n" + input.getStderr());
                }
                if (requireZero && input.getExitCode() != 0) {
                    throw new IllegalStateException("non-zero exit code in " + input.getSummary() + ": see log for more details!");
                }
                return input.getStdout();
            }
        };
    }

    public static TaskFactory<?> installFromUrl(SshMachineLocation location, String url, String destPath) {
        return SshTasks.installFromUrl(ResourceUtils.create(SshTasks.class), ImmutableMap.of(), location, url, destPath);
    }

    public static TaskFactory<?> installFromUrl(Map<String, ?> props, SshMachineLocation location, String url, String destPath) {
        return SshTasks.installFromUrl(ResourceUtils.create(SshTasks.class), props, location, url, destPath);
    }

    public static TaskFactory<?> installFromUrl(final ResourceUtils utils, final Map<String, ?> props, final SshMachineLocation location, final String url, final String destPath) {
        return new TaskFactory<TaskAdaptable<?>>(){

            public TaskAdaptable<?> newTask() {
                return Tasks.builder().displayName("installing " + Urls.getBasename((String)url)).description("installing " + url + " to " + destPath).body(new Runnable(){

                    @Override
                    public void run() {
                        int result = location.installTo(utils, props, url, destPath);
                        if (result != 0) {
                            throw new IllegalStateException("Failed to install '" + url + "' to '" + destPath + "' at " + location + ": exit code " + result);
                        }
                    }
                }).build();
            }
        };
    }

    @Beta
    public static enum OnFailingTask {
        FAIL,
        WARN_OR_IF_DYNAMIC_FAIL_MARKING_INESSENTIAL,
        WARN_IN_LOG_ONLY,
        IGNORE;

    }
}

