/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.xstream;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.extended.JavaClassConverter;
import com.thoughtworks.xstream.core.DefaultConverterLookup;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.path.PathTracker;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import com.thoughtworks.xstream.mapper.DefaultMapper;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.xstream.ClassRenamingMapper;
import org.apache.brooklyn.util.core.xstream.CompilerIndependentOuterClassFieldMapper;
import org.apache.brooklyn.util.core.xstream.EnumCaseForgivingConverter;
import org.apache.brooklyn.util.core.xstream.HashMultimapConverter;
import org.apache.brooklyn.util.core.xstream.ImmutableListConverter;
import org.apache.brooklyn.util.core.xstream.ImmutableMapConverter;
import org.apache.brooklyn.util.core.xstream.ImmutableSetConverter;
import org.apache.brooklyn.util.core.xstream.Inet4AddressConverter;
import org.apache.brooklyn.util.core.xstream.MinidevJsonObjectConverter;
import org.apache.brooklyn.util.core.xstream.MutableListConverter;
import org.apache.brooklyn.util.core.xstream.MutableSetConverter;
import org.apache.brooklyn.util.core.xstream.OsgiClassnameMapper;
import org.apache.brooklyn.util.core.xstream.StringKeyMapConverter;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlSerializer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(XmlSerializer.class);
    private final Map<String, String> deserializingClassRenames;
    protected final XStream xstream;
    protected final XppDriver hierarchicalStreamDriver;
    protected final DefaultConverterLookup converterLookup;
    private static Set<String> LOGGED_ALIASES = MutableSet.of();

    public XmlSerializer() {
        this(null);
    }

    public XmlSerializer(Map<String, String> deserializingClassRenames) {
        this(null, deserializingClassRenames);
    }

    public XmlSerializer(ClassLoader loader, Map<String, String> deserializingClassRenames) {
        this(loader, deserializingClassRenames, null);
    }

    public XmlSerializer(ClassLoader loader, Map<String, String> deserializingClassRenames, final Function<MapperWrapper, MapperWrapper> mapperCustomizer) {
        this.deserializingClassRenames = deserializingClassRenames == null ? ImmutableMap.of() : deserializingClassRenames;
        this.hierarchicalStreamDriver = new XppDriver(){

            public HierarchicalStreamWriter createWriter(Writer out) {
                return new PrettyPrintWriterExposingStack(out, this.getNameCoder());
            }
        };
        this.converterLookup = new DefaultConverterLookup();
        XStream xs1 = new XStream();
        this.xstream = new XStream(null, (HierarchicalStreamDriver)this.hierarchicalStreamDriver, xs1.getClassLoaderReference(), null, type -> this.converterLookup.lookupConverterForType(type), (converter, priority) -> this.converterLookup.registerConverter(converter, priority)){

            protected MapperWrapper wrapMapper(MapperWrapper next) {
                MapperWrapper result = XmlSerializer.this.wrapMapperForNormalUsage((Mapper)super.wrapMapper(next));
                if (mapperCustomizer != null) {
                    result = (MapperWrapper)mapperCustomizer.apply(result);
                }
                return result;
            }
        };
        XmlSerializer.allowAllTypes(this.xstream);
        if (loader != null) {
            this.xstream.setClassLoader(loader);
        }
        this.xstream.registerConverter((SingleValueConverter)this.newCustomJavaClassConverter(), 0);
        XmlSerializer.addStandardHelpers(this.xstream);
    }

    @VisibleForTesting
    public static void addStandardHelpers(XStream xstream) {
        xstream.alias("map", Map.class, LinkedHashMap.class);
        xstream.alias("set", Set.class, LinkedHashSet.class);
        xstream.registerConverter((Converter)new StringKeyMapConverter(xstream.getMapper()), 10);
        xstream.alias("MutableMap", MutableMap.class);
        xstream.alias("MutableSet", MutableSet.class);
        xstream.alias("MutableList", MutableList.class);
        xstream.registerConverter((Converter)new MutableSetConverter(xstream.getMapper()));
        xstream.registerConverter((Converter)new MutableListConverter(xstream.getMapper(), xstream.getReflectionProvider(), xstream.getClassLoaderReference()));
        xstream.aliasType("ImmutableList", ImmutableList.class);
        xstream.registerConverter((Converter)new ImmutableListConverter(xstream.getMapper()));
        xstream.registerConverter((Converter)new ImmutableSetConverter(xstream.getMapper()));
        xstream.registerConverter((Converter)new ImmutableMapConverter(xstream.getMapper()));
        xstream.registerConverter((Converter)new MinidevJsonObjectConverter(xstream.getMapper()));
        xstream.registerConverter((Converter)new HashMultimapConverter(xstream.getMapper()));
        xstream.registerConverter((Converter)new EnumCaseForgivingConverter());
        xstream.registerConverter((Converter)new Inet4AddressConverter());
        XmlSerializer.addStandardInnerClassHelpers(xstream);
        xstream.autodetectAnnotations(true);
    }

    @VisibleForTesting
    public static void addStandardInnerClassHelpers(XStream xstream) {
        Maybe valueTransformer = Reflections.getFieldValueMaybe((Object)Maps.transformValues((Map)MutableMap.of(), x -> x), (String)"transformer");
        XmlSerializer.addAliasForInnerClass(xstream, "com.google.common.collect.Maps$7", valueTransformer);
        XmlSerializer.addAliasForInnerClass(xstream, "com.google.guava:com.google.common.collect.Maps$7", valueTransformer);
        XmlSerializer.addAliasForInnerClass(xstream, "com.google.common.collect.Maps._inners.valueTransformer", valueTransformer);
        Maybe iterableTransformer = Maybe.of((Object)Iterables.transform((Iterable)MutableSet.of(), x -> x));
        XmlSerializer.addAliasForInnerClass(xstream, "com.google.common.collect.Iterables._inners.transform", iterableTransformer);
    }

    private static <T> void addAliasForInnerClass(XStream xstream, String alias, Maybe<T> object) {
        if (object.isAbsent()) {
            if (LOGGED_ALIASES.add(alias)) {
                LOG.warn("No object found to register serialization alias for " + alias + "; ignoring");
            }
        } else {
            xstream.alias(alias, object.get().getClass());
            if (LOGGED_ALIASES.add(alias)) {
                LOG.debug("XStream alias for " + object.get().getClass() + ": " + alias + " (" + object + ")");
            }
        }
    }

    public static void allowAllTypes(XStream xstream) {
        xstream.allowTypesByWildcard(new String[]{"**"});
    }

    private JavaClassConverter newCustomJavaClassConverter() {
        return new JavaClassConverter((Mapper)this.wrapMapperForHandlingClasses((Mapper)new DefaultMapper(this.xstream.getClassLoaderReference()))){};
    }

    protected MapperWrapper wrapMapperForHandlingClasses(Mapper next) {
        MapperWrapper result = new CompilerIndependentOuterClassFieldMapper(next);
        Supplier<ClassLoader> classLoaderSupplier = new Supplier<ClassLoader>(){

            public ClassLoader get() {
                return XmlSerializer.this.xstream.getClassLoaderReference().getReference();
            }
        };
        result = new ClassRenamingMapper((Mapper)result, this.deserializingClassRenames, (Supplier<? extends ClassLoader>)classLoaderSupplier);
        result = new OsgiClassnameMapper(new Supplier<XStream>(){

            public XStream get() {
                return XmlSerializer.this.xstream;
            }
        }, result);
        return result;
    }

    protected MapperWrapper wrapMapperForNormalUsage(Mapper next) {
        return this.wrapMapperForHandlingClasses(next);
    }

    public void serialize(Object obj, Writer out) {
        HierarchicalStreamWriter writer = this.hierarchicalStreamDriver.createWriter(out);
        try {
            this.xstream.marshal(obj, writer);
        }
        catch (Throwable e) {
            Exceptions.propagateIfInterrupt((Throwable)e);
            if (writer instanceof PrettyPrintWriterExposingStack) {
                String path = ("" + ((PrettyPrintWriterExposingStack)writer).path.getPath()).trim();
                if (!e.toString().contains(path)) {
                    throw new XStreamException(Exceptions.collapseText((Throwable)e) + "; while converting element at " + path, e);
                }
            }
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            writer.flush();
        }
    }

    public T deserialize(Reader xml) {
        return (T)this.xstream.fromXML(xml);
    }

    public String toString(T memento) {
        StringWriter writer = new StringWriter();
        this.serialize(memento, writer);
        return ((Object)writer).toString();
    }

    public T fromString(String xml) {
        return this.deserialize(new StringReader(xml));
    }

    static class PrettyPrintWriterExposingStack
    extends PrettyPrintWriter {
        private final Writer origWriter;
        public PathTracker path = new PathTracker();

        public PrettyPrintWriterExposingStack(Writer writer, NameCoder nameCoder) {
            super(writer, nameCoder);
            this.origWriter = writer;
        }

        public void startNode(String name) {
            this.path.pushElement(name);
            super.startNode(name);
        }

        public void endNode() {
            super.endNode();
            this.path.popElement();
        }

        public Writer getOrigWriter() {
            return this.origWriter;
        }
    }
}

