/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.packet.features;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.inject.TypeLiteral;
import java.beans.ConstructorProperties;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.Json;
import org.jclouds.packet.PacketApi;
import org.jclouds.packet.domain.Href;
import org.jclouds.packet.domain.SshKey;
import org.jclouds.packet.domain.internal.PaginatedCollection;
import org.jclouds.packet.domain.options.ListOptions;
import org.jclouds.packet.filters.AddApiVersionToRequest;
import org.jclouds.packet.filters.AddXAuthTokenToRequest;
import org.jclouds.packet.functions.BaseToPagedIterable;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@Path(value="/ssh-keys")
@Consumes(value={"application/json"})
@RequestFilters(value={AddXAuthTokenToRequest.class, AddApiVersionToRequest.class})
public interface SshKeyApi {
    @Named(value="sshkey:list")
    @GET
    @ResponseParser(value=ParseSshKeys.class)
    @Transform(value=ParseSshKeys.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<SshKey> list();

    @Named(value="sshkey:list")
    @GET
    @ResponseParser(value=ParseSshKeys.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public IterableWithMarker<SshKey> list(ListOptions var1);

    @Named(value="sshkey:create")
    @POST
    @Produces(value={"application/json"})
    @MapBinder(value=BindToJsonPayload.class)
    public SshKey create(@PayloadParam(value="label") String var1, @PayloadParam(value="key") String var2);

    @Named(value="sshkey:get")
    @GET
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public SshKey get(@PathParam(value="id") String var1);

    @Named(value="sshkey:delete")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void delete(@PathParam(value="id") String var1);

    public static final class ParseSshKeys
    extends ParseJson<SshKeys> {
        @Inject
        ParseSshKeys(Json json) {
            super(json, TypeLiteral.get(SshKeys.class));
        }

        private static class ToPagedIterable
        extends BaseToPagedIterable<SshKey, ListOptions> {
            @Inject
            ToPagedIterable(PacketApi api, Function<Href, ListOptions> hrefToOptions) {
                super(api, hrefToOptions);
            }

            @Override
            protected IterableWithMarker<SshKey> fetchPageUsingOptions(ListOptions options, Optional<Object> arg0) {
                return this.api.sshKeyApi().list(options);
            }
        }

        private static class SshKeys
        extends PaginatedCollection<SshKey> {
            @ConstructorProperties(value={"ssh_keys", "meta"})
            public SshKeys(List<SshKey> items, PaginatedCollection.Meta meta) {
                super(items, meta);
            }
        }
    }
}

