/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudstack.domain.IPForwardingRule;
import org.jclouds.cloudstack.domain.NIC;
import org.jclouds.cloudstack.domain.Tag;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Location;
import org.jclouds.location.predicates.LocationPredicates;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.InetAddresses2;
import org.jclouds.util.Throwables2;

@Singleton
public class VirtualMachineToNodeMetadata
implements Function<VirtualMachine, NodeMetadata> {
    public static final Map<VirtualMachine.State, NodeMetadata.Status> vmStateToNodeStatus = ImmutableMap.builder().put((Object)VirtualMachine.State.STARTING, (Object)NodeMetadata.Status.PENDING).put((Object)VirtualMachine.State.RUNNING, (Object)NodeMetadata.Status.RUNNING).put((Object)VirtualMachine.State.STOPPING, (Object)NodeMetadata.Status.PENDING).put((Object)VirtualMachine.State.STOPPED, (Object)NodeMetadata.Status.SUSPENDED).put((Object)VirtualMachine.State.DESTROYED, (Object)NodeMetadata.Status.TERMINATED).put((Object)VirtualMachine.State.EXPUNGING, (Object)NodeMetadata.Status.TERMINATED).put((Object)VirtualMachine.State.MIGRATING, (Object)NodeMetadata.Status.PENDING).put((Object)VirtualMachine.State.ERROR, (Object)NodeMetadata.Status.ERROR).put((Object)VirtualMachine.State.UNKNOWN, (Object)NodeMetadata.Status.UNRECOGNIZED).put((Object)VirtualMachine.State.SHUTDOWNED, (Object)NodeMetadata.Status.PENDING).put((Object)VirtualMachine.State.UNRECOGNIZED, (Object)NodeMetadata.Status.UNRECOGNIZED).build();
    private final Supplier<Set<? extends Location>> locations;
    private final Supplier<Set<? extends Image>> images;
    private final LoadingCache<String, Set<IPForwardingRule>> getIPForwardingRulesByVirtualMachine;
    private final GroupNamingConvention nodeNamingConvention;

    @Inject
    VirtualMachineToNodeMetadata(@Memoized Supplier<Set<? extends Location>> locations, @Memoized Supplier<Set<? extends Image>> images, LoadingCache<String, Set<IPForwardingRule>> getIPForwardingRulesByVirtualMachine, GroupNamingConvention.Factory namingConvention) {
        this.nodeNamingConvention = ((GroupNamingConvention.Factory)Preconditions.checkNotNull((Object)namingConvention, (Object)"namingConvention")).createWithoutPrefix();
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
        this.images = (Supplier)Preconditions.checkNotNull(images, (Object)"images");
        this.getIPForwardingRulesByVirtualMachine = (LoadingCache)Preconditions.checkNotNull(getIPForwardingRulesByVirtualMachine, (Object)"getIPForwardingRulesByVirtualMachine");
    }

    public NodeMetadata apply(final VirtualMachine from) {
        HashSet privateAddresses;
        HashSet publicAddresses;
        NodeMetadataBuilder builder;
        block14: {
            builder = new NodeMetadataBuilder();
            builder.ids(from.getId() + "");
            builder.name(from.getName());
            builder.hostname(from.getDisplayName());
            builder.location((Location)FluentIterable.from((Iterable)((Iterable)this.locations.get())).firstMatch(LocationPredicates.idEquals((String)from.getZoneId())).orNull());
            if (from.getGroup() != null) {
                builder.group(from.getGroup());
            } else if (from.getDisplayName() != null) {
                builder.group(this.nodeNamingConvention.groupInUniqueNameOrNull(from.getDisplayName()));
            }
            Image image = (Image)FluentIterable.from((Iterable)((Iterable)this.images.get())).firstMatch((Predicate)new Predicate<Image>(){

                public boolean apply(Image input) {
                    return input.getProviderId().equals(from.getTemplateId() + "") && (input.getLocation() == null || input.getId().equals(from.getZoneId() + ""));
                }
            }).orNull();
            if (image != null) {
                builder.imageId(image.getId());
                builder.operatingSystem(image.getOperatingSystem());
            }
            if (!from.getTags().isEmpty()) {
                ImmutableMap.Builder tagsBuilder = ImmutableMap.builder();
                for (Tag tag : from.getTags()) {
                    tagsBuilder.put((Object)tag.getKey(), (Object)tag.getValue());
                }
                ImmutableMap tagMap = tagsBuilder.build();
                builder.tags(Maps.filterValues((Map)tagMap, (Predicate)Predicates.equalTo((Object)"jclouds-empty-tag-placeholder")).keySet()).userMetadata(Maps.filterValues((Map)tagMap, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)"jclouds-empty-tag-placeholder"))));
            }
            builder.hardware(new HardwareBuilder().ids(from.getServiceOfferingId() + "").name(from.getServiceOfferingName() + "").processors((Iterable)ImmutableList.of((Object)new Processor((double)from.getCpuCount(), (double)from.getCpuSpeed()))).ram((int)from.getMemory()).hypervisor(from.getHypervisor()).build());
            builder.status(vmStateToNodeStatus.get((Object)from.getState()));
            publicAddresses = Sets.newHashSet();
            privateAddresses = Sets.newHashSet();
            if (from.getIPAddress() != null) {
                boolean isPrivate = InetAddresses2.isPrivateIPAddress((String)from.getIPAddress());
                if (isPrivate) {
                    privateAddresses.add(from.getIPAddress());
                } else {
                    publicAddresses.add(from.getIPAddress());
                }
            }
            if (from.getPublicIP() != null) {
                publicAddresses.add(from.getPublicIP());
            }
            for (NIC nic : from.getNICs()) {
                if (nic.getIPAddress() == null) continue;
                if (InetAddresses2.isPrivateIPAddress((String)nic.getIPAddress())) {
                    privateAddresses.add(nic.getIPAddress());
                    continue;
                }
                publicAddresses.add(nic.getIPAddress());
            }
            try {
                Iterables.addAll((Collection)publicAddresses, (Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)((Iterable)this.getIPForwardingRulesByVirtualMachine.getUnchecked((Object)from.getId())), (Predicate)new Predicate<IPForwardingRule>(){

                    public boolean apply(IPForwardingRule rule) {
                        return !"Deleting".equals(rule.getState());
                    }
                }), (Function)new Function<IPForwardingRule, String>(){

                    public String apply(IPForwardingRule rule) {
                        return rule.getIPAddress();
                    }
                }));
            }
            catch (UncheckedExecutionException e) {
                if (Throwables2.getFirstThrowableOfType((Throwable)e, ResourceNotFoundException.class) != null) break block14;
                Throwables.propagateIfPossible((Throwable)e.getCause());
                throw e;
            }
        }
        return builder.privateAddresses((Iterable)privateAddresses).publicAddresses((Iterable)publicAddresses).build();
    }
}

