/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.options.AssignVirtualMachineOptions;
import org.jclouds.cloudstack.options.DeployVirtualMachineOptions;
import org.jclouds.cloudstack.options.ListVirtualMachinesOptions;
import org.jclouds.cloudstack.options.StopVirtualMachineOptions;
import org.jclouds.cloudstack.options.UpdateVirtualMachineOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface VirtualMachineApi {
    @Named(value="listVirtualMachines")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listVirtualMachines", "true"})
    @SelectJson(value={"virtualmachine"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<VirtualMachine> listVirtualMachines(ListVirtualMachinesOptions ... var1);

    @Named(value="listVirtualMachines")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listVirtualMachines", "true"})
    @SelectJson(value={"virtualmachine"})
    @OnlyElement
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public VirtualMachine getVirtualMachine(@QueryParam(value="id") String var1);

    @Named(value="deployVirtualMachine")
    @GET
    @QueryParams(keys={"command"}, values={"deployVirtualMachine"})
    @SelectJson(value={"deployvirtualmachine", "deployvirtualmachineresponse"})
    @Consumes(value={"application/json"})
    public AsyncCreateResponse deployVirtualMachineInZone(@QueryParam(value="zoneid") String var1, @QueryParam(value="serviceofferingid") String var2, @QueryParam(value="templateid") String var3, DeployVirtualMachineOptions ... var4);

    @Named(value="rebootVirtualMachine")
    @GET
    @QueryParams(keys={"command"}, values={"rebootVirtualMachine"})
    @SelectJson(value={"jobid"})
    @Consumes(value={"application/json"})
    public String rebootVirtualMachine(@QueryParam(value="id") String var1);

    @Named(value="startVirtualMachine")
    @GET
    @QueryParams(keys={"command"}, values={"startVirtualMachine"})
    @SelectJson(value={"jobid"})
    @Consumes(value={"application/json"})
    public String startVirtualMachine(@QueryParam(value="id") String var1);

    @Named(value="stopVirtualMachine")
    @GET
    @QueryParams(keys={"command"}, values={"stopVirtualMachine"})
    @SelectJson(value={"jobid"})
    @Consumes(value={"application/json"})
    public String stopVirtualMachine(@QueryParam(value="id") String var1);

    @GET
    @QueryParams(keys={"command"}, values={"stopVirtualMachine"})
    @SelectJson(value={"jobid"})
    @Consumes(value={"application/json"})
    public String stopVirtualMachine(@QueryParam(value="id") String var1, StopVirtualMachineOptions var2);

    @Named(value="resetPasswordForVirtualMachine")
    @GET
    @QueryParams(keys={"command"}, values={"resetPasswordForVirtualMachine"})
    @SelectJson(value={"jobid"})
    @Consumes(value={"application/json"})
    public String resetPasswordForVirtualMachine(@QueryParam(value="id") String var1);

    @Named(value="getVMPassword")
    @GET
    @QueryParams(keys={"command"}, values={"getVMPassword"})
    @SelectJson(value={"encryptedpassword"})
    @Consumes(value={"application/json"})
    public String getEncryptedPasswordForVirtualMachine(@QueryParam(value="id") String var1);

    @Named(value="changeServiceForVirtualMachine")
    @GET
    @QueryParams(keys={"command"}, values={"changeServiceForVirtualMachine"})
    @SelectJson(value={"jobid"})
    @Consumes(value={"application/json"})
    public String changeServiceForVirtualMachine(@QueryParam(value="id") String var1, @QueryParam(value="serviceofferingid") String var2);

    @Named(value="updateVirtualMachine")
    @GET
    @QueryParams(keys={"command"}, values={"updateVirtualMachine"})
    @SelectJson(value={"jobid"})
    @Consumes(value={"application/json"})
    public String updateVirtualMachine(@QueryParam(value="id") String var1, UpdateVirtualMachineOptions var2);

    @Named(value="destroyVirtualMachine")
    @GET
    @QueryParams(keys={"command"}, values={"destroyVirtualMachine"})
    @SelectJson(value={"jobid"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public String destroyVirtualMachine(@QueryParam(value="id") String var1);

    @Named(value="assignVirtualMachine")
    @GET
    @QueryParams(keys={"command"}, values={"assignVirtualMachine"})
    @SelectJson(value={"jobid"})
    @Consumes(value={"application/json"})
    public VirtualMachine assignVirtualMachine(@QueryParam(value="virtualmachineid") String var1, AssignVirtualMachineOptions ... var2);
}

