/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import org.jclouds.cloudstack.domain.PublicIPAddress;

public class PublicIPAddressPredicates {
    public static Predicate<PublicIPAddress> available() {
        return Available.INSTANCE;
    }

    public static Predicate<PublicIPAddress> associatedWithNetwork(String networkId) {
        return new AssociatedWithNetwork(networkId);
    }

    public static Predicate<PublicIPAddress> any() {
        return Predicates.alwaysTrue();
    }

    public static enum Available implements Predicate<PublicIPAddress>
    {
        INSTANCE;


        public boolean apply(PublicIPAddress arg0) {
            return !((PublicIPAddress)Preconditions.checkNotNull((Object)arg0, (Object)"ipaddress")).isSourceNAT() && !arg0.isStaticNAT() && arg0.getVirtualMachineId() == null && arg0.getState() == PublicIPAddress.State.ALLOCATED;
        }

        public String toString() {
            return "available()";
        }
    }

    public static final class AssociatedWithNetwork
    implements Predicate<PublicIPAddress> {
        private final String networkId;

        public AssociatedWithNetwork(String networkId) {
            this.networkId = (String)Preconditions.checkNotNull((Object)networkId, (Object)"networkId");
        }

        public boolean apply(PublicIPAddress input) {
            return this.networkId.equals(((PublicIPAddress)Preconditions.checkNotNull((Object)input, (Object)"ipaddress")).getAssociatedNetworkId());
        }

        public String toString() {
            return "associatedWithNetwork(" + this.networkId + ")";
        }
    }
}

