/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import java.util.Map;
import org.jclouds.azurecompute.arm.domain.Disk;
import org.jclouds.azurecompute.arm.domain.DiskProperties;
import org.jclouds.azurecompute.arm.domain.SKU;
import org.jclouds.javax.annotation.Nullable;

final class AutoValue_Disk
extends Disk {
    private final String id;
    private final String name;
    private final String location;
    private final String type;
    private final SKU sku;
    private final DiskProperties properties;
    private final Map<String, String> tags;

    private AutoValue_Disk(@Nullable String id, @Nullable String name, String location, @Nullable String type, @Nullable SKU sku, DiskProperties properties, @Nullable Map<String, String> tags) {
        this.id = id;
        this.name = name;
        this.location = location;
        this.type = type;
        this.sku = sku;
        this.properties = properties;
        this.tags = tags;
    }

    @Override
    @Nullable
    public String id() {
        return this.id;
    }

    @Override
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    public String location() {
        return this.location;
    }

    @Override
    @Nullable
    public String type() {
        return this.type;
    }

    @Override
    @Nullable
    public SKU sku() {
        return this.sku;
    }

    @Override
    public DiskProperties properties() {
        return this.properties;
    }

    @Override
    @Nullable
    public Map<String, String> tags() {
        return this.tags;
    }

    public String toString() {
        return "Disk{id=" + this.id + ", name=" + this.name + ", location=" + this.location + ", type=" + this.type + ", sku=" + this.sku + ", properties=" + this.properties + ", tags=" + this.tags + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Disk) {
            Disk that = (Disk)o;
            return (this.id == null ? that.id() == null : this.id.equals(that.id())) && (this.name == null ? that.name() == null : this.name.equals(that.name())) && this.location.equals(that.location()) && (this.type == null ? that.type() == null : this.type.equals(that.type())) && (this.sku == null ? that.sku() == null : this.sku.equals(that.sku())) && this.properties.equals(that.properties()) && (this.tags == null ? that.tags() == null : this.tags.equals(that.tags()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.id == null ? 0 : this.id.hashCode();
        h *= 1000003;
        h ^= this.name == null ? 0 : this.name.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.type == null ? 0 : this.type.hashCode();
        h *= 1000003;
        h ^= this.sku == null ? 0 : this.sku.hashCode();
        h *= 1000003;
        h ^= this.properties.hashCode();
        h *= 1000003;
        return h ^= this.tags == null ? 0 : this.tags.hashCode();
    }

    @Override
    public Disk.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends Disk.Builder {
        private String id;
        private String name;
        private String location;
        private String type;
        private SKU sku;
        private DiskProperties properties;
        private Map<String, String> tags;

        Builder() {
        }

        private Builder(Disk source) {
            this.id = source.id();
            this.name = source.name();
            this.location = source.location();
            this.type = source.type();
            this.sku = source.sku();
            this.properties = source.properties();
            this.tags = source.tags();
        }

        @Override
        public Disk.Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @Override
        public Disk.Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @Override
        public Disk.Builder location(String location) {
            if (location == null) {
                throw new NullPointerException("Null location");
            }
            this.location = location;
            return this;
        }

        @Override
        public Disk.Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        @Override
        public Disk.Builder sku(@Nullable SKU sku) {
            this.sku = sku;
            return this;
        }

        @Override
        public Disk.Builder properties(DiskProperties properties) {
            if (properties == null) {
                throw new NullPointerException("Null properties");
            }
            this.properties = properties;
            return this;
        }

        @Override
        public Disk.Builder tags(@Nullable Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        @Override
        @Nullable
        Map<String, String> tags() {
            return this.tags;
        }

        @Override
        Disk autoBuild() {
            String missing = "";
            if (this.location == null) {
                missing = missing + " location";
            }
            if (this.properties == null) {
                missing = missing + " properties";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Disk(this.id, this.name, this.location, this.type, this.sku, this.properties, this.tags);
        }
    }
}

