/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.jclouds.azurecompute.arm.domain.AutoValue_DeploymentTemplate;
import org.jclouds.azurecompute.arm.domain.AutoValue_DeploymentTemplate_Parameters;
import org.jclouds.azurecompute.arm.domain.AutoValue_DeploymentTemplate_TemplateParameters;
import org.jclouds.azurecompute.arm.domain.KeyVaultReference;
import org.jclouds.azurecompute.arm.domain.ResourceDefinition;
import org.jclouds.azurecompute.arm.domain.TemplateParameterType;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class DeploymentTemplate {
    public abstract String schema();

    public abstract String contentVersion();

    public abstract TemplateParameters parameters();

    public abstract Map<String, String> variables();

    public abstract List<ResourceDefinition> resources();

    @Nullable
    public abstract List<?> outputs();

    @SerializedNames(value={"$schema", "contentVersion", "parameters", "variables", "resources", "outputs"})
    public static DeploymentTemplate create(String schema, String contentVersion, TemplateParameters parameters, Map<String, String> variables, List<ResourceDefinition> resources, List<?> outputs) {
        Builder builder = DeploymentTemplate.builder().schema(schema).contentVersion(contentVersion).parameters(parameters);
        if (variables != null) {
            builder.variables(variables);
        }
        if (resources != null) {
            builder.resources(resources);
        }
        builder.outputs((List<?>)(outputs == null ? null : ImmutableList.copyOf(outputs)));
        return builder.build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_DeploymentTemplate.Builder();
    }

    public static abstract class Builder {
        public abstract Builder schema(String var1);

        public abstract Builder contentVersion(String var1);

        public abstract Builder parameters(TemplateParameters var1);

        public abstract Builder variables(Map<String, String> var1);

        public abstract Builder resources(List<ResourceDefinition> var1);

        public abstract Builder outputs(List<?> var1);

        abstract Map<String, String> variables();

        abstract List<ResourceDefinition> resources();

        abstract DeploymentTemplate autoBuild();

        public DeploymentTemplate build() {
            this.variables((Map<String, String>)(this.variables() != null ? ImmutableMap.copyOf(this.variables()) : null));
            this.resources((List<ResourceDefinition>)(this.resources() != null ? ImmutableList.copyOf(this.resources()) : null));
            return this.autoBuild();
        }
    }

    public static abstract class TemplateParameters {
        @Nullable
        public abstract TemplateParameterType publicKeyFromAzureKeyVault();

        public static TemplateParameters create(TemplateParameterType publicKeyFromAzureKeyVault) {
            return new AutoValue_DeploymentTemplate_TemplateParameters(publicKeyFromAzureKeyVault);
        }
    }

    public static abstract class Parameters {
        @Nullable
        public abstract KeyVaultReference publicKeyFromAzureKeyVault();

        public static Parameters create(KeyVaultReference reference) {
            return new AutoValue_DeploymentTemplate_Parameters(reference);
        }
    }
}

