/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.StatusCause;
import io.fabric8.kubernetes.api.model.StatusCauseBuilder;
import io.fabric8.kubernetes.api.model.StatusCauseFluent;
import io.fabric8.kubernetes.api.model.StatusDetails;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class StatusDetailsFluent<A extends StatusDetailsFluent<A>>
extends BaseFluent<A> {
    private ArrayList<StatusCauseBuilder> causes = new ArrayList();
    private String group;
    private String kind;
    private String name;
    private Integer retryAfterSeconds;
    private String uid;
    private Map<String, Object> additionalProperties;

    public StatusDetailsFluent() {
    }

    public StatusDetailsFluent(StatusDetails instance) {
        StatusDetails statusDetails = instance = instance != null ? instance : new StatusDetails();
        if (instance != null) {
            this.withCauses(instance.getCauses());
            this.withGroup(instance.getGroup());
            this.withKind(instance.getKind());
            this.withName(instance.getName());
            this.withRetryAfterSeconds(instance.getRetryAfterSeconds());
            this.withUid(instance.getUid());
            this.withCauses(instance.getCauses());
            this.withGroup(instance.getGroup());
            this.withKind(instance.getKind());
            this.withName(instance.getName());
            this.withRetryAfterSeconds(instance.getRetryAfterSeconds());
            this.withUid(instance.getUid());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToCauses(int index, StatusCause item) {
        if (this.causes == null) {
            this.causes = new ArrayList();
        }
        StatusCauseBuilder builder = new StatusCauseBuilder(item);
        if (index < 0 || index >= this.causes.size()) {
            this._visitables.get("causes").add(builder);
            this.causes.add(builder);
        } else {
            this._visitables.get("causes").add(index, builder);
            this.causes.add(index, builder);
        }
        return (A)this;
    }

    public A setToCauses(int index, StatusCause item) {
        if (this.causes == null) {
            this.causes = new ArrayList();
        }
        StatusCauseBuilder builder = new StatusCauseBuilder(item);
        if (index < 0 || index >= this.causes.size()) {
            this._visitables.get("causes").add(builder);
            this.causes.add(builder);
        } else {
            this._visitables.get("causes").set(index, builder);
            this.causes.set(index, builder);
        }
        return (A)this;
    }

    public A addToCauses(StatusCause ... items) {
        if (this.causes == null) {
            this.causes = new ArrayList();
        }
        for (StatusCause item : items) {
            StatusCauseBuilder builder = new StatusCauseBuilder(item);
            this._visitables.get("causes").add(builder);
            this.causes.add(builder);
        }
        return (A)this;
    }

    public A addAllToCauses(Collection<StatusCause> items) {
        if (this.causes == null) {
            this.causes = new ArrayList();
        }
        for (StatusCause item : items) {
            StatusCauseBuilder builder = new StatusCauseBuilder(item);
            this._visitables.get("causes").add(builder);
            this.causes.add(builder);
        }
        return (A)this;
    }

    public A removeFromCauses(StatusCause ... items) {
        if (this.causes == null) {
            return (A)this;
        }
        for (StatusCause item : items) {
            StatusCauseBuilder builder = new StatusCauseBuilder(item);
            this._visitables.get("causes").remove(builder);
            this.causes.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromCauses(Collection<StatusCause> items) {
        if (this.causes == null) {
            return (A)this;
        }
        for (StatusCause item : items) {
            StatusCauseBuilder builder = new StatusCauseBuilder(item);
            this._visitables.get("causes").remove(builder);
            this.causes.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromCauses(Predicate<StatusCauseBuilder> predicate) {
        if (this.causes == null) {
            return (A)this;
        }
        Iterator<StatusCauseBuilder> each = this.causes.iterator();
        Object visitables = this._visitables.get("causes");
        while (each.hasNext()) {
            StatusCauseBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<StatusCause> buildCauses() {
        return this.causes != null ? StatusDetailsFluent.build(this.causes) : null;
    }

    public StatusCause buildCause(int index) {
        return this.causes.get(index).build();
    }

    public StatusCause buildFirstCause() {
        return this.causes.get(0).build();
    }

    public StatusCause buildLastCause() {
        return this.causes.get(this.causes.size() - 1).build();
    }

    public StatusCause buildMatchingCause(Predicate<StatusCauseBuilder> predicate) {
        for (StatusCauseBuilder item : this.causes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCause(Predicate<StatusCauseBuilder> predicate) {
        for (StatusCauseBuilder item : this.causes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCauses(List<StatusCause> causes) {
        if (this.causes != null) {
            this._visitables.get("causes").clear();
        }
        if (causes != null) {
            this.causes = new ArrayList();
            for (StatusCause item : causes) {
                this.addToCauses(item);
            }
        } else {
            this.causes = null;
        }
        return (A)this;
    }

    public A withCauses(StatusCause ... causes) {
        if (this.causes != null) {
            this.causes.clear();
            this._visitables.remove("causes");
        }
        if (causes != null) {
            for (StatusCause item : causes) {
                this.addToCauses(item);
            }
        }
        return (A)this;
    }

    public boolean hasCauses() {
        return this.causes != null && !this.causes.isEmpty();
    }

    public A addNewCause(String field, String message, String reason) {
        return this.addToCauses(new StatusCause(field, message, reason));
    }

    public CausesNested<A> addNewCause() {
        return new CausesNested(-1, null);
    }

    public CausesNested<A> addNewCauseLike(StatusCause item) {
        return new CausesNested(-1, item);
    }

    public CausesNested<A> setNewCauseLike(int index, StatusCause item) {
        return new CausesNested(index, item);
    }

    public CausesNested<A> editCause(int index) {
        if (this.causes.size() <= index) {
            throw new RuntimeException("Can't edit causes. Index exceeds size.");
        }
        return this.setNewCauseLike(index, this.buildCause(index));
    }

    public CausesNested<A> editFirstCause() {
        if (this.causes.size() == 0) {
            throw new RuntimeException("Can't edit first causes. The list is empty.");
        }
        return this.setNewCauseLike(0, this.buildCause(0));
    }

    public CausesNested<A> editLastCause() {
        int index = this.causes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last causes. The list is empty.");
        }
        return this.setNewCauseLike(index, this.buildCause(index));
    }

    public CausesNested<A> editMatchingCause(Predicate<StatusCauseBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.causes.size(); ++i) {
            if (!predicate.test(this.causes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching causes. No match found.");
        }
        return this.setNewCauseLike(index, this.buildCause(index));
    }

    public String getGroup() {
        return this.group;
    }

    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    public boolean hasGroup() {
        return this.group != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public Integer getRetryAfterSeconds() {
        return this.retryAfterSeconds;
    }

    public A withRetryAfterSeconds(Integer retryAfterSeconds) {
        this.retryAfterSeconds = retryAfterSeconds;
        return (A)this;
    }

    public boolean hasRetryAfterSeconds() {
        return this.retryAfterSeconds != null;
    }

    public String getUid() {
        return this.uid;
    }

    public A withUid(String uid) {
        this.uid = uid;
        return (A)this;
    }

    public boolean hasUid() {
        return this.uid != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatusDetailsFluent that = (StatusDetailsFluent)o;
        if (!Objects.equals(this.causes, that.causes)) {
            return false;
        }
        if (!Objects.equals(this.group, that.group)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.retryAfterSeconds, that.retryAfterSeconds)) {
            return false;
        }
        if (!Objects.equals(this.uid, that.uid)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.causes, this.group, this.kind, this.name, this.retryAfterSeconds, this.uid, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.causes != null && !this.causes.isEmpty()) {
            sb.append("causes:");
            sb.append(this.causes + ",");
        }
        if (this.group != null) {
            sb.append("group:");
            sb.append(this.group + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.retryAfterSeconds != null) {
            sb.append("retryAfterSeconds:");
            sb.append(this.retryAfterSeconds + ",");
        }
        if (this.uid != null) {
            sb.append("uid:");
            sb.append(this.uid + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class CausesNested<N>
    extends StatusCauseFluent<CausesNested<N>>
    implements Nested<N> {
        StatusCauseBuilder builder;
        int index;

        CausesNested(int index, StatusCause item) {
            this.index = index;
            this.builder = new StatusCauseBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)StatusDetailsFluent.this.setToCauses(this.index, this.builder.build());
        }

        public N endCause() {
            return this.and();
        }
    }
}

