/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class OAuthAccessTokenFluent<A extends OAuthAccessTokenFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String authorizeToken;
    private String clientName;
    private Long expiresIn;
    private Integer inactivityTimeoutSeconds;
    private String kind;
    private ObjectMetaBuilder metadata;
    private String redirectURI;
    private String refreshToken;
    private List<String> scopes = new ArrayList<String>();
    private String userName;
    private String userUID;
    private Map<String, Object> additionalProperties;

    public OAuthAccessTokenFluent() {
    }

    public OAuthAccessTokenFluent(OAuthAccessToken instance) {
        OAuthAccessToken oAuthAccessToken = instance = instance != null ? instance : new OAuthAccessToken();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withAuthorizeToken(instance.getAuthorizeToken());
            this.withClientName(instance.getClientName());
            this.withExpiresIn(instance.getExpiresIn());
            this.withInactivityTimeoutSeconds(instance.getInactivityTimeoutSeconds());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withRedirectURI(instance.getRedirectURI());
            this.withRefreshToken(instance.getRefreshToken());
            this.withScopes(instance.getScopes());
            this.withUserName(instance.getUserName());
            this.withUserUID(instance.getUserUID());
            this.withApiVersion(instance.getApiVersion());
            this.withAuthorizeToken(instance.getAuthorizeToken());
            this.withClientName(instance.getClientName());
            this.withExpiresIn(instance.getExpiresIn());
            this.withInactivityTimeoutSeconds(instance.getInactivityTimeoutSeconds());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withRedirectURI(instance.getRedirectURI());
            this.withRefreshToken(instance.getRefreshToken());
            this.withScopes(instance.getScopes());
            this.withUserName(instance.getUserName());
            this.withUserUID(instance.getUserUID());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getAuthorizeToken() {
        return this.authorizeToken;
    }

    public A withAuthorizeToken(String authorizeToken) {
        this.authorizeToken = authorizeToken;
        return (A)((Object)this);
    }

    public boolean hasAuthorizeToken() {
        return this.authorizeToken != null;
    }

    public String getClientName() {
        return this.clientName;
    }

    public A withClientName(String clientName) {
        this.clientName = clientName;
        return (A)((Object)this);
    }

    public boolean hasClientName() {
        return this.clientName != null;
    }

    public Long getExpiresIn() {
        return this.expiresIn;
    }

    public A withExpiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
        return (A)((Object)this);
    }

    public boolean hasExpiresIn() {
        return this.expiresIn != null;
    }

    public Integer getInactivityTimeoutSeconds() {
        return this.inactivityTimeoutSeconds;
    }

    public A withInactivityTimeoutSeconds(Integer inactivityTimeoutSeconds) {
        this.inactivityTimeoutSeconds = inactivityTimeoutSeconds;
        return (A)((Object)this);
    }

    public boolean hasInactivityTimeoutSeconds() {
        return this.inactivityTimeoutSeconds != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)((Object)this);
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public String getRedirectURI() {
        return this.redirectURI;
    }

    public A withRedirectURI(String redirectURI) {
        this.redirectURI = redirectURI;
        return (A)((Object)this);
    }

    public boolean hasRedirectURI() {
        return this.redirectURI != null;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public A withRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return (A)((Object)this);
    }

    public boolean hasRefreshToken() {
        return this.refreshToken != null;
    }

    public A addToScopes(int index, String item) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(index, item);
        return (A)((Object)this);
    }

    public A setToScopes(int index, String item) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.set(index, item);
        return (A)((Object)this);
    }

    public A addToScopes(String ... items) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        for (String item : items) {
            this.scopes.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToScopes(Collection<String> items) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        for (String item : items) {
            this.scopes.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromScopes(String ... items) {
        if (this.scopes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.scopes.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromScopes(Collection<String> items) {
        if (this.scopes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.scopes.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public String getScope(int index) {
        return this.scopes.get(index);
    }

    public String getFirstScope() {
        return this.scopes.get(0);
    }

    public String getLastScope() {
        return this.scopes.get(this.scopes.size() - 1);
    }

    public String getMatchingScope(Predicate<String> predicate) {
        for (String item : this.scopes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingScope(Predicate<String> predicate) {
        for (String item : this.scopes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withScopes(List<String> scopes) {
        if (scopes != null) {
            this.scopes = new ArrayList<String>();
            for (String item : scopes) {
                this.addToScopes(item);
            }
        } else {
            this.scopes = null;
        }
        return (A)((Object)this);
    }

    public A withScopes(String ... scopes) {
        if (this.scopes != null) {
            this.scopes.clear();
            this._visitables.remove((Object)"scopes");
        }
        if (scopes != null) {
            for (String item : scopes) {
                this.addToScopes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasScopes() {
        return this.scopes != null && !this.scopes.isEmpty();
    }

    public String getUserName() {
        return this.userName;
    }

    public A withUserName(String userName) {
        this.userName = userName;
        return (A)((Object)this);
    }

    public boolean hasUserName() {
        return this.userName != null;
    }

    public String getUserUID() {
        return this.userUID;
    }

    public A withUserUID(String userUID) {
        this.userUID = userUID;
        return (A)((Object)this);
    }

    public boolean hasUserUID() {
        return this.userUID != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuthAccessTokenFluent that = (OAuthAccessTokenFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.authorizeToken, that.authorizeToken)) {
            return false;
        }
        if (!Objects.equals(this.clientName, that.clientName)) {
            return false;
        }
        if (!Objects.equals(this.expiresIn, that.expiresIn)) {
            return false;
        }
        if (!Objects.equals(this.inactivityTimeoutSeconds, that.inactivityTimeoutSeconds)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.redirectURI, that.redirectURI)) {
            return false;
        }
        if (!Objects.equals(this.refreshToken, that.refreshToken)) {
            return false;
        }
        if (!Objects.equals(this.scopes, that.scopes)) {
            return false;
        }
        if (!Objects.equals(this.userName, that.userName)) {
            return false;
        }
        if (!Objects.equals(this.userUID, that.userUID)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.authorizeToken, this.clientName, this.expiresIn, this.inactivityTimeoutSeconds, this.kind, this.metadata, this.redirectURI, this.refreshToken, this.scopes, this.userName, this.userUID, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.authorizeToken != null) {
            sb.append("authorizeToken:");
            sb.append(this.authorizeToken + ",");
        }
        if (this.clientName != null) {
            sb.append("clientName:");
            sb.append(this.clientName + ",");
        }
        if (this.expiresIn != null) {
            sb.append("expiresIn:");
            sb.append(this.expiresIn + ",");
        }
        if (this.inactivityTimeoutSeconds != null) {
            sb.append("inactivityTimeoutSeconds:");
            sb.append(this.inactivityTimeoutSeconds + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.redirectURI != null) {
            sb.append("redirectURI:");
            sb.append(this.redirectURI + ",");
        }
        if (this.refreshToken != null) {
            sb.append("refreshToken:");
            sb.append(this.refreshToken + ",");
        }
        if (this.scopes != null && !this.scopes.isEmpty()) {
            sb.append("scopes:");
            sb.append(this.scopes + ",");
        }
        if (this.userName != null) {
            sb.append("userName:");
            sb.append(this.userName + ",");
        }
        if (this.userUID != null) {
            sb.append("userUID:");
            sb.append(this.userUID + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        public N and() {
            return (N)OAuthAccessTokenFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

