/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Credentials;
import org.jclouds.gogrid.functions.ParseServerNameToCredentialsMapFromJsonResponse;
import org.jclouds.http.HttpResponse;

@Singleton
public class ParseCredentialsFromJsonResponse
implements Function<HttpResponse, Credentials> {
    private final ParseServerNameToCredentialsMapFromJsonResponse parser;

    @Inject
    ParseCredentialsFromJsonResponse(ParseServerNameToCredentialsMapFromJsonResponse parser) {
        this.parser = parser;
    }

    public Credentials apply(HttpResponse input) {
        Map<String, Credentials> returnVal = this.parser.apply(input);
        Preconditions.checkState((returnVal.size() <= 1 ? 1 : 0) != 0, (Object)("expecting only 1 credential in response, but had more: " + returnVal.keySet()));
        return !returnVal.isEmpty() ? (Credentials)Iterables.getOnlyElement(returnVal.values()) : null;
    }
}

