/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.okhttp;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Named;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.http.HttpMethod;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.IOExceptionRetryHandler;
import org.jclouds.http.handlers.DelegatingErrorHandler;
import org.jclouds.http.handlers.DelegatingRetryHandler;
import org.jclouds.http.internal.BaseHttpCommandExecutorService;
import org.jclouds.http.internal.HttpWire;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.InputStreamPayload;
import org.jclouds.logging.Logger;

public final class OkHttpCommandExecutorService
extends BaseHttpCommandExecutorService<Request> {
    private final Function<URI, Proxy> proxyForURI;
    private final OkHttpClient globalClient;
    private final String userAgent;

    @Inject
    OkHttpCommandExecutorService(HttpUtils utils, ContentMetadataCodec contentMetadataCodec, DelegatingRetryHandler retryHandler, IOExceptionRetryHandler ioRetryHandler, DelegatingErrorHandler errorHandler, HttpWire wire, Function<URI, Proxy> proxyForURI, OkHttpClient okHttpClient, @Named(value="jclouds.idempotent-methods") String idempotentMethods, @Named(value="jclouds.user-agent") String userAgent) {
        super(utils, contentMetadataCodec, retryHandler, ioRetryHandler, errorHandler, wire, idempotentMethods);
        this.proxyForURI = proxyForURI;
        this.globalClient = okHttpClient;
        this.userAgent = userAgent;
    }

    protected Request convert(HttpRequest request) throws IOException, InterruptedException {
        Long length;
        Request.Builder builder = new Request.Builder();
        builder.url(request.getEndpoint().toString());
        this.populateHeaders(request, builder);
        RequestBody body = null;
        Payload payload = request.getPayload();
        if (payload != null && (length = (Long)Preconditions.checkNotNull((Object)payload.getContentMetadata().getContentLength(), (Object)"payload.getContentLength")) > 0L) {
            body = this.generateRequestBody(request, payload);
        }
        if (body == null && HttpMethod.requiresRequestBody((String)request.getMethod())) {
            body = this.generateEmptyRequestBody(payload);
        }
        builder.method(request.getMethod(), body);
        return builder.build();
    }

    protected void populateHeaders(HttpRequest request, Request.Builder builder) {
        if (request.getFirstHeaderOrNull("Accept") == null) {
            builder.addHeader("Accept", "*/*");
        }
        if (request.getFirstHeaderOrNull("User-Agent") == null) {
            builder.addHeader("User-Agent", this.userAgent);
        }
        for (Map.Entry entry : request.getHeaders().entries()) {
            builder.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        if (request.getPayload() != null) {
            MutableContentMetadata md = request.getPayload().getContentMetadata();
            for (Map.Entry entry : this.contentMetadataCodec.toHeaders((ContentMetadata)md).entries()) {
                builder.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private RequestBody generateEmptyRequestBody(final Payload payload) {
        return new RequestBody(){

            @Nullable
            public MediaType contentType() {
                return payload != null ? MediaType.parse((String)payload.getContentMetadata().getContentType()) : null;
            }

            public void writeTo(BufferedSink sink) throws IOException {
            }

            public long contentLength() throws IOException {
                return 0L;
            }
        };
    }

    protected RequestBody generateRequestBody(final HttpRequest request, final Payload payload) {
        Preconditions.checkNotNull((Object)payload.getContentMetadata().getContentType(), (Object)"payload.getContentType");
        return new RequestBody(){

            public void writeTo(BufferedSink sink) throws IOException {
                try (Source source = Okio.source((InputStream)payload.openStream());){
                    sink.writeAll(source);
                }
            }

            public long contentLength() throws IOException {
                return payload.getContentMetadata().getContentLength();
            }

            public MediaType contentType() {
                return MediaType.parse((String)payload.getContentMetadata().getContentType());
            }
        };
    }

    protected HttpResponse invoke(Request nativeRequest) throws IOException, InterruptedException {
        OkHttpClient requestScopedClient = this.globalClient.newBuilder().proxy((Proxy)this.proxyForURI.apply((Object)nativeRequest.url().uri())).build();
        Response response = requestScopedClient.newCall(nativeRequest).execute();
        HttpResponse.Builder builder = HttpResponse.builder();
        builder.statusCode(response.code());
        builder.message(response.message());
        ImmutableMultimap.Builder headerBuilder = ImmutableMultimap.builder();
        Headers responseHeaders = response.headers();
        for (String header : responseHeaders.names()) {
            headerBuilder.putAll((Object)header, (Iterable)responseHeaders.values(header));
        }
        ImmutableMultimap headers = headerBuilder.build();
        if (response.code() == 204 && response.body() != null) {
            response.body().close();
        } else {
            InputStreamPayload payload = Payloads.newInputStreamPayload((InputStream)response.body().byteStream());
            this.contentMetadataCodec.fromHeaders(payload.getContentMetadata(), (Multimap)headers);
            builder.payload((Payload)payload);
        }
        builder.headers(HttpUtils.filterOutContentHeaders((Multimap)headers));
        return builder.build();
    }

    protected void cleanup(Request nativeResponse) {
    }

    static /* synthetic */ Logger access$000(OkHttpCommandExecutorService x0) {
        return x0.logger;
    }
}

