/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class NetworkVlan {
    private final int id;
    private final int accountId;
    private final String name;
    private final int networkVrfId;
    private final int primarySubnetId;
    private final int vlanNumber;
    private final String note;

    @ConstructorProperties(value={"id", "accountId", "name", "networkVrfId", "primarySubnetId", "vlanNumber", "note"})
    public NetworkVlan(int id, int accountId, @Nullable String name, int networkVrfId, int primarySubnetId, int vlanNumber, @Nullable String note) {
        this.id = id;
        this.accountId = accountId;
        this.name = name;
        this.networkVrfId = networkVrfId;
        this.primarySubnetId = primarySubnetId;
        this.vlanNumber = vlanNumber;
        this.note = note;
    }

    public int getId() {
        return this.id;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public String getName() {
        return this.name;
    }

    public int getNetworkVrfId() {
        return this.networkVrfId;
    }

    public int getPrimarySubnetId() {
        return this.primarySubnetId;
    }

    public int getVlanNumber() {
        return this.vlanNumber;
    }

    public String getNote() {
        return this.note;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkVlan that = (NetworkVlan)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.accountId, (Object)that.accountId) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.networkVrfId, (Object)that.networkVrfId) && Objects.equal((Object)this.primarySubnetId, (Object)that.primarySubnetId) && Objects.equal((Object)this.vlanNumber, (Object)that.vlanNumber) && Objects.equal((Object)this.note, (Object)that.note);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.accountId, this.name, this.networkVrfId, this.primarySubnetId, this.vlanNumber, this.note});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("accountId", this.accountId).add("name", (Object)this.name).add("networkVrfId", this.networkVrfId).add("primarySubnetId", this.primarySubnetId).add("vlanNumber", this.vlanNumber).add("note", (Object)this.note).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return NetworkVlan.builder().fromNetworkVlan(this);
    }

    public static class Builder {
        protected int id;
        protected int accountId;
        protected String name;
        protected int networkVrfId;
        protected int primarySubnetId;
        protected int vlanNumber;
        protected String note;

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder accountId(int accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder networkVrfId(int networkVrfId) {
            this.networkVrfId = networkVrfId;
            return this;
        }

        public Builder primarySubnetId(int primarySubnetId) {
            this.primarySubnetId = primarySubnetId;
            return this;
        }

        public Builder vlanNumber(int vlanNumber) {
            this.vlanNumber = vlanNumber;
            return this;
        }

        public Builder note(String note) {
            this.note = note;
            return this;
        }

        public NetworkVlan build() {
            return new NetworkVlan(this.id, this.accountId, this.name, this.networkVrfId, this.primarySubnetId, this.vlanNumber, this.note);
        }

        public Builder fromNetworkVlan(NetworkVlan in) {
            return this.id(in.getId()).accountId(in.getAccountId()).name(in.getName()).networkVrfId(in.getNetworkVrfId()).primarySubnetId(in.getPrimarySubnetId()).vlanNumber(in.getVlanNumber()).note(in.getNote());
        }
    }
}

