/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.softlayer.domain.VirtualDiskImageSoftware;

public class VirtualDiskImage {
    private final int id;
    private final String uuid;
    private final float capacity;
    private final String units;
    private final int typeId;
    private final String description;
    private final String name;
    private final int storageRepositoryId;
    private final Set<VirtualDiskImageSoftware> softwareReferences;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return VirtualDiskImage.builder().fromVirtualDiskImage(this);
    }

    @ConstructorProperties(value={"id", "uuid", "capacity", "units", "typeId", "description", "name", "storageRepositoryId", "softwareReferences"})
    public VirtualDiskImage(int id, @Nullable String uuid, float capacity, @Nullable String units, int typeId, @Nullable String description, @Nullable String name, int storageRepositoryId, @Nullable Set<VirtualDiskImageSoftware> softwareReferences) {
        this.id = id;
        this.uuid = uuid;
        this.capacity = capacity;
        this.units = units;
        this.typeId = typeId;
        this.description = description;
        this.name = name;
        this.storageRepositoryId = storageRepositoryId;
        this.softwareReferences = softwareReferences == null ? ImmutableSet.of() : ImmutableSet.copyOf(softwareReferences);
    }

    public int getId() {
        return this.id;
    }

    public String getUuid() {
        return this.uuid;
    }

    public float getCapacity() {
        return this.capacity;
    }

    public String getUnits() {
        return this.units;
    }

    public int getBuilderypeId() {
        return this.typeId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public int getStorageRepositoryId() {
        return this.storageRepositoryId;
    }

    public Set<VirtualDiskImageSoftware> getSoftwareReferences() {
        return this.softwareReferences;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualDiskImage that = (VirtualDiskImage)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.uuid, (Object)that.uuid) && Objects.equal((Object)Float.valueOf(this.capacity), (Object)Float.valueOf(that.capacity)) && Objects.equal((Object)this.units, (Object)that.units) && Objects.equal((Object)this.typeId, (Object)that.typeId) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.storageRepositoryId, (Object)that.storageRepositoryId) && Objects.equal(this.softwareReferences, that.softwareReferences);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.uuid, Float.valueOf(this.capacity), this.units, this.typeId, this.description, this.name, this.storageRepositoryId, this.softwareReferences});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("uuid", (Object)this.uuid).add("capacity", this.capacity).add("units", (Object)this.units).add("typeId", this.typeId).add("description", (Object)this.description).add("name", (Object)this.name).add("storageRepositoryId", this.storageRepositoryId).add("softwareReferences", this.softwareReferences).toString();
    }

    public static class Builder {
        protected int id;
        protected String uuid;
        protected float capacity;
        protected String units;
        protected int typeId;
        protected String description;
        protected String name;
        protected int storageRepositoryId;
        protected ImmutableSet.Builder<VirtualDiskImageSoftware> softwareReferences = ImmutableSet.builder();

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder capacity(float capacity) {
            this.capacity = capacity;
            return this;
        }

        public Builder units(String units) {
            this.units = units;
            return this;
        }

        public Builder typeId(int typeId) {
            this.typeId = typeId;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder storageRepositoryId(int storageRepositoryId) {
            this.storageRepositoryId = storageRepositoryId;
            return this;
        }

        public Builder softwareReferences(Set<VirtualDiskImageSoftware> softwareReferences) {
            this.softwareReferences.addAll((Iterable)Preconditions.checkNotNull(softwareReferences, (Object)"softwareReferences"));
            return this;
        }

        public Builder softwareReferences(VirtualDiskImageSoftware ... in) {
            return this.softwareReferences((Set<VirtualDiskImageSoftware>)ImmutableSet.copyOf((Object[])in));
        }

        public VirtualDiskImage build() {
            return new VirtualDiskImage(this.id, this.uuid, this.capacity, this.units, this.typeId, this.description, this.name, this.storageRepositoryId, (Set<VirtualDiskImageSoftware>)this.softwareReferences.build());
        }

        public Builder fromVirtualDiskImage(VirtualDiskImage in) {
            return this.id(in.getId()).uuid(in.getUuid()).capacity(in.getCapacity()).units(in.getUnits()).typeId(in.getBuilderypeId()).description(in.getDescription()).name(in.getName()).storageRepositoryId(in.getStorageRepositoryId()).softwareReferences(in.getSoftwareReferences());
        }
    }
}

