/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging;

import java.io.IOException;

public class ImagingException
extends IOException {
    private static final long serialVersionUID = -1L;

    static String getType(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Object[]) {
            return "[Object[]: " + ((Object[])value).length + "]";
        }
        if (value instanceof char[]) {
            return "[char[]: " + ((char[])value).length + "]";
        }
        if (value instanceof byte[]) {
            return "[byte[]: " + ((byte[])value).length + "]";
        }
        if (value instanceof short[]) {
            return "[short[]: " + ((short[])value).length + "]";
        }
        if (value instanceof int[]) {
            return "[int[]: " + ((int[])value).length + "]";
        }
        if (value instanceof long[]) {
            return "[long[]: " + ((long[])value).length + "]";
        }
        if (value instanceof float[]) {
            return "[float[]: " + ((float[])value).length + "]";
        }
        if (value instanceof double[]) {
            return "[double[]: " + ((double[])value).length + "]";
        }
        if (value instanceof boolean[]) {
            return "[boolean[]: " + ((boolean[])value).length + "]";
        }
        return value.getClass().getName();
    }

    public ImagingException(String message) {
        super(message);
    }

    public ImagingException(String message, Object data) {
        super(message + ": " + data + " (" + ImagingException.getType(data) + ")");
    }

    public ImagingException(String message, Throwable cause) {
        super(message, cause);
    }

    public ImagingException(Throwable cause) {
        super(cause);
    }
}

