/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.cpc;

import java.util.Arrays;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.cpc.RuntimeAsserts;

final class PairTable {
    private static final int upsizeNumer = 3;
    private static final int upsizeDenom = 4;
    private static final int downsizeNumer = 1;
    private static final int downsizeDenom = 4;
    private int lgSizeInts;
    private final int validBits;
    private int numPairs;
    private int[] slotsArr;

    PairTable(int lgSizeInts, int numValidBits) {
        PairTable.checkLgSizeInts(lgSizeInts);
        this.lgSizeInts = lgSizeInts;
        int numSlots = 1 << lgSizeInts;
        this.validBits = numValidBits;
        this.numPairs = 0;
        this.slotsArr = new int[numSlots];
        for (int i = 0; i < numSlots; ++i) {
            this.slotsArr[i] = -1;
        }
    }

    static PairTable newInstanceFromPairsArray(int[] pairs, int numPairs, int lgK) {
        int lgNumSlots = 2;
        while (4 * numPairs > 3 * (1 << lgNumSlots)) {
            ++lgNumSlots;
        }
        PairTable table = new PairTable(lgNumSlots, 6 + lgK);
        for (int i = 0; i < numPairs; ++i) {
            PairTable.mustInsert(table, pairs[i]);
        }
        table.numPairs = numPairs;
        return table;
    }

    PairTable clear() {
        Arrays.fill(this.slotsArr, -1);
        this.numPairs = 0;
        return this;
    }

    PairTable copy() {
        PairTable copy = new PairTable(this.lgSizeInts, this.validBits);
        copy.numPairs = this.numPairs;
        copy.slotsArr = (int[])this.slotsArr.clone();
        return copy;
    }

    int getLgSizeInts() {
        return this.lgSizeInts;
    }

    int getNumPairs() {
        return this.numPairs;
    }

    int[] getSlotsArr() {
        return this.slotsArr;
    }

    int getValidBits() {
        return this.validBits;
    }

    PairTable rebuild(int newLgSizeInts) {
        PairTable.checkLgSizeInts(newLgSizeInts);
        int newSize = 1 << newLgSizeInts;
        int oldSize = 1 << this.lgSizeInts;
        RuntimeAsserts.rtAssert(newSize > this.numPairs);
        int[] oldSlotsArr = this.slotsArr;
        this.slotsArr = new int[newSize];
        Arrays.fill(this.slotsArr, -1);
        this.lgSizeInts = newLgSizeInts;
        for (int i = 0; i < oldSize; ++i) {
            int item = oldSlotsArr[i];
            if (item == -1) continue;
            PairTable.mustInsert(this, item);
        }
        return this;
    }

    public String toString() {
        return this.toString(false);
    }

    private static void mustInsert(PairTable table, int item) {
        int lgSizeInts = table.lgSizeInts;
        int sizeInts = 1 << lgSizeInts;
        int mask = sizeInts - 1;
        int shift = table.validBits - lgSizeInts;
        RuntimeAsserts.rtAssert(shift > 0);
        int probe = item >>> shift;
        RuntimeAsserts.rtAssert(probe >= 0 && probe <= mask);
        int[] arr = table.slotsArr;
        int fetched = arr[probe];
        while (fetched != item && fetched != -1) {
            probe = probe + 1 & mask;
            fetched = arr[probe];
        }
        if (fetched == item) {
            throw new SketchesStateException("PairTable mustInsert() failed");
        }
        assert (fetched == -1);
        arr[probe] = item;
    }

    static boolean maybeInsert(PairTable table, int item) {
        int lgSizeInts = table.lgSizeInts;
        int sizeInts = 1 << lgSizeInts;
        int mask = sizeInts - 1;
        int shift = table.validBits - lgSizeInts;
        RuntimeAsserts.rtAssert(shift > 0);
        int probe = item >>> shift;
        RuntimeAsserts.rtAssert(probe >= 0 && probe <= mask);
        int[] arr = table.slotsArr;
        int fetched = arr[probe];
        while (fetched != item && fetched != -1) {
            probe = probe + 1 & mask;
            fetched = arr[probe];
        }
        if (fetched == item) {
            return false;
        }
        assert (fetched == -1);
        arr[probe] = item;
        ++table.numPairs;
        while (4 * table.numPairs > 3 * (1 << table.lgSizeInts)) {
            table.rebuild(table.lgSizeInts + 1);
        }
        return true;
    }

    static boolean maybeDelete(PairTable table, int item) {
        int lgSizeInts = table.lgSizeInts;
        int sizeInts = 1 << lgSizeInts;
        int mask = sizeInts - 1;
        int shift = table.validBits - lgSizeInts;
        RuntimeAsserts.rtAssert(shift > 0);
        int probe = item >>> shift;
        RuntimeAsserts.rtAssert(probe >= 0 && probe <= mask);
        int[] arr = table.slotsArr;
        int fetched = arr[probe];
        while (fetched != item && fetched != -1) {
            probe = probe + 1 & mask;
            fetched = arr[probe];
        }
        if (fetched == -1) {
            return false;
        }
        assert (fetched == item);
        arr[probe] = -1;
        --table.numPairs;
        assert (table.numPairs >= 0);
        probe = probe + 1 & mask;
        fetched = arr[probe];
        while (fetched != -1) {
            arr[probe] = -1;
            PairTable.mustInsert(table, fetched);
            probe = probe + 1 & mask;
            fetched = arr[probe];
        }
        while (4 * table.numPairs < 1 * (1 << table.lgSizeInts) && table.lgSizeInts > 2) {
            table.rebuild(table.lgSizeInts - 1);
        }
        return true;
    }

    static int[] unwrappingGetItems(PairTable table, int numPairs) {
        if (numPairs < 1) {
            return null;
        }
        int[] slotsArr = table.slotsArr;
        int tableSize = 1 << table.lgSizeInts;
        int[] result = new int[numPairs];
        int i = 0;
        int l = 0;
        int r = numPairs - 1;
        int hiBit = 1 << table.validBits - 1;
        while (i < tableSize && slotsArr[i] != -1) {
            int item;
            if (((item = slotsArr[i++]) & hiBit) != 0) {
                result[r--] = item;
                continue;
            }
            result[l++] = item;
        }
        while (i < tableSize) {
            int look;
            if ((look = slotsArr[i++]) == -1) continue;
            result[l++] = look;
        }
        assert (l == r + 1);
        return result;
    }

    static void introspectiveInsertionSort(int[] a, int l, int r) {
        int length = r - l + 1;
        long cost = 0L;
        long costLimit = 8L * (long)length;
        for (int i = l + 1; i <= r; ++i) {
            int m;
            int j;
            long v = (long)a[i] & 0xFFFFFFFFL;
            for (j = i; j >= l + 1 && v < ((long)a[j - 1] & 0xFFFFFFFFL); --j) {
                a[j] = a[j - 1];
            }
            a[j] = (int)v;
            if ((cost += (long)(i - j)) <= costLimit) continue;
            long[] b = new long[a.length];
            for (m = 0; m < a.length; ++m) {
                b[m] = (long)a[m] & 0xFFFFFFFFL;
            }
            Arrays.sort(b, l, r + 1);
            for (m = 0; m < a.length; ++m) {
                a[m] = (int)b[m];
            }
            return;
        }
    }

    static void merge(int[] arrA, int startA, int lengthA, int[] arrB, int startB, int lengthB, int[] arrC, int startC) {
        int lengthC = lengthA + lengthB;
        int limA = startA + lengthA;
        int limB = startB + lengthB;
        int limC = startC + lengthC;
        int a = startA;
        int b = startB;
        for (int c = startC; c < limC; ++c) {
            long bb;
            long aa;
            arrC[c] = b >= limB ? arrA[a++] : (a >= limA ? arrB[b++] : ((aa = (long)arrA[a] & 0xFFFFFFFFL) < (bb = (long)arrB[b] & 0xFFFFFFFFL) ? arrA[a++] : arrB[b++]));
        }
        assert (a == limA);
        assert (b == limB);
    }

    static boolean equals(PairTable a, PairTable b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            throw new SketchesArgumentException("PairTable " + (a == null ? "a" : "b") + " is null");
        }
        RuntimeAsserts.rtAssertEquals(a.validBits, b.validBits);
        int numPairsA = a.numPairs;
        int numPairsB = b.numPairs;
        RuntimeAsserts.rtAssertEquals(numPairsA, numPairsB);
        int[] pairsA = PairTable.unwrappingGetItems(a, numPairsA);
        int[] pairsB = PairTable.unwrappingGetItems(b, numPairsB);
        PairTable.introspectiveInsertionSort(pairsA, 0, numPairsA - 1);
        PairTable.introspectiveInsertionSort(pairsB, 0, numPairsB - 1);
        RuntimeAsserts.rtAssertEquals(pairsA, pairsB);
        return true;
    }

    String toString(boolean detail) {
        StringBuilder sb = new StringBuilder();
        int sizeInts = 1 << this.lgSizeInts;
        sb.append("PairTable").append(Util.LS);
        sb.append("  Lg Size Ints  : ").append(this.lgSizeInts).append(Util.LS);
        sb.append("  Size Ints     : ").append(sizeInts).append(Util.LS);
        sb.append("  Valid Bits    : ").append(this.validBits).append(Util.LS);
        sb.append("  Num Pairs     : ").append(this.numPairs).append(Util.LS);
        if (detail) {
            sb.append("  DATA (hex) : ").append(Util.LS);
            String hdr = String.format("%9s %9s %9s %4s", "Index", "Word", "Row", "Col");
            sb.append(hdr).append(Util.LS);
            for (int i = 0; i < sizeInts; ++i) {
                int word = this.slotsArr[i];
                if (word == -1) {
                    String h = String.format("%9d %9s", i, "--");
                    sb.append(h).append(Util.LS);
                    continue;
                }
                int row = word >>> 6;
                int col = word & 0x3F;
                String wordStr = Long.toHexString((long)word & 0xFFFFFFFFL);
                String data = String.format("%9d %9s %9d %4d", i, wordStr, row, col);
                sb.append(data).append(Util.LS);
            }
        }
        return sb.toString();
    }

    private static void checkLgSizeInts(int lgSizeInts) {
        if (lgSizeInts < 2 || lgSizeInts > 26) {
            throw new SketchesArgumentException("Illegal LgSizeInts: " + lgSizeInts);
        }
    }
}

