/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.cpc;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SuppressFBWarnings;
import org.apache.datasketches.cpc.CpcConfidence;
import org.apache.datasketches.cpc.IconEstimator;
import org.apache.datasketches.cpc.PreambleUtil;
import org.apache.datasketches.cpc.RuntimeAsserts;

public final class CpcWrapper {
    MemorySegment seg;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="This is OK here")
    public CpcWrapper(MemorySegment seg) {
        this.seg = seg;
        PreambleUtil.checkLoPreamble(seg);
        RuntimeAsserts.rtAssert(PreambleUtil.isCompressed(seg));
    }

    public CpcWrapper(byte[] byteArray) {
        this(MemorySegment.ofArray(byteArray));
    }

    public double getEstimate() {
        if (!PreambleUtil.hasHip(this.seg)) {
            return IconEstimator.getIconEstimate(PreambleUtil.getLgK(this.seg), PreambleUtil.getNumCoupons(this.seg));
        }
        return PreambleUtil.getHipAccum(this.seg);
    }

    public static Family getFamily() {
        return Family.CPC;
    }

    public int getLgK() {
        return PreambleUtil.getLgK(this.seg);
    }

    public double getLowerBound(int kappa) {
        if (!PreambleUtil.hasHip(this.seg)) {
            return CpcConfidence.getIconConfidenceLB(PreambleUtil.getLgK(this.seg), PreambleUtil.getNumCoupons(this.seg), kappa);
        }
        return CpcConfidence.getHipConfidenceLB(PreambleUtil.getLgK(this.seg), PreambleUtil.getNumCoupons(this.seg), PreambleUtil.getHipAccum(this.seg), kappa);
    }

    public double getUpperBound(int kappa) {
        if (!PreambleUtil.hasHip(this.seg)) {
            return CpcConfidence.getIconConfidenceUB(PreambleUtil.getLgK(this.seg), PreambleUtil.getNumCoupons(this.seg), kappa);
        }
        return CpcConfidence.getHipConfidenceUB(PreambleUtil.getLgK(this.seg), PreambleUtil.getNumCoupons(this.seg), PreambleUtil.getHipAccum(this.seg), kappa);
    }
}

