/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.quantiles.PreambleUtil;
import org.apache.datasketches.quantiles.QuantilesItemsSketch;

final class ItemsByteArrayImpl {
    private ItemsByteArrayImpl() {
    }

    static <T> byte[] toByteArray(QuantilesItemsSketch<T> sketch, boolean ordered, ArrayOfItemsSerDe<T> serDe) {
        boolean empty = sketch.isEmpty();
        int flags = (empty ? 4 : 0) | (ordered ? 16 : 0) | 8;
        if (empty) {
            byte[] outByteArr = new byte[8];
            MemorySegment segOut = MemorySegment.ofArray(outByteArr);
            boolean preLongs = true;
            ItemsByteArrayImpl.insertPre0(segOut, 1, flags, sketch.getK());
            return outByteArr;
        }
        T[] dataArr = ItemsByteArrayImpl.combinedBufferToItemsArray(sketch, ordered);
        int preLongs = 2;
        byte[] itemsByteArr = serDe.serializeToByteArray(dataArr);
        int numOutBytes = 16 + itemsByteArr.length;
        byte[] outByteArr = new byte[numOutBytes];
        MemorySegment segOut = MemorySegment.ofArray(outByteArr);
        ItemsByteArrayImpl.insertPre0(segOut, 2, flags, sketch.getK());
        PreambleUtil.insertN(segOut, sketch.getN());
        MemorySegment.copy(itemsByteArr, 0, segOut, ValueLayout.JAVA_BYTE, 16L, itemsByteArr.length);
        return outByteArr;
    }

    private static <T> T[] combinedBufferToItemsArray(QuantilesItemsSketch<T> sketch, boolean ordered) {
        long bitPattern;
        int extra = 2;
        int outArrCap = sketch.getNumRetained();
        T minItem = sketch.getMinItem();
        Object[] outArr = (Object[])Array.newInstance(minItem.getClass(), outArrCap + 2);
        outArr[0] = minItem;
        outArr[1] = sketch.getMaxItem();
        int baseBufferCount = sketch.getBaseBufferCount();
        Object[] combinedBuffer = sketch.getCombinedBuffer();
        System.arraycopy(combinedBuffer, 0, outArr, 2, baseBufferCount);
        if (bitPattern > 0L) {
            int k = sketch.getK();
            int index = 2 + baseBufferCount;
            int level = 0;
            for (bitPattern = sketch.getBitPattern(); bitPattern != 0L; bitPattern >>>= 1) {
                if ((bitPattern & 1L) > 0L) {
                    System.arraycopy(combinedBuffer, (2 + level) * k, outArr, index, k);
                    index += k;
                }
                ++level;
            }
        }
        if (ordered) {
            Arrays.sort(outArr, 2, baseBufferCount + 2, sketch.getComparator());
        }
        return outArr;
    }

    private static void insertPre0(MemorySegment wseg, int preLongs, int flags, int k) {
        PreambleUtil.insertPreLongs(wseg, preLongs);
        PreambleUtil.insertSerVer(wseg, 3);
        PreambleUtil.insertFamilyID(wseg, Family.QUANTILES.getID());
        PreambleUtil.insertFlags(wseg, flags);
        PreambleUtil.insertK(wseg, k);
    }
}

