/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.ThetaIntersectionImpl;
import org.apache.datasketches.theta.ThetaSetOperation;
import org.apache.datasketches.theta.ThetaSketch;

public abstract class ThetaIntersection
extends ThetaSetOperation {
    @Override
    public Family getFamily() {
        return Family.INTERSECTION;
    }

    public CompactThetaSketch getResult() {
        return this.getResult(true, null);
    }

    public abstract CompactThetaSketch getResult(boolean var1, MemorySegment var2);

    public abstract boolean hasResult();

    public abstract void reset();

    public abstract byte[] toByteArray();

    public abstract void intersect(ThetaSketch var1);

    public CompactThetaSketch intersect(ThetaSketch a, ThetaSketch b) {
        return this.intersect(a, b, true, null);
    }

    public abstract CompactThetaSketch intersect(ThetaSketch var1, ThetaSketch var2, boolean var3, MemorySegment var4);

    public static ThetaIntersection wrap(MemorySegment srcSeg) {
        return ThetaIntersection.wrap(srcSeg, 9001L);
    }

    public static ThetaIntersection wrap(MemorySegment srcSeg, long expectedSeed) {
        byte serVer = srcSeg.get(ValueLayout.JAVA_BYTE, 1L);
        if (serVer != 3) {
            throw new SketchesArgumentException("SerVer must be 3: " + serVer);
        }
        return ThetaIntersectionImpl.wrapInstance(srcSeg, expectedSeed, srcSeg.isReadOnly());
    }
}

