/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.tuple;

import java.util.Random;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.tuple.PigUtil;
import org.apache.datasketches.pig.tuple.UnionDoubleSummarySketch;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SketchIterator;
import org.apache.datasketches.tuple.Sketches;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.UpdatableSketch;
import org.apache.datasketches.tuple.UpdatableSketchBuilder;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryDeserializer;
import org.apache.datasketches.tuple.adouble.DoubleSummaryFactory;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UnionDoubleSummarySketchTest {
    @Test
    public void execNullInput() throws Exception {
        UnionDoubleSummarySketch func = new UnionDoubleSummarySketch();
        Tuple resultTuple = (Tuple)func.exec(null);
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void execEmptyInputTuple() throws Exception {
        UnionDoubleSummarySketch func = new UnionDoubleSummarySketch();
        Tuple resultTuple = (Tuple)func.exec(TupleFactory.getInstance().newTuple());
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void exec() throws Exception {
        UnionDoubleSummarySketch func = new UnionDoubleSummarySketch("4096");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
        sketch.update(1L, (Object)1.0);
        sketch.update(2L, (Object)1.0);
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
        sketch.update(1L, (Object)1.0);
        sketch.update(2L, (Object)1.0);
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        Tuple resultTuple = (Tuple)func.exec(PigUtil.objectsToTuple(bag));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        Sketch sketch2 = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertEquals((double)sketch2.getEstimate(), (double)2.0, (double)0.0);
        SketchIterator it = sketch2.iterator();
        while (it.next()) {
            Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)2.0, (double)0.0);
        }
    }

    @Test
    public void execMaxMode() throws Exception {
        UnionDoubleSummarySketch func = new UnionDoubleSummarySketch("4096", "Max");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
        sketch.update(1L, (Object)1.0);
        sketch.update(2L, (Object)1.0);
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
        sketch.update(1L, (Object)3.0);
        sketch.update(2L, (Object)3.0);
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        Tuple resultTuple = (Tuple)func.exec(PigUtil.objectsToTuple(bag));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        Sketch sketch2 = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertEquals((double)sketch2.getEstimate(), (double)2.0, (double)0.0);
        SketchIterator it = sketch2.iterator();
        while (it.next()) {
            Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)3.0, (double)0.0);
        }
    }

    @Test
    public void accumulatorNullInput() throws Exception {
        UnionDoubleSummarySketch func = new UnionDoubleSummarySketch("32");
        func.accumulate(null);
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        Sketch sketch = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertEquals((double)sketch.getEstimate(), (double)0.0);
    }

    @Test
    public void accumulatorEmptyInputTuple() throws Exception {
        UnionDoubleSummarySketch func = new UnionDoubleSummarySketch("32");
        func.accumulate(TupleFactory.getInstance().newTuple());
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        Sketch sketch = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertEquals((double)sketch.getEstimate(), (double)0.0);
    }

    @Test
    public void accumulatorNotABag() throws Exception {
        UnionDoubleSummarySketch func = new UnionDoubleSummarySketch("32");
        func.accumulate(PigUtil.objectsToTuple(new Object[]{null}));
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        Sketch sketch = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertEquals((double)sketch.getEstimate(), (double)0.0);
    }

    @Test
    public void accumulatorEmptyBag() throws Exception {
        UnionDoubleSummarySketch func = new UnionDoubleSummarySketch("32");
        func.accumulate(PigUtil.objectsToTuple(BagFactory.getInstance().newDefaultBag()));
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        Sketch sketch = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertEquals((double)sketch.getEstimate(), (double)0.0);
    }

    @Test
    public void accumulatorEmptyInnerTuple() throws Exception {
        UnionDoubleSummarySketch func = new UnionDoubleSummarySketch("32");
        func.accumulate(PigUtil.objectsToTuple(PigUtil.tuplesToBag(TupleFactory.getInstance().newTuple())));
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        Sketch sketch = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertEquals((double)sketch.getEstimate(), (double)0.0);
    }

    @Test
    public void accumulatorNullSketch() throws Exception {
        UnionDoubleSummarySketch func = new UnionDoubleSummarySketch("32");
        func.accumulate(PigUtil.objectsToTuple(PigUtil.tuplesToBag(PigUtil.objectsToTuple(new Object[]{null}))));
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        Sketch sketch = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertEquals((double)sketch.getEstimate(), (double)0.0);
    }

    @Test
    public void accumulatorEmptySketch() throws Exception {
        UnionDoubleSummarySketch func = new UnionDoubleSummarySketch("4096");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        func.accumulate(PigUtil.objectsToTuple(bag));
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        Sketch sketch2 = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertEquals((double)sketch2.getEstimate(), (double)0.0);
    }

    @Test
    public void accumulator() throws Exception {
        UnionDoubleSummarySketch func = new UnionDoubleSummarySketch("4096");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
        sketch.update(1L, (Object)1.0);
        sketch.update(2L, (Object)1.0);
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        func.accumulate(PigUtil.objectsToTuple(bag));
        bag = BagFactory.getInstance().newDefaultBag();
        sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
        sketch.update(1L, (Object)1.0);
        sketch.update(2L, (Object)1.0);
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        func.accumulate(PigUtil.objectsToTuple(bag));
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        Sketch sketch2 = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertEquals((double)sketch2.getEstimate(), (double)2.0, (double)0.0);
        SketchIterator it = sketch2.iterator();
        while (it.next()) {
            Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)2.0, (double)0.0);
        }
    }

    @Test
    public void algebraicInitial() throws Exception {
        UnionDoubleSummarySketch.Initial func = new UnionDoubleSummarySketch.Initial(null);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        bag.add(null);
        bag.add(null);
        bag.add(null);
        Tuple resultTuple = (Tuple)func.exec(PigUtil.objectsToTuple(bag));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataBag resultBag = (DataBag)resultTuple.get(0);
        Assert.assertEquals((long)resultBag.size(), (long)3L);
    }

    @Test
    public void algebraicIntemediateFinalExactMinMode() throws Exception {
        UnionDoubleSummarySketch.IntermediateFinal func = new UnionDoubleSummarySketch.IntermediateFinal("4096", "Min");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
        sketch.update(1L, (Object)1.0);
        sketch.update(2L, (Object)1.0);
        DataBag innerBag = PigUtil.tuplesToBag(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        bag.add(PigUtil.objectsToTuple(innerBag));
        sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
        sketch.update(1L, (Object)3.0);
        sketch.update(2L, (Object)3.0);
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        Tuple resultTuple = (Tuple)func.exec(PigUtil.objectsToTuple(bag));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        Sketch sketch2 = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertEquals((double)sketch2.getEstimate(), (double)2.0, (double)0.0);
        SketchIterator it = sketch2.iterator();
        while (it.next()) {
            Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)1.0, (double)0.0);
        }
    }

    @Test
    public void algebraicIntemediateFinalEstimation() throws Exception {
        UnionDoubleSummarySketch.IntermediateFinal func = new UnionDoubleSummarySketch.IntermediateFinal("16384");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        long value = 1L;
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).setNominalEntries(16384).build();
        for (int i = 0; i < 20000; ++i) {
            sketch.update(value++, (Object)1.0);
        }
        DataBag innerBag = PigUtil.tuplesToBag(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        bag.add(PigUtil.objectsToTuple(innerBag));
        sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).setNominalEntries(16384).build();
        for (int i = 0; i < 20000; ++i) {
            sketch.update(value++, (Object)1.0);
        }
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        Tuple resultTuple = (Tuple)func.exec(PigUtil.objectsToTuple(bag));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        Sketch sketch2 = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertEquals((double)sketch2.getEstimate(), (double)40000.0, (double)400.0);
        SketchIterator it = sketch2.iterator();
        while (it.next()) {
            Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)1.0, (double)0.0);
        }
    }

    @Test
    public void algebraicIntemediateFinalSingleCall() throws Exception {
        UnionDoubleSummarySketch.IntermediateFinal func = new UnionDoubleSummarySketch.IntermediateFinal("1024");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        long value = 1L;
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).setNominalEntries(1024).build();
        for (int i = 0; i < 10000; ++i) {
            sketch.update(value++, (Object)1.0);
        }
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        Tuple resultTuple = (Tuple)func.exec(PigUtil.objectsToTuple(bag));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        Sketch sketch2 = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertEquals((double)sketch2.getEstimate(), (double)10000.0, (double)200.0);
        SketchIterator it = sketch2.iterator();
        while (it.next()) {
            Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)1.0, (double)0.0);
        }
    }

    @Test
    public void algebraicIntemediateFinalRandomized() throws Exception {
        int i;
        UnionDoubleSummarySketch.IntermediateFinal func = new UnionDoubleSummarySketch.IntermediateFinal("16384");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        long key = 1L;
        Random rnd = new Random();
        long uniques = 0L;
        long updates = 0L;
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).setNominalEntries(16384).build();
        for (i = 0; i < 40000; ++i) {
            sketch.update(key++, (Object)(rnd.nextDouble() * 20.0));
        }
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        uniques += 40000L;
        updates += 40000L;
        key -= 20000L;
        sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).setNominalEntries(16384).build();
        for (i = 0; i < 60000; ++i) {
            sketch.update(key++, (Object)(rnd.nextDouble() * 20.0));
        }
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        uniques += 40000L;
        updates += 60000L;
        key -= 20000L;
        sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).setNominalEntries(16384).build();
        for (i = 0; i < 60000; ++i) {
            sketch.update(key++, (Object)(rnd.nextDouble() * 20.0));
        }
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        uniques += 40000L;
        updates += 60000L;
        key -= 20000L;
        sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).setNominalEntries(16384).build();
        for (i = 0; i < 60000; ++i) {
            sketch.update(key++, (Object)(rnd.nextDouble() * 20.0));
        }
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        uniques += 40000L;
        updates += 60000L;
        sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).setNominalEntries(16384).build();
        for (i = 0; i < 40000; ++i) {
            sketch.update(key++, (Object)(rnd.nextDouble() * 20.0));
        }
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        uniques += 40000L;
        updates += 40000L;
        sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).setNominalEntries(16384).build();
        for (i = 0; i < 40000; ++i) {
            sketch.update(key++, (Object)(rnd.nextDouble() * 20.0));
        }
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        uniques += 40000L;
        updates += 40000L;
        key -= 20000L;
        sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).setNominalEntries(16384).build();
        for (i = 0; i < 60000; ++i) {
            sketch.update(key++, (Object)(rnd.nextDouble() * 20.0));
        }
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        uniques += 40000L;
        updates += 60000L;
        Tuple resultTuple = (Tuple)func.exec(PigUtil.objectsToTuple(bag));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        Sketch sketch2 = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertEquals((double)sketch2.getEstimate(), (double)uniques, (double)((double)uniques * 0.01));
        double sum = 0.0;
        SketchIterator it = sketch2.iterator();
        while (it.next()) {
            sum += ((DoubleSummary)it.getSummary()).getValue();
        }
        Assert.assertEquals((double)(sum / sketch2.getTheta()), (double)((double)updates * 10.0), (double)((double)updates * 10.0 * 0.02));
    }
}

