/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.kll;

import java.io.IOException;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;

public class GetRank
extends EvalFunc<Double> {
    public Double exec(Tuple input) throws IOException {
        if (input.size() != 2) {
            throw new IllegalArgumentException("expected two inputs: sketch and value");
        }
        if (!(input.get(0) instanceof DataByteArray)) {
            throw new IllegalArgumentException("expected a DataByteArray as a sketch, got " + input.get(0).getClass().getSimpleName());
        }
        DataByteArray dba = (DataByteArray)input.get(0);
        KllFloatsSketch sketch = KllFloatsSketch.heapify((Memory)Memory.wrap((byte[])dba.get()));
        if (!(input.get(1) instanceof Float)) {
            throw new IllegalArgumentException("expected a float value, got " + input.get(1).getClass().getSimpleName());
        }
        float value = ((Float)input.get(1)).floatValue();
        return sketch.getRank(value);
    }
}

