/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.sampling;

import java.io.IOException;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.sampling.ArrayOfTuplesSerDe;
import org.apache.datasketches.sampling.VarOptItemsSamples;
import org.apache.datasketches.sampling.VarOptItemsSketch;
import org.apache.datasketches.sampling.VarOptItemsUnion;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

class VarOptCommonImpl {
    static final int DEFAULT_TARGET_K = 1024;
    static final int DEFAULT_WEIGHT_IDX = 0;
    static final String WEIGHT_ALIAS = "vo_weight";
    static final String RECORD_ALIAS = "record";
    private static final BagFactory BAG_FACTORY = BagFactory.getInstance();
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();
    private static final ArrayOfTuplesSerDe SERDE = new ArrayOfTuplesSerDe();

    VarOptCommonImpl() {
    }

    static VarOptItemsSketch<Tuple> rawTuplesToSketch(Tuple inputTuple, int k, int weightIdx) throws IOException {
        assert (inputTuple != null);
        assert (inputTuple.size() >= 1);
        assert (!inputTuple.isNull(0));
        DataBag samples = (DataBag)inputTuple.get(0);
        VarOptItemsSketch sketch = VarOptItemsSketch.newInstance((int)k);
        for (Tuple t : samples) {
            double weight = (Double)t.get(weightIdx);
            sketch.update((Object)t, weight);
        }
        return sketch;
    }

    static VarOptItemsUnion<Tuple> unionSketches(Tuple inputTuple, int k) throws IOException {
        assert (inputTuple != null);
        assert (inputTuple.size() >= 1);
        assert (!inputTuple.isNull(0));
        VarOptItemsUnion union = VarOptItemsUnion.newInstance((int)k);
        DataBag sketchBag = (DataBag)inputTuple.get(0);
        for (Tuple t : sketchBag) {
            DataByteArray dba = (DataByteArray)t.get(0);
            Memory mem = Memory.wrap((byte[])dba.get());
            union.update(mem, (ArrayOfItemsSerDe)SERDE);
        }
        return union;
    }

    static Tuple wrapSketchInTuple(VarOptItemsSketch<Tuple> sketch) {
        DataByteArray dba = new DataByteArray(sketch.toByteArray((ArrayOfItemsSerDe)SERDE));
        return TUPLE_FACTORY.newTuple((Object)dba);
    }

    static DataBag createDataBagFromSketch(VarOptItemsSketch<Tuple> sketch) {
        DataBag output = BAG_FACTORY.newDefaultBag();
        VarOptItemsSamples samples = sketch.getSketchSamples();
        try {
            for (VarOptItemsSamples.WeightedSample ws : samples) {
                Tuple weightedSample = TUPLE_FACTORY.newTuple(2);
                weightedSample.set(0, (Object)ws.getWeight());
                weightedSample.set(1, ws.getItem());
                output.add(weightedSample);
            }
        }
        catch (ExecException e) {
            throw new RuntimeException("Pig error: " + e.getMessage(), e);
        }
        return output;
    }

    public static class UnionSketchesAsByteArray
    extends EvalFunc<DataByteArray> {
        private final int targetK_;
        private final int weightIdx_;

        public UnionSketchesAsByteArray() {
            this.targetK_ = 1024;
            this.weightIdx_ = 0;
        }

        public UnionSketchesAsByteArray(String kStr) {
            this.targetK_ = Integer.parseInt(kStr);
            this.weightIdx_ = 0;
            if (this.targetK_ < 1) {
                throw new IllegalArgumentException("VarOpt requires target sample size >= 1: " + this.targetK_);
            }
        }

        public UnionSketchesAsByteArray(String kStr, String weightIdxStr) {
            this.targetK_ = Integer.parseInt(kStr);
            this.weightIdx_ = Integer.parseInt(weightIdxStr);
            if (this.targetK_ < 1) {
                throw new IllegalArgumentException("VarOptSampling requires target sample size >= 1: " + this.targetK_);
            }
            if (this.weightIdx_ < 0) {
                throw new IllegalArgumentException("VarOptSampling requires weight index >= 0: " + this.weightIdx_);
            }
        }

        public DataByteArray exec(Tuple inputTuple) throws IOException {
            if (inputTuple == null || inputTuple.size() < 1 || inputTuple.isNull(0)) {
                return null;
            }
            VarOptItemsUnion<Tuple> union = VarOptCommonImpl.unionSketches(inputTuple, this.targetK_);
            return new DataByteArray(union.getResult().toByteArray((ArrayOfItemsSerDe)SERDE));
        }
    }

    public static class UnionSketchesAsTuple
    extends EvalFunc<Tuple> {
        private final int targetK_;
        private final int weightIdx_;

        public UnionSketchesAsTuple() {
            this.targetK_ = 1024;
            this.weightIdx_ = 0;
        }

        public UnionSketchesAsTuple(String kStr) {
            this.targetK_ = Integer.parseInt(kStr);
            this.weightIdx_ = 0;
            if (this.targetK_ < 1) {
                throw new IllegalArgumentException("VarOpt requires target sample size >= 1: " + this.targetK_);
            }
        }

        public UnionSketchesAsTuple(String kStr, String weightIdxStr) {
            this.targetK_ = Integer.parseInt(kStr);
            this.weightIdx_ = Integer.parseInt(weightIdxStr);
            if (this.targetK_ < 1) {
                throw new IllegalArgumentException("VarOptSampling requires target sample size >= 1: " + this.targetK_);
            }
            if (this.weightIdx_ < 0) {
                throw new IllegalArgumentException("VarOptSampling requires weight index >= 0: " + this.weightIdx_);
            }
        }

        public Tuple exec(Tuple inputTuple) throws IOException {
            if (inputTuple == null || inputTuple.size() < 1 || inputTuple.isNull(0)) {
                return null;
            }
            VarOptItemsUnion<Tuple> union = VarOptCommonImpl.unionSketches(inputTuple, this.targetK_);
            return VarOptCommonImpl.wrapSketchInTuple((VarOptItemsSketch<Tuple>)union.getResult());
        }
    }

    public static class RawTuplesToSketchTuple
    extends EvalFunc<Tuple> {
        private final int targetK_;
        private final int weightIdx_;

        public RawTuplesToSketchTuple() {
            this.targetK_ = 1024;
            this.weightIdx_ = 0;
        }

        public RawTuplesToSketchTuple(String kStr) {
            this.targetK_ = Integer.parseInt(kStr);
            this.weightIdx_ = 0;
            if (this.targetK_ < 1) {
                throw new IllegalArgumentException("VarOpt requires target reservoir size >= 1: " + this.targetK_);
            }
        }

        public RawTuplesToSketchTuple(String kStr, String weightIdxStr) {
            this.targetK_ = Integer.parseInt(kStr);
            this.weightIdx_ = Integer.parseInt(weightIdxStr);
            if (this.targetK_ < 1) {
                throw new IllegalArgumentException("VarOptSampling requires target sample size >= 1: " + this.targetK_);
            }
            if (this.weightIdx_ < 0) {
                throw new IllegalArgumentException("VarOptSampling requires weight index >= 0: " + this.weightIdx_);
            }
        }

        public Tuple exec(Tuple inputTuple) throws IOException {
            if (inputTuple == null || inputTuple.size() < 1 || inputTuple.isNull(0)) {
                return null;
            }
            VarOptItemsSketch<Tuple> sketch = VarOptCommonImpl.rawTuplesToSketch(inputTuple, this.targetK_, this.weightIdx_);
            return VarOptCommonImpl.wrapSketchInTuple(sketch);
        }
    }
}

