/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SysinfoTest
extends BaseJDBCTestCase {
    private static final String POLICY_FILE_NAME = "org/apache/derbyTesting/functionTests/tests/derbynet/SysinfoTest.policy";
    private ArrayList<String> OUTPUT;
    private static boolean useProperties = false;

    public SysinfoTest(String name) {
        super(name);
        ArrayList<String> OUTPUT1 = new ArrayList<String>();
        OUTPUT1.add("--------- Derby Network Server Information --------");
        OUTPUT1.add("derby.drda.maxThreads=0");
        OUTPUT1.add("derby.drda.sslMode=off");
        OUTPUT1.add("derby.drda.keepAlive=true");
        OUTPUT1.add("derby.drda.minThreads=0");
        OUTPUT1.add("derby.drda.portNumber=" + TestConfiguration.getCurrent().getPort());
        OUTPUT1.add("derby.drda.logConnections=false");
        OUTPUT1.add("derby.drda.timeSlice=0");
        OUTPUT1.add("derby.drda.startNetworkServer=false");
        OUTPUT1.add("derby.drda.traceAll=false");
        OUTPUT1.add("--------- Derby Information --------");
        OUTPUT1.add("------------------------------------------------------");
        OUTPUT1.add("----------------- Locale Information -----------------");
        OUTPUT1.add("------------------------------------------------------");
        ArrayList<String> OUTPUT2 = new ArrayList<String>(OUTPUT1);
        OUTPUT2.add("--------- Derby Network Server Information --------");
        OUTPUT2.add("derby.drda.securityMechanism=USER_ONLY_SECURITY");
        this.OUTPUT = useProperties ? OUTPUT2 : OUTPUT1;
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("SysinfoTest");
        if (!Derby.hasServer()) {
            return suite;
        }
        if (JDBC.vmSupportsJSR169()) {
            return suite;
        }
        useProperties = false;
        if (!TestConfiguration.loadingFromJars()) {
            Properties propstmp = new Properties();
            propstmp.put("sysinfotest.classesdir", SysinfoTest.findClassDir());
            suite.addTest((Test)new SystemPropertyTestSetup(SysinfoTest.decorateTest(), propstmp));
        } else {
            suite.addTest(SysinfoTest.decorateTest());
        }
        useProperties = true;
        Properties sysprops = new Properties();
        if (!TestConfiguration.loadingFromJars()) {
            sysprops.put("sysinfotest.classesdir", SysinfoTest.findClassDir());
        }
        sysprops.put("derby.infolog.append", "true");
        sysprops.put("derby.language.logStatementText", "true");
        sysprops.put("derby.drda.securityMechanism", "USER_ONLY_SECURITY");
        TestSetup test = new SystemPropertyTestSetup(SysinfoTest.decorateTest(), sysprops);
        Properties prop = new Properties();
        prop.put("derby.locks.waitTimeout", "120");
        test = new DatabasePropertyTestSetup((Test)test, prop);
        suite.addTest((Test)test);
        return suite;
    }

    private static Test decorateTest() {
        Test test = TestConfiguration.clientServerSuite(SysinfoTest.class);
        return TestConfiguration.singleUseDatabaseDecorator((Test)new SecurityManagerSetup(test, POLICY_FILE_NAME));
    }

    public void testSysinfo() throws Exception {
        String[] SysInfoCmd = new String[]{"org.apache.derby.drda.NetworkServerControl", "sysinfo", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        Process p = SysinfoTest.execJavaCmd(SysInfoCmd);
        String s = SysinfoTest.readProcessOutput(p);
        this.print("testSysinfo", s);
        this.assertMatchingStringExists(s);
    }

    public void testSysinfoMethod() throws Exception {
        String s = NetworkServerTestSetup.getNetworkServerControl(TestConfiguration.getCurrent().getPort()).getSysinfo();
        this.print("testSysinfoMethod", s);
        this.assertMatchingStringExists(s);
    }

    public void testSysinfoLocale() throws Exception {
        String[] SysInfoLocaleCmd = new String[]{"-Duser.language=de", "-Duser.country=DE", "org.apache.derby.drda.NetworkServerControl", "sysinfo", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        Process p = SysinfoTest.execJavaCmd(SysInfoLocaleCmd);
        String s = SysinfoTest.readProcessOutput(p);
        this.print("testSysinfoLocale", s);
        this.assertMatchingStringExists(s);
    }

    private void print(String name, String s) {
        SysinfoTest.println("\n\n>>>" + name + ">>>");
        SysinfoTest.println(s);
        SysinfoTest.println("<<<" + name + "<<<\n\n");
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.OUTPUT = null;
    }

    private static String findClassDir() {
        URL url = SecurityManagerSetup.getURL("org.apache.derbyTesting.functionTests.tests.derbynet.SysinfoTest");
        return url.getPath();
    }

    private void assertMatchingStringExists(String actualOutput) {
        for (String s : this.OUTPUT) {
            SysinfoTest.assertTrue((String)("cannot find " + s + " in actualOutput:" + actualOutput), (actualOutput.indexOf(s) >= 0 ? 1 : 0) != 0);
        }
    }
}

