/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class CurrentSchemaTest
extends BaseJDBCTestCase {
    public CurrentSchemaTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("CurrentSchemaTest");
        suite.addTest(TestConfiguration.defaultSuite(CurrentSchemaTest.class));
        return suite;
    }

    public void testCurrentSchema() throws Exception {
        Statement st = this.createStatement();
        this.assertCurrentSchema(st, "APP");
        st.executeUpdate("set schema sys");
        this.assertCurrentSchema(st, "SYS");
        CurrentSchemaTest.assertStatementError("X0Y68", st, "create schema app");
        st.executeUpdate("set current schema app");
        this.assertCurrentSchema(st, "APP");
        st.executeUpdate("set schema = sys");
        this.assertCurrentSchema(st, "SYS");
        st.executeUpdate("set current schema = app");
        this.assertCurrentSchema(st, "APP");
        st.executeUpdate("set schema sys");
        st.executeUpdate("set schema user");
        this.assertCurrentSchema(st, "APP");
        st.executeUpdate("create schema judy");
        Connection judy = this.openUserConnection("judy");
        Statement jst = judy.createStatement();
        jst.executeUpdate("set schema app");
        this.assertCurrentSchema(jst, "APP");
        jst.executeUpdate("set schema user");
        this.assertCurrentSchema(jst, "JUDY");
        judy.close();
        this.assertCurrentSchema(st, "APP");
        ResultSet rs = st.executeQuery("values current sqlid");
        Object[][] expRS = new String[][]{{"APP"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("create table sqlid(sqlid int)");
        st.executeUpdate("drop table sqlid");
        st.executeUpdate("set current sqlid judy");
        this.assertCurrentSchema(st, "JUDY");
        CurrentSchemaTest.assertStatementError("42X01", st, "set sqlid judy");
        st.executeUpdate("set schema sys");
        this.assertCurrentSchema(st, "SYS");
        st.executeUpdate("set schema app");
        CurrentSchemaTest.assertStatementError("07000", st, "set schema ?");
        this.setAutoCommit(false);
        PreparedStatement pSt = this.prepareStatement("set schema ?");
        CurrentSchemaTest.assertStatementError("07000", pSt);
        st.executeUpdate("create table t1(name varchar(128))");
        st.executeUpdate("insert into t1 values(null)");
        rs = st.executeQuery("select name from t1");
        rs.next();
        pSt.setObject(1, rs.getObject(1));
        CurrentSchemaTest.assertStatementError("42815", pSt);
        rs = st.executeQuery("values('notthere')");
        rs.next();
        pSt.setObject(1, rs.getObject(1));
        CurrentSchemaTest.assertStatementError("42Y07", pSt);
        rs = st.executeQuery("values('')");
        rs.next();
        pSt.setObject(1, rs.getObject(1));
        CurrentSchemaTest.assertStatementError("42Y07", pSt);
        rs = st.executeQuery("values('sys')");
        rs.next();
        pSt.setObject(1, rs.getObject(1));
        CurrentSchemaTest.assertStatementError("42Y07", pSt);
        rs = st.executeQuery("values('sys','app')");
        rs.next();
        ResultSetMetaData rsmd = rs.getMetaData();
        try {
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                pSt.setObject(i, rs.getObject(i));
            }
        }
        catch (SQLException e) {
            if (CurrentSchemaTest.usingDerbyNetClient()) {
                CurrentSchemaTest.assertSQLState("XCL14", e);
            }
            CurrentSchemaTest.assertSQLState("XCL13", e);
        }
        rs = st.executeQuery("values('USER')");
        rs.next();
        pSt.setObject(1, rs.getObject(1));
        CurrentSchemaTest.assertStatementError("42Y07", pSt);
        rs = st.executeQuery("values('SYS')");
        rs.next();
        pSt.setObject(1, rs.getObject(1));
        CurrentSchemaTest.assertUpdateCount(pSt, 0);
        this.assertCurrentSchema(st, "SYS");
        this.rollback();
        this.setAutoCommit(true);
        st.executeUpdate("set schema app");
        st.executeUpdate("create table t1 ( a varchar(128))");
        st.executeUpdate("insert into t1 values (current schema)");
        rs = st.executeQuery("select * from t1");
        String[] expColNames = new String[]{"A"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"APP"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("set schema judy");
        st.executeUpdate("insert into app.t1 values (current schema)");
        rs = st.executeQuery("select * from app.t1");
        expColNames = new String[]{"A"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"APP"}, {"JUDY"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        CurrentSchemaTest.assertUpdateCount(st, 1, "delete from app.t1 where a = current schema");
        rs = st.executeQuery("select * from app.t1");
        expColNames = new String[]{"A"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"APP"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("set current schema app");
        rs = st.executeQuery("select current schema from t1");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"APP"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from t1 where a = current schema");
        expColNames = new String[]{"A"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"APP"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        CurrentSchemaTest.assertUpdateCount(st, 1, "delete from t1");
        st.executeUpdate("insert into t1 values ('test')");
        rs = st.executeQuery("select * from t1");
        expColNames = new String[]{"A"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"test"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        CurrentSchemaTest.assertUpdateCount(st, 1, "update t1 set a = current schema");
        rs = st.executeQuery("select * from t1");
        expColNames = new String[]{"A"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"APP"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("set schema judy");
        CurrentSchemaTest.assertUpdateCount(st, 1, "update app.t1 set a = current schema");
        rs = st.executeQuery("select * from app.t1");
        expColNames = new String[]{"A"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"JUDY"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("set schema app");
        st.executeUpdate("drop table t1");
        st.executeUpdate("set schema APP");
        st.executeUpdate(" create table t1 ( a int, b varchar(128) default current schema)");
        st.executeUpdate("insert into t1 (a) values (1)");
        st.executeUpdate("set schema SYS");
        st.executeUpdate("insert into app.t1 (a) values (1)");
        st.executeUpdate("set schema judy");
        st.executeUpdate("insert into app.t1 (a) values (1)");
        st.executeUpdate("set schema APP");
        rs = st.executeQuery("select * from t1");
        expColNames = new String[]{"A", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "APP"}, {"1", "SYS"}, {"1", "JUDY"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("drop table t1");
        CurrentSchemaTest.assertStatementError("42Y39", st, "create table t1 ( a varchar(128), check (a = current schema))");
        CurrentSchemaTest.assertStatementError("42Y39", st, " create table t1 ( a varchar(128), check (a = current sqlid))");
        st.executeUpdate("create schema \"MiXCase\"");
        st.executeUpdate("set schema \"MiXCase\"");
        this.assertCurrentSchema(st, "MiXCase");
        st.executeUpdate("set schema app");
        this.assertCurrentSchema(st, "APP");
        st.executeUpdate("set schema 'MiXCase'");
        this.assertCurrentSchema(st, "MiXCase");
        CurrentSchemaTest.assertStatementError("42Y07", st, "set schema 'MIXCASE'");
        CurrentSchemaTest.assertStatementError("42Y07", st, "set schema mixcase");
        st.executeUpdate("create schema t23456789012345678901234567890");
        this.assertCurrentSchema(st, "MiXCase");
        st.executeUpdate("set schema app");
        this.assertCurrentSchema(st, "APP");
        st.executeUpdate("set schema t23456789012345678901234567890");
        this.assertCurrentSchema(st, "T23456789012345678901234567890");
        st.executeUpdate(" set schema app");
        this.assertCurrentSchema(st, "APP");
        st.executeUpdate("set schema 'T23456789012345678901234567890'");
        this.assertCurrentSchema(st, "T23456789012345678901234567890");
        st.executeUpdate("set schema app");
        this.assertCurrentSchema(st, "APP");
        this.setAutoCommit(false);
        pSt = this.prepareStatement("set schema ?");
        rs = st.executeQuery("values('T23456789012345678901234567890')");
        rs.next();
        pSt.setObject(1, rs.getObject(1));
        CurrentSchemaTest.assertUpdateCount(pSt, 0);
        this.assertCurrentSchema(st, "T23456789012345678901234567890");
        CurrentSchemaTest.assertStatementError("42622", st, "create schema TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT");
        CurrentSchemaTest.assertStatementError("42622", st, " set schema TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT");
        CurrentSchemaTest.assertStatementError("42622", st, " set schema 'TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT'");
        rs = st.executeQuery("values('TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT')");
        rs.next();
        pSt.setObject(1, rs.getObject(1));
        CurrentSchemaTest.assertStatementError("42815", pSt);
        this.rollback();
        this.setAutoCommit(true);
        st.executeUpdate("drop schema judy restrict");
        CurrentSchemaTest.assertStatementError("42622", st, " drop schema TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT restrict");
        this.rollback();
        st.close();
    }

    private void assertCurrentSchema(Statement st, String schema) throws SQLException {
        JDBC.assertFullResultSet(st.executeQuery("values current schema"), (Object[][])new String[][]{{schema}}, true);
    }
}

