/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class NSSecurityMechanismTest
extends BaseJDBCTestCase {
    private static String[] derby_drda_securityMechanisms = new String[]{null, "USER_ONLY_SECURITY", "CLEAR_TEXT_PASSWORD_SECURITY", "ENCRYPTED_USER_AND_PASSWORD_SECURITY", "STRONG_PASSWORD_SUBSTITUTE_SECURITY", "INVALID_VALUE", ""};
    private static String derby_drda_securityMechanism;
    private static String[] USER_ATTRIBUTE;
    private static String[] PWD_ATTRIBUTE;
    static final short SECMEC_EUSRIDPWD = 9;
    static final short SECMEC_USRIDONL = 4;
    static final short SECMEC_USRENCPWD = 7;
    static final short SECMEC_USRIDNWPWD = 5;
    static final short SECMEC_USRIDPWD = 3;
    static final short SECMEC_USRSSBPWD = 8;
    private static short[] SECMEC_ATTRIBUTE;

    public NSSecurityMechanismTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("NSSecurityMechanismTest");
        BaseTestSuite baseTestSuite2 = new BaseTestSuite("NSSecurityMechanismTest - client");
        baseTestSuite2.addTest((Test)new NSSecurityMechanismTest("testNetworkServerSecurityMechanism"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator((Test)baseTestSuite2));
        baseTestSuite.addTest(DatabasePropertyTestSetup.builtinAuthentication((Test)new NSSecurityMechanismTest("testSecurityMechanismOnEmbedded"), new String[]{"calvin"}, "pw"));
        return baseTestSuite;
    }

    @Override
    protected void tearDown() throws Exception {
        NSSecurityMechanismTest.removeSystemProperty("derby.drda.securityMechanism");
        super.tearDown();
    }

    public void testNetworkServerSecurityMechanism() throws SQLException, Exception {
        String[][] stringArrayArray = new String[][]{{"null", "OK", "OK", "OK", "OK", "OK", "OK", "?", "OK", "OK"}, {"USER_ONLY_SECURITY", "OK", "OK", "08004", "08004", "08004", "OK", "?", "OK", "08004"}, {"CLEAR_TEXT_PASSWORD_SECURITY", "08004", "08004", "OK", "OK", "08004", "08004", "?", "08004", "08004"}, {"ENCRYPTED_USER_AND_PASSWORD_SECURITY", "08004", "08004", "08004", "08004", "OK", "08004", "?", "08004", "08004"}, {"STRONG_PASSWORD_SUBSTITUTE_SECURITY", "08004", "08004", "08004", "08004", "08004", "08004", "?", "08004", "OK"}};
        String[][] stringArrayArray2 = new String[][]{{null, "OK", "OK", "OK", "OK"}, {"USER_ONLY_SECURITY", "OK", "08004", "08004", "08004"}, {"CLEAR_TEXT_PASSWORD_SECURITY", "08004", "OK", "08004", "08004"}, {"ENCRYPTED_USER_AND_PASSWORD_SECURITY", "08004", "08004", "OK", "08004"}, {"STRONG_PASSWORD_SUBSTITUTE_SECURITY", "08004", "08004", "08004", "OK"}};
        String[] stringArray = new String[]{"OK", "08004", "08004", "OK", "08004"};
        String[][] stringArrayArray3 = new String[][]{{null}, {"USER_ONLY_SECURITY", "08004", "OK", "08004", "08004", "08004", "OK", "OK", "08001.C.8", "08001.C.8", "08001.C.8", "08004", "OK", "08004", "08004", "08004", "OK", "OK", "08001.C.8", "08001.C.8", "08001.C.8"}, {"CLEAR_TEXT_PASSWORD_SECURITY", "OK", "08004", "OK", "08004", "08004", "08004", "08004", "08001.C.8", "08001.C.8", "08001.C.8", "OK", "08004", "OK", "08004", "08004", "08004", "08004", "08001.C.8", "08001.C.8", "08001.C.8"}, {"ENCRYPTED_USER_AND_PASSWORD_SECURITY", "08004", "08004", "08004", "OK", "08004", "08004", "08004", "08001.C.8", "08001.C.8", "08001.C.8", "08004", "08004", "08004", "OK", "08004", "08004", "08004", "08001.C.8", "08001.C.8", "08001.C.8"}, {"STRONG_PASSWORD_SUBSTITUTE_SECURITY", "08004", "08004", "08004", "08004", "OK", "08004", "08004", "08001.C.8", "08001.C.8", "08001.C.8", "08004", "08004", "08004", "08004", "OK", "08004", "08004", "08001.C.8", "08001.C.8", "08001.C.8"}};
        String[] stringArray2 = new String[]{null, "08006", "OK", "08004", "08006"};
        this.getConnection().getAutoCommit();
        for (int i = 0; i < derby_drda_securityMechanisms.length; ++i) {
            derby_drda_securityMechanism = derby_drda_securityMechanisms[i];
            if (derby_drda_securityMechanism != null) {
                if (derby_drda_securityMechanism.equals("STRONG_PASSWORD_SUBSTITUTE_SECURITY") && !this.hasSufficientEntropy()) {
                    NSSecurityMechanismTest.println("skipping USRSSBPWD secmec due to assumed lack of entropy");
                    continue;
                }
                if (this.setSecurityMechanism(derby_drda_securityMechanism)) continue;
            }
            this.assertConnectionsUsingDriverManager(stringArrayArray[i]);
            this.assertConnectionUsingDataSource(stringArrayArray2[i]);
            this.assertDerby1080Fixed(stringArray[i]);
            this.assertAllCombinationsOfUserPasswordSecMecInputOK(stringArrayArray3[i]);
            if (derby_drda_securityMechanism == null || derby_drda_securityMechanism.equals("STRONG_PASSWORD_SUBSTITUTE_SECURITY")) {
                this.assertUSRSSBPWD_with_BUILTIN(stringArray2);
                continue;
            }
            short s = 9;
            if (derby_drda_securityMechanism.equals("USER_ONLY_SECURITY")) {
                s = 4;
            } else if (derby_drda_securityMechanism.equals("CLEAR_TEXT_PASSWORD_SECURITY")) {
                s = 3;
            }
            this.assertConnectionUsingDriverManager(this.getJDBCUrl("user=APP;password=APP;shutdown=true;securityMechanism=" + s), " BUILTIN (T5):", "08006");
        }
    }

    public void testSecurityMechanismOnEmbedded() throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "securityMechanism=8");
        Connection connection = dataSource.getConnection("calvin", "calvinpw");
        connection.close();
    }

    private boolean setSecurityMechanism(String string) throws Exception {
        block6: {
            try {
                NetworkServerTestSetup.getNetworkServerControl().shutdown();
            }
            catch (Exception exception) {
                if (exception.getMessage().substring(0, 17).equals("DRDA_InvalidValue")) break block6;
                NSSecurityMechanismTest.fail((String)"unexpected error");
            }
        }
        NetworkServerTestSetup.waitForAvailablePort();
        NSSecurityMechanismTest.setSystemProperty("derby.drda.securityMechanism", derby_drda_securityMechanism);
        try {
            NetworkServerTestSetup.getNetworkServerControl().start(null);
            NetworkServerTestSetup.waitForServerStart(NetworkServerTestSetup.getNetworkServerControl());
            if (derby_drda_securityMechanism.equals("") || derby_drda_securityMechanism.equals("INVALID_VALUE")) {
                NSSecurityMechanismTest.fail((String)"expected server not to start with invalid or empty security mechanism, but passed");
            }
        }
        catch (Exception exception) {
            if (derby_drda_securityMechanism.equals("") || derby_drda_securityMechanism.equals("INVALID_VALUE") || derby_drda_securityMechanism.equals("ENCRYPTED_USER_AND_PASSWORD_SECURITY")) {
                NSSecurityMechanismTest.assertEquals((String)"DRDA_InvalidValue", (String)exception.getMessage().substring(0, 17));
                return true;
            }
            NSSecurityMechanismTest.fail((String)("got unexpected exception setting the mechanism " + string + "; message: " + exception.getMessage()));
        }
        return false;
    }

    private void assertConnectionsUsingDriverManager(String[] stringArray) {
        this.assertConnectionUsingDriverManager(this.getJDBCUrl(null), "T1:", stringArray[1]);
        this.assertConnectionUsingDriverManager(this.getJDBCUrl("user=max"), "T2:", stringArray[2]);
        this.assertConnectionUsingDriverManager(this.getJDBCUrl("user=neelima;password=lee"), "T3:", stringArray[3]);
        this.assertConnectionUsingDriverManager(this.getJDBCUrl("user=neelima;password=lee;securityMechanism=3"), "T4:", stringArray[4]);
        this.assertConnectionUsingDriverManager(this.getJDBCUrl("user=neelima;password=lee;securityMechanism=9"), "T5:", stringArray[5]);
        this.assertConnectionUsingDriverManager(this.getJDBCUrl("user=neelima;securityMechanism=4"), "T6:", stringArray[6]);
        this.assertConnectionUsingDriverManager(this.getJDBCUrl("user=neelima;password=lee;securityMechanism=4"), "T8:", stringArray[8]);
        this.assertConnectionUsingDriverManager(this.getJDBCUrl("user=neelima;password=lee;securityMechanism=8"), "T9:", stringArray[9]);
    }

    private void assertConnectionUsingDataSource(String[] stringArray) {
        if (NSSecurityMechanismTest.usingDerbyNetClient()) {
            this.assertSecurityMechanismOK("sarah", null, (short)4, "SECMEC_USRIDONL:", stringArray[1]);
        }
        this.assertSecurityMechanismOK("john", "sarah", (short)3, "SECMEC_USRIDPWD:", stringArray[2]);
        if (NSSecurityMechanismTest.usingDerbyNetClient()) {
            this.assertSecurityMechanismOK("john", "sarah", (short)9, "SECMEC_EUSRIDPWD:", stringArray[3]);
            this.assertSecurityMechanismOK("john", "sarah", (short)8, "SECMEC_USRSSBPWD:", stringArray[4]);
        }
    }

    private void assertSecurityMechanismOK(String string, String string2, Short s, String string3, String string4) {
        if (s == 8 && !this.hasSufficientEntropy()) {
            return;
        }
        DataSource dataSource = this.getDS(string, string2);
        try {
            JDBCDataSource.setBeanProperty(dataSource, "SecurityMechanism", s);
            Connection connection = dataSource.getConnection(string, string2);
            connection.close();
            if (!s.equals((short)9) && !string4.equals("OK")) {
                NSSecurityMechanismTest.fail((String)"should have encountered an Exception");
            }
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState().equals("08001")) {
                if (string == null) {
                    this.assertSQLState08001("08001.C.7", sQLException);
                } else {
                    this.assertSQLState08001(string4, sQLException);
                }
            } else if (s.equals((short)9)) {
                if (!sQLException.getSQLState().equals("XJ112")) {
                    NSSecurityMechanismTest.assertSQLState(string4, sQLException);
                }
            } else {
                NSSecurityMechanismTest.assertSQLState(string4, sQLException);
            }
        }
        catch (Exception exception) {
            NSSecurityMechanismTest.fail((String)" should not have seen an exception");
        }
    }

    private void assertConnectionUsingDriverManager(String string, String string2, String string3) {
        if (!this.hasSufficientEntropy() && string.indexOf("securityMechanism=8") != -1) {
            return;
        }
        try {
            TestConfiguration.getCurrent();
            DriverManager.getConnection(string).close();
            if (derby_drda_securityMechanism != null && (!derby_drda_securityMechanism.equals("ENCRYPTED_USER_AND_PASSWORD_SECURITY") || string2.indexOf("T5") <= 0 && string.indexOf("9") <= 0) && !string3.equals("OK")) {
                NSSecurityMechanismTest.fail((String)"should have encountered an Exception");
            }
        }
        catch (SQLException sQLException) {
            if (derby_drda_securityMechanism != null && derby_drda_securityMechanism.equals("ENCRYPTED_USER_AND_PASSWORD_SECURITY") && string2.indexOf("T5") > 0) {
                if (!sQLException.getSQLState().equals("XJ112")) {
                    NSSecurityMechanismTest.assertSQLState(string3, sQLException);
                }
            }
            if (sQLException.getSQLState().equals("08001")) {
                this.assertSQLState08001(string3, sQLException);
            }
            if (string.indexOf("9") > 0) {
                if (!sQLException.getSQLState().equals("XJ112")) {
                    NSSecurityMechanismTest.assertSQLState(string3, sQLException);
                }
            }
            if (sQLException.getSQLState().equals("XJ001")) {
                StringWriter stringWriter = new StringWriter();
                sQLException.printStackTrace(new PrintWriter(stringWriter));
                if (!stringWriter.toString().contains("java.lang.InternalError: Unexpected CryptoAPI failure")) {
                    NSSecurityMechanismTest.assertSQLState(string3, sQLException);
                } else {
                    NSSecurityMechanismTest.alarm("hit DERBY-6702; for values:\n\t dbURL: " + string + "\n\t msg: " + string2 + "\n\t expectedValue: " + string3 + "\n");
                }
            }
            if (string3.length() < 5) {
                StringWriter stringWriter = new StringWriter();
                sQLException.printStackTrace(new PrintWriter(stringWriter));
                String string4 = "unexpected failure...\n\t dbURL: " + string + "\n\t msg: " + string2 + "\n\t expectedValue: " + string3;
                NSSecurityMechanismTest.fail(string4, sQLException);
            }
            NSSecurityMechanismTest.assertSQLState(string3, sQLException);
        }
    }

    private void assertAllCombinationsOfUserPasswordSecMecInputOK(String[] stringArray) {
        Object object = null;
        for (int i = 0; i < USER_ATTRIBUTE.length; ++i) {
            for (int j = 0; j < PWD_ATTRIBUTE.length; ++j) {
                object = "";
                if (USER_ATTRIBUTE[i] != null) {
                    object = (String)object + "user=" + USER_ATTRIBUTE[i] + ";";
                }
                if (PWD_ATTRIBUTE[j] != null) {
                    object = (String)object + "password=" + PWD_ATTRIBUTE[j] + ";";
                }
                if (((String)object).length() >= 1) {
                    object = ((String)object).substring(0, ((String)object).length() - 1);
                }
                this.assertConnectionUsingDriverManager(this.getJDBCUrl((String)object), "Test:", this.getExpectedValueFromAll(stringArray, i, j, 4));
                this.getDataSourceConnection(USER_ATTRIBUTE[i], PWD_ATTRIBUTE[j], this.getExpectedValueFromAll(stringArray, i, j, 4));
                for (int k = 0; k < SECMEC_ATTRIBUTE.length; ++k) {
                    this.assertConnectionUsingDriverManager(this.getJDBCUrl((String)object + ";securityMechanism=" + SECMEC_ATTRIBUTE[k]), "#", this.getExpectedValueFromAll(stringArray, i, j, k));
                    this.assertSecurityMechanismOK(USER_ATTRIBUTE[i], PWD_ATTRIBUTE[j], SECMEC_ATTRIBUTE[k], "TEST_DS (" + (String)object + ",securityMechanism=" + SECMEC_ATTRIBUTE[k] + ")", this.getExpectedValueFromAll(stringArray, i, j, k));
                }
            }
        }
    }

    private String getExpectedValueFromAll(String[] stringArray, int n, int n2, int n3) {
        if (derby_drda_securityMechanism == null) {
            return "OK";
        }
        String string = n == 0 && n2 == 0 ? (n3 == 4 ? stringArray[1] : stringArray[2 + n3]) : (n == 0 && n2 == 1 ? (n3 == 4 ? stringArray[6] : stringArray[7 + n3]) : (n == 1 && n2 == 0 ? (n3 == 4 ? stringArray[11] : stringArray[12 + n3]) : (n3 == 4 ? stringArray[16] : stringArray[17 + n3])));
        return string;
    }

    private void getDataSourceConnection(String string, String string2, String string3) {
        DataSource dataSource = this.getDS(string, string2);
        try {
            Connection connection = dataSource.getConnection(string, string2);
            connection.close();
        }
        catch (SQLException sQLException) {
            if (string == null && sQLException.getSQLState().equals("08001")) {
                this.assertSQLState08001("08001.C.7", sQLException);
            } else {
                NSSecurityMechanismTest.assertSQLState(string3, sQLException);
            }
        }
        catch (Exception exception) {
            NSSecurityMechanismTest.fail((String)"should not have gotten an exception");
        }
    }

    private static void dumpSQLException(SQLException sQLException) {
        while (sQLException != null) {
            NSSecurityMechanismTest.println("SQLSTATE(" + sQLException.getSQLState() + "): " + sQLException.getMessage());
            sQLException = sQLException.getNextException();
        }
    }

    private void assertSecMecWithConnPoolingOK(String string, String string2, Short s) throws Exception {
        ConnectionPoolDataSource connectionPoolDataSource = this.getCPDS(string, string2);
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "SecurityMechanism", s);
        PooledConnection pooledConnection = connectionPoolDataSource.getPooledConnection();
        Connection connection = pooledConnection.getConnection();
        connection.close();
        connection = pooledConnection.getConnection();
        this.assertConnectionOK(connection);
        pooledConnection.close();
        connection.close();
    }

    private void assertConnectionOK(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        resultSet = statement.executeQuery("select count(*) from sys.systables");
        int n = 0;
        while (resultSet.next()) {
            resultSet.getInt(1);
            ++n;
        }
        NSSecurityMechanismTest.assertEquals((int)1, (int)n);
        if (resultSet != null) {
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void assertDerby1080Fixed(String string) throws Exception {
        block3: {
            try {
                this.assertSecMecWithConnPoolingOK("peter", "neelima", (short)9);
                if (!string.equals("OK")) {
                    NSSecurityMechanismTest.fail((String)"expected SQLException if DERBY-1080 did not regress");
                }
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("XJ112")) break block3;
                NSSecurityMechanismTest.assertSQLState(string, sQLException);
            }
        }
    }

    private void assertUSRSSBPWD_with_BUILTIN(String[] stringArray) throws Exception {
        if (!this.hasSufficientEntropy()) {
            return;
        }
        NSSecurityMechanismTest.println("Turning ON Derby BUILTIN authentication");
        Connection connection = this.getDataSourceConnectionWithSecMec("neelima", "lee", (short)8);
        CallableStatement callableStatement = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)");
        callableStatement.setString(1, "derby.authentication.builtin.algorithm");
        callableStatement.setString(2, null);
        callableStatement.execute();
        callableStatement.setString(1, "derby.user.neelima");
        callableStatement.setString(2, "lee");
        callableStatement.execute();
        callableStatement.setString(1, "derby.user.APP");
        callableStatement.setString(2, "APP");
        callableStatement.execute();
        callableStatement.setString(1, "derby.database.fullAccessUsers");
        callableStatement.setString(2, "neelima,APP");
        callableStatement.execute();
        callableStatement.setString(1, "derby.connection.requireAuthentication");
        callableStatement.setString(2, "true");
        callableStatement.execute();
        callableStatement.close();
        callableStatement = null;
        connection.close();
        this.assertConnectionUsingDriverManager(this.getJDBCUrl("user=APP;password=APP;shutdown=true;securityMechanism=8"), "USRSSBPWD (T0):", stringArray[1]);
        this.assertConnectionUsingDriverManager(this.getJDBCUrl("user=neelima;password=lee;securityMechanism=8"), "USRSSBPWD + BUILTIN (T1):", stringArray[2]);
        this.assertSecurityMechanismOK("neelima", "lee", (short)8, "TEST_DS - USRSSBPWD + BUILTIN (T2):", stringArray[2]);
        this.assertConnectionUsingDriverManager(this.getJDBCUrl("user=invalid;password=user;securityMechanism=8"), "USRSSBPWD + BUILTIN (T3):", stringArray[3]);
        this.assertSecurityMechanismOK("invalid", "user", (short)8, "TEST_DS - USRSSBPWD + BUILTIN (T4):", stringArray[3]);
        connection = this.getDataSourceConnectionWithSecMec("neelima", "lee", (short)8);
        callableStatement = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)");
        callableStatement.setString(1, "derby.connection.requireAuthentication");
        callableStatement.setString(2, "false");
        callableStatement.execute();
        callableStatement.close();
        callableStatement = null;
        connection.close();
        this.assertConnectionUsingDriverManager(this.getJDBCUrl("user=APP;password=APP;shutdown=true;securityMechanism=8"), "USRSSBPWD + BUILTIN (T5):", stringArray[4]);
    }

    private Connection getDataSourceConnectionWithSecMec(String string, String string2, Short s) throws Exception {
        DataSource dataSource = this.getDS(string, string2);
        JDBCDataSource.setBeanProperty(dataSource, "SecurityMechanism", s);
        return dataSource.getConnection();
    }

    private String getJDBCUrl(String string) {
        String string2 = TestConfiguration.getCurrent().getDefaultDatabaseName();
        Object object = TestConfiguration.getCurrent().getJDBCUrl(string2);
        if (string != null) {
            object = NSSecurityMechanismTest.usingDerbyNetClient() ? (String)object + ";" + string : (String)object + ":" + string + ";";
        }
        return object;
    }

    private DataSource getDS(String string, String string2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (string != null) {
            hashMap.put("user", string);
        }
        if (string2 != null) {
            hashMap.put("password", string2);
        }
        hashMap = this.addRequiredAttributes(hashMap);
        DataSource dataSource = JDBCDataSource.getDataSource();
        for (String string3 : hashMap.keySet()) {
            Object object = hashMap.get(string3);
            JDBCDataSource.setBeanProperty(dataSource, string3, object);
        }
        return dataSource;
    }

    private HashMap<String, Object> addRequiredAttributes(HashMap<String, Object> hashMap) {
        String string = TestConfiguration.getCurrent().getHostName();
        int n = TestConfiguration.getCurrent().getPort();
        if (!string.equals("localhost")) {
            hashMap.put("serverName", string);
            hashMap.put("portNumber", n);
        } else {
            hashMap.put("portNumber", n);
        }
        return hashMap;
    }

    private ConnectionPoolDataSource getCPDS(String string, String string2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (string != null) {
            hashMap.put("user", string);
        }
        if (string2 != null) {
            hashMap.put("password", string2);
        }
        hashMap = this.addRequiredAttributes(hashMap);
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        for (String string3 : hashMap.keySet()) {
            Object object = hashMap.get(string3);
            JDBCDataSource.setBeanProperty(connectionPoolDataSource, string3, object);
        }
        return connectionPoolDataSource;
    }

    private void assertSQLState08001(String string, SQLException sQLException) {
        if (string.equals("08001.C.7")) {
            NSSecurityMechanismTest.assertEquals((String)"User id can not be null.", (String)sQLException.getMessage());
        }
        if (string.equals("08001.C.8")) {
            NSSecurityMechanismTest.assertEquals((String)"Password can not be null.", (String)sQLException.getMessage());
        }
    }

    private boolean hasSufficientEntropy() {
        return !NSSecurityMechanismTest.getSystemProperty("os.arch").equalsIgnoreCase("arm");
    }

    static {
        USER_ATTRIBUTE = new String[]{"calvin", null};
        PWD_ATTRIBUTE = new String[]{"hobbes", null};
        SECMEC_ATTRIBUTE = new short[]{4, 3, 9, 8};
    }
}

