/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLFeatureNotSupportedException;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbc4.Wrapper41Driver;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SpawnedProcess;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Driver40UnbootedTest
extends BaseJDBCTestCase {
    private static final String SUCCESS = "Success";

    public Driver40UnbootedTest(String string) {
        super(string);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("DriverTest tests java.sql.Driver, not supported with JSR169");
        }
        Test test = TestConfiguration.embeddedSuite(Driver40UnbootedTest.class);
        return SecurityManagerSetup.noSecurityManager(test);
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        block2: {
            Driver driver = DriverManager.getDriver("jdbc:derby:");
            Wrapper41Driver wrapper41Driver = new Wrapper41Driver(driver);
            object = SUCCESS;
            try {
                wrapper41Driver.getParentLogger();
                object = "getParentLogger() unexpectedly succeeded";
            }
            catch (Exception exception) {
                if (exception instanceof SQLFeatureNotSupportedException) break block2;
                object = "Exception was not a SQLFeatureNotSupportedException. It was a " + exception.getClass().getName();
            }
        }
        System.out.print((String)object);
    }

    public void test_notBooted() throws Exception {
        this.getTestConfiguration();
        if (!TestConfiguration.loadingFromJars()) {
            return;
        }
        String[] stringArray = new String[]{"-Demma.verbosity.level=silent", ((Object)((Object)this)).getClass().getName()};
        Process process = Driver40UnbootedTest.execJavaCmd(stringArray);
        SpawnedProcess spawnedProcess = new SpawnedProcess(process, "UnbootedTest");
        Driver40UnbootedTest.assertEquals((int)0, (int)spawnedProcess.complete());
        Driver40UnbootedTest.assertEquals((String)SUCCESS, (String)spawnedProcess.getFullServerOutput());
    }
}

