/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memory;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.derby.jdbc.EmbeddedDriver;

public class ConnectionHandling {
    public static void main(String[] stringArray) throws Exception {
        int n;
        System.out.println("Test ConnectionHandling starting");
        new EmbeddedDriver();
        Connection connection = DriverManager.getConnection("jdbc:derby:wombat;create=true");
        connection.close();
        connection = null;
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        arrayList.ensureCapacity(30000);
        Properties properties = new Properties();
        while (true) {
            Connection connection2;
            try {
                connection2 = DriverManager.getConnection("jdbc:derby:wombat", properties);
            }
            catch (SQLException sQLException) {
                if ("08004".equals(sQLException.getSQLState())) {
                    System.out.println("FIRST OOME: " + sQLException.getSQLState() + " " + sQLException.getMessage());
                    break;
                }
                System.out.println("UNKNOWN ERROR " + sQLException.getSQLState() + " " + sQLException.getMessage());
                sQLException.printStackTrace(System.out);
                break;
            }
            catch (Throwable throwable) {
                System.out.println("UNKNOWN ERROR " + throwable);
                throwable.printStackTrace(System.out);
                break;
            }
            arrayList.add(connection2);
            if (arrayList.size() % 1000 != 0) continue;
            System.out.print(".");
        }
        System.out.println("");
        System.out.println(arrayList.size() + " successful connections");
        arrayList.ensureCapacity(arrayList.size() + 500);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (n = 0; n < 500; ++n) {
            if (n == 300) {
                Thread.sleep(10000L);
            }
            try {
                Connection connection3 = DriverManager.getConnection("jdbc:derby:wombat", properties);
                arrayList.add(connection3);
                ++n5;
                continue;
            }
            catch (SQLException sQLException) {
                if ("08004".equals(sQLException.getSQLState())) {
                    ++n2;
                    continue;
                }
                ++n3;
                System.out.println("UNKNOWN ERROR " + sQLException.getSQLState() + " " + sQLException.getMessage());
                sQLException.printStackTrace(System.out);
                continue;
            }
            catch (Throwable throwable) {
                ++n4;
                System.out.println("UNKNOWN ERROR " + throwable);
                throwable.printStackTrace(System.out);
            }
        }
        System.out.println("OK                  : " + n5);
        System.out.println("Failed 08004        : " + n2);
        System.out.println("Failed SQLException : " + n3);
        System.out.println("Failed Throwable    : " + n4);
        System.out.println("closing connections : " + arrayList.size());
        n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            Connection connection4 = arrayList.set(i, null);
            if (connection4.isClosed()) {
                ++n;
                continue;
            }
            connection4.close();
        }
        System.out.println("already closed      : " + n);
    }
}

