/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.helpers.DisposableIndexStatistics;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.IndexStatsUtil;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Changes10_9
extends UpgradeChange {
    private static final String UPGRADE_REQUIRED = "XCL47";
    private static final String INVALID_PROVIDER_CHANGE = "XCY05";
    private static final String[] SUPPORT_FILES_SOURCE = new String[]{"functionTests/tests/lang/dcl_java.jar", "functionTests/tests/lang/dcl_emc1.jar", "functionTests/tests/lang/dcl_emc2.jar"};
    private static final String[][] USERS = new String[][]{{"dbo", "the boss", null, "3b6071d99b1d48ab732e75a8de701b6c77632db65898", "3b6071d99b1d48ab732e75a8de701b6c77632db65898", "3b6071d99b1d48ab732e75a8de701b6c77632db65898"}, {"pat", "postman", "MD5", "3b609129e181a7f7527697235c8aead65c461a0257f3", "3b61aaca567ed43d1ba2e6402cbf1a723407:MD5", "3b624f4b0d7f3d2330c1db98a2000c62b5cd::1000:MD5"}, {"sam", "fireman", "SHA-1", "3b609e5173cfa03620061518adc92f2a58c7b15cf04f", "3b6197160362c0122fcd7a63a9da58fd0781140901fb:SHA-1", "3b62a2d88ffac5332219116ab53e29dd3b9e1222e990::1000:SHA-1"}};
    private Goal[] pattern;

    public Changes10_9(String string) {
        super(string);
        this.initPattern();
    }

    public static Test suite(int n) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Upgrade test for 10.9");
        baseTestSuite.addTestSuite(Changes10_9.class);
        return new SupportFilesSetup((Test)baseTestSuite, SUPPORT_FILES_SOURCE);
    }

    public void testDropStatisticsProc() throws Exception {
        Statement statement = this.createStatement();
        switch (this.getPhase()) {
            case 0: {
                statement.execute("CREATE TABLE dropStatsT1 (c11 int, c12 int) ");
                this.vetProcs(statement, "call syscs_util.syscs_drop_statistics( 'APP', 'DROPSTATST1', null )", false);
                break;
            }
            case 1: {
                this.vetProcs(statement, "call syscs_util.syscs_drop_statistics( 'APP', 'DROPSTATST1', null )", false);
                break;
            }
            case 2: {
                this.vetProcs(statement, "call syscs_util.syscs_drop_statistics( 'APP', 'DROPSTATST1', null )", false);
                break;
            }
            case 3: {
                this.vetProcs(statement, "call syscs_util.syscs_drop_statistics( 'APP', 'DROPSTATST1', null )", true);
                statement.execute("DROP TABLE dropStatsT1");
            }
        }
        statement.close();
    }

    public void testNativeAuthentication() throws Exception {
        Statement statement = this.createStatement();
        switch (this.getPhase()) {
            case 0: {
                this.vetSYSUSERS(statement, false);
                this.vetNativeProcs(statement, false);
                break;
            }
            case 1: {
                this.vetSYSUSERS(statement, false);
                this.vetNativeProcs(statement, false);
                break;
            }
            case 2: {
                this.vetSYSUSERS(statement, false);
                this.vetNativeProcs(statement, false);
                break;
            }
            case 3: {
                this.vetSYSUSERS(statement, true);
                this.vetNativeProcs(statement, true);
            }
        }
        statement.close();
    }

    private void vetProcs(Statement statement, String string, boolean bl) throws Exception {
        try {
            statement.execute(string);
            if (!bl) {
                Changes10_9.fail((String)"syscs_util.syscs_create_user should not exist.");
            }
        }
        catch (SQLException sQLException) {
            if (bl) {
                Changes10_9.assertSQLState("4251K", sQLException);
            }
            Changes10_9.assertSQLState("42Y03", sQLException);
        }
    }

    private void vetSYSUSERS(Statement statement, boolean bl) throws Exception {
        ResultSet resultSet = statement.executeQuery("select count(*) from sys.systables where tablename = 'SYSUSERS'");
        resultSet.next();
        int n = bl ? 1 : 0;
        Changes10_9.assertEquals((int)n, (int)resultSet.getInt(1));
        resultSet.close();
    }

    private void vetNativeProcs(Statement statement, boolean bl) throws Exception {
        String string = this.pushAuthenticationAlgorithm(statement);
        this.vetProcs(statement, "call syscs_util.syscs_create_user( 'FRED', 'fredpassword' )", bl);
        this.popAuthenticationAlgorithm(statement, string);
    }

    private String pushAuthenticationAlgorithm(Statement statement) throws Exception {
        String string = this.getDatabaseProperty(statement, "derby.authentication.builtin.algorithm");
        if (string == null) {
            this.setDatabaseProperty(statement, "derby.authentication.builtin.algorithm", "SHA-1");
        }
        return string;
    }

    private void popAuthenticationAlgorithm(Statement statement, String string) throws Exception {
        if (string == null) {
            this.setDatabaseProperty(statement, "derby.authentication.builtin.algorithm", null);
        }
    }

    private void setDatabaseProperty(Statement statement, String string, String object) throws Exception {
        object = object == null ? "cast ( null as varchar( 32672 ) )" : "'" + (String)object + "'";
        String string2 = "call syscs_util.syscs_set_database_property( '" + string + "', " + (String)object + " )";
        statement.execute(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDatabaseProperty(Statement statement, String string) throws Exception {
        try (ResultSet resultSet = statement.executeQuery("values( syscs_util.syscs_get_database_property( '" + string + "' ) )");){
            resultSet.next();
            String string2 = resultSet.getString(1);
            return string2;
        }
    }

    public void testNativeLocalAuthentication() throws Exception {
        Statement statement = this.createStatement();
        switch (this.getPhase()) {
            case 0: 
            case 2: {
                this.setDatabaseProperty(statement, "derby.authentication.provider", "NATIVE::LOCAL");
                this.setDatabaseProperty(statement, "derby.authentication.provider", null);
                break;
            }
            case 1: {
                this.setDatabaseProperty(statement, "derby.authentication.provider", "com.acme.AcmeAuthenticator");
                Changes10_9.assertStatementError(UPGRADE_REQUIRED, statement, "call syscs_util.syscs_set_database_property( 'derby.authentication.provider', 'NATIVE::LOCAL' )");
                this.setDatabaseProperty(statement, "derby.authentication.provider", null);
                break;
            }
        }
        statement.close();
    }

    public void testBuiltinAuthenticationWithConfigurableHash() throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSourceLogical("BUILTIN_10_9");
        if (this.getPhase() == 0) {
            JDBCDataSource.setBeanProperty(dataSource, "createDatabase", "create");
        } else if (this.getPhase() == 3) {
            JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "upgrade=true");
        }
        Connection connection = dataSource.getConnection("dbo", "the boss");
        this.verifyCanConnect(dataSource);
        CallableStatement callableStatement = connection.prepareCall("call syscs_util.syscs_set_database_property(?, ?)");
        if (this.getPhase() == 0) {
            callableStatement.setString(1, "derby.connection.requireAuthentication");
            callableStatement.setString(2, "true");
            callableStatement.execute();
            callableStatement.setString(1, "derby.authentication.provider");
            callableStatement.setString(2, "BUILTIN");
            callableStatement.execute();
            callableStatement.setString(1, "derby.authentication.builtin.saltLength");
            callableStatement.setInt(2, 0);
            callableStatement.execute();
        }
        this.setPasswords(callableStatement);
        callableStatement.close();
        this.verifyCanConnect(dataSource);
        this.verifyPasswords(connection);
        connection.close();
        JDBCDataSource.setBeanProperty(dataSource, "user", "dbo");
        JDBCDataSource.setBeanProperty(dataSource, "password", "the boss");
        JDBCDataSource.shutdownDatabase(dataSource);
    }

    private void setPasswords(CallableStatement callableStatement) throws SQLException {
        for (int i = 0; i < USERS.length; ++i) {
            callableStatement.setString(1, "derby.authentication.builtin.algorithm");
            callableStatement.setString(2, USERS[i][2]);
            callableStatement.execute();
            callableStatement.setString(1, "derby.user." + USERS[i][0]);
            callableStatement.setString(2, USERS[i][1]);
            callableStatement.execute();
        }
    }

    private void verifyPasswords(Connection connection) throws SQLException {
        int n = this.getPhase() == 3 ? 5 : (this.oldAtLeast(10, 6) ? 4 : 3);
        PreparedStatement preparedStatement = connection.prepareStatement("values syscs_util.syscs_get_database_property(?)");
        for (int i = 0; i < USERS.length; ++i) {
            String string = USERS[i][n];
            preparedStatement.setString(1, "derby.user." + USERS[i][0]);
            JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), string);
        }
        preparedStatement.close();
    }

    private void verifyCanConnect(DataSource dataSource) throws SQLException {
        for (int i = 0; i < USERS.length; ++i) {
            Connection connection = dataSource.getConnection(USERS[i][0], USERS[i][1]);
            connection.close();
        }
    }

    public void testJarStorage() throws Exception {
        Statement statement = this.createStatement();
        switch (this.getPhase()) {
            case 0: {
                this.createSchema("EMC");
                this.createSchema("FOO");
                statement.executeUpdate("create procedure EMC.ADDCONTACT(id INT, e_mail VARCHAR(30)) MODIFIES SQL DATA external name 'org.apache.derbyTesting.databaseclassloader.emc.addContact' language java parameter style java");
                statement.executeUpdate("create table EMC.CONTACTS     (id int, e_mail varchar(30))");
                this.installJar("dcl_emc1.jar", "EMC.MAIL_APP");
                this.installJar("dcl_java.jar", "EMC.MY_JAVA");
                this.installJar("dcl_emc2.jar", "FOO.BAR");
                this.setDBClasspath("EMC.MAIL_APP");
                this.tryCall();
                this.setDBClasspath(null);
                break;
            }
            case 1: {
                String string = SupportFilesSetup.getReadWriteFileName("d6505-backup");
                PreparedStatement preparedStatement = this.prepareStatement("call syscs_util.syscs_backup_database(?)");
                preparedStatement.setString(1, string);
                preparedStatement.execute();
            }
            case 2: {
                this.setDBClasspath("EMC.MAIL_APP");
                this.tryCall();
                this.setDBClasspath(null);
                this.replaceJar("dcl_emc1.jar", "EMC.MAIL_APP");
                this.setDBClasspath("EMC.MAIL_APP");
                this.tryCall();
                this.setDBClasspath(null);
                break;
            }
            case 3: {
                this.setDBClasspath("EMC.MAIL_APP");
                this.tryCall();
                this.setDBClasspath(null);
                this.installJar("dcl_emc1.jar", "FOO.\"BAR/..\\../\"");
                this.verifyNewLocations(4);
                this.removeJar("EMC.MAIL_APP");
                this.installJar("dcl_emc1.jar", "EMC.MAIL_APP");
                this.setDBClasspath("EMC.MAIL_APP");
                this.tryCall();
                this.setDBClasspath(null);
                this.replaceJar("dcl_java.jar", "EMC.MY_JAVA");
                this.replaceJar("dcl_emc2.jar", "FOO.BAR");
                this.replaceJar("dcl_emc1.jar", "FOO.\"BAR/..\\../\"");
                this.removeJar("EMC.MY_JAVA");
                this.removeJar("FOO.BAR");
                this.removeJar("FOO.\"BAR/..\\../\"");
                this.removeJar("EMC.MAIL_APP");
                statement.executeUpdate("drop table EMC.CONTACTS");
                statement.executeUpdate("drop procedure EMC.ADDCONTACT");
                statement.executeUpdate("drop schema FOO restrict");
                statement.executeUpdate("drop schema EMC restrict");
            }
        }
        statement.close();
    }

    private void createSchema(String string) throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create schema " + string);
        statement.close();
    }

    private void installJar(String string, String string2) throws SQLException, MalformedURLException {
        URL uRL = SupportFilesSetup.getReadOnlyURL(string);
        CallableStatement callableStatement = this.prepareCall("CALL SQLJ.INSTALL_JAR(?, ?, 0)");
        callableStatement.setString(1, uRL.toExternalForm());
        callableStatement.setString(2, string2);
        callableStatement.executeUpdate();
        callableStatement.close();
    }

    private void replaceJar(String string, String string2) throws SQLException, MalformedURLException {
        URL uRL = SupportFilesSetup.getReadOnlyURL(string);
        CallableStatement callableStatement = this.prepareCall("CALL SQLJ.REPLACE_JAR(?, ?)");
        callableStatement.setString(1, uRL.toExternalForm());
        callableStatement.setString(2, string2);
        callableStatement.executeUpdate();
        callableStatement.close();
    }

    private void removeJar(String string) throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL SQLJ.REMOVE_JAR(?, 0)");
        callableStatement.setString(1, string);
        callableStatement.executeUpdate();
        callableStatement.close();
    }

    private void setDBClasspath(String string) throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.database.classpath', ?)");
        callableStatement.setString(1, string);
        callableStatement.executeUpdate();
        callableStatement.close();
    }

    private void tryCall() throws SQLException {
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        CallableStatement callableStatement = this.prepareCall("CALL EMC.ADDCONTACT(?, ?)");
        callableStatement.setInt(1, 0);
        callableStatement.setString(2, "now@classpathchange.com");
        callableStatement.executeUpdate();
        callableStatement.close();
    }

    private void verifyNewLocations(int n) throws SQLException {
        TestConfiguration testConfiguration = TestConfiguration.getCurrent();
        String string = testConfiguration.getPhysicalDatabaseName(testConfiguration.getDefaultDatabaseName());
        String string2 = "system" + File.separator + string + File.separator + "jar";
        File file = new File(string2);
        Changes10_9.assertTrue((boolean)file.isDirectory());
        File[] fileArray = file.listFiles();
        Changes10_9.assertEquals((int)n, (int)fileArray.length);
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            Changes10_9.assertTrue((boolean)file2.isFile());
            this.assertFileNameShape(file2.getName());
        }
    }

    private void initPattern() {
        int n;
        ArrayList<Goal> arrayList = new ArrayList<Goal>(100);
        for (n = 0; n < 8; ++n) {
            arrayList.add(new CharRange(new char[][]{{'0', '9'}, {'a', 'f'}}));
        }
        arrayList.add(new SingleChar('-'));
        for (n = 0; n < 3; ++n) {
            for (int i = 0; i < 4; ++i) {
                arrayList.add(new CharRange(new char[][]{{'0', '9'}, {'a', 'f'}}));
            }
            arrayList.add(new SingleChar('-'));
        }
        for (n = 0; n < 12; ++n) {
            arrayList.add(new CharRange(new char[][]{{'0', '9'}, {'a', 'f'}}));
        }
        arrayList.add(new SingleChar('.'));
        arrayList.add(new SingleChar('j'));
        arrayList.add(new SingleChar('a'));
        arrayList.add(new SingleChar('r'));
        arrayList.add(new SingleChar('.'));
        arrayList.add(new SingleChar('G'));
        arrayList.add(new CharRange(new char[][]{{'0', '9'}}, 0));
        this.pattern = arrayList.toArray(new Goal[arrayList.size()]);
    }

    private void assertFileNameShape(String string) {
        Changes10_9.assertTrue((boolean)this.matches(string, this.pattern));
    }

    private boolean matches(String string, Goal[] goalArray) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            Goal goal = goalArray[n];
            char c = string.charAt(i);
            if (goal.matches(c)) {
                if (!goal.isRepeatable()) {
                    ++n;
                }
                goal.setFoundOnce();
                continue;
            }
            ++n;
            if (goal.matches(c)) {
                if (!goal.isRepeatable()) {
                    ++n;
                }
                goal.setFoundOnce();
                continue;
            }
            return false;
        }
        return n >= goalArray.length - 1;
    }

    public void test_5493() throws Exception {
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        switch (this.getPhase()) {
            case 0: {
                Changes10_9.assertNull((Object)this.getNewFunctionID(statement));
                break;
            }
            case 1: {
                Changes10_9.assertNull((Object)this.getNewFunctionID(statement));
                break;
            }
            case 2: {
                Changes10_9.assertNull((Object)this.getNewFunctionID(statement));
                break;
            }
            case 3: {
                Changes10_9.assertNotNull((Object)this.getNewFunctionID(statement));
            }
        }
        statement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNewFunctionID(Statement statement) throws Exception {
        try (ResultSet resultSet = null;){
            resultSet = statement.executeQuery("select aliasid from sys.sysaliases where alias = 'SYSCS_PEEK_AT_SEQUENCE'");
            if (!resultSet.next()) {
                String string = null;
                return string;
            }
            String string = resultSet.getString(1);
            return string;
        }
    }

    public void testDropOrphanedStatistics() throws SQLException {
        if (!this.oldAtLeast(10, 5)) {
            return;
        }
        if (JVMInfo.isModuleAware()) {
            return;
        }
        IndexStatsUtil indexStatsUtil = new IndexStatsUtil(this.openDefaultConnection());
        Statement statement = this.createStatement();
        int n = DisposableIndexStatistics.hasDerby5681Bug(this.getOldVersion()) ? 2 : 1;
        switch (this.getPhase()) {
            case 0: {
                statement.executeUpdate("CREATE TABLE TEST_TAB_1 (c11 int not null,c12 int not null, c13 int)");
                statement.executeUpdate("INSERT INTO TEST_TAB_1 VALUES(1,1,1),(2,2,2)");
                statement.executeUpdate("ALTER TABLE TEST_TAB_1 ADD CONSTRAINT TEST_TAB_1_PK_1 PRIMARY KEY (c11)");
                indexStatsUtil.assertTableStats("TEST_TAB_1", 1);
                statement.executeUpdate("CREATE TABLE TEST_TAB_2 (c21 int not null)");
                statement.executeUpdate("INSERT INTO TEST_TAB_2 VALUES(1),(2)");
                statement.executeUpdate("ALTER TABLE TEST_TAB_2 ADD CONSTRAINT TEST_TAB_2_PK_1 PRIMARY KEY (c21)");
                indexStatsUtil.assertTableStats("TEST_TAB_2", 1);
                statement.executeUpdate("ALTER TABLE TEST_TAB_2 ADD CONSTRAINT TEST_TAB_2_FK_1 FOREIGN KEY(c21) REFERENCES TEST_TAB_1(c11)");
                indexStatsUtil.assertTableStats("TEST_TAB_2", 1);
                statement.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEST_TAB_2', null)");
                indexStatsUtil.assertTableStats("TEST_TAB_2", 2);
                statement.executeUpdate("ALTER TABLE TEST_TAB_2 DROP CONSTRAINT TEST_TAB_2_FK_1");
                indexStatsUtil.assertTableStats("TEST_TAB_2", n);
                Changes10_9.assertStatementError("42Y03", statement, "CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','TEST_TAB_2', null)");
                break;
            }
            case 1: 
            case 2: {
                Changes10_9.assertStatementError("42Y03", statement, "CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','TEST_TAB_2', null)");
                break;
            }
            case 3: {
                indexStatsUtil.assertTableStats("TEST_TAB_2", n);
                statement.execute("CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','TEST_TAB_2', null)");
                indexStatsUtil.assertNoStatsTable("TEST_TAB_2");
                statement.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEST_TAB_2', null)");
                indexStatsUtil.assertNoStatsTable("TEST_TAB_2");
                break;
            }
            case 4: {
                statement.execute("CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','TEST_TAB_2', null)");
                statement.executeUpdate("DROP TABLE TEST_TAB_1");
                statement.executeUpdate("DROP TABLE TEST_TAB_2");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDisposableStatisticsExplicit() throws SQLException {
        if (!this.oldAtLeast(10, 5)) {
            return;
        }
        if (JVMInfo.isModuleAware()) {
            return;
        }
        String string = "call syscs_util.syscs_update_statistics('APP', ?, null)";
        DisposableIndexStatistics disposableIndexStatistics = new DisposableIndexStatistics(this.getOldVersion(), this.getConnection(), "ISTAT_DISPOSABLE_STATS");
        switch (this.getPhase()) {
            case 0: {
                disposableIndexStatistics.createAndPopulateTables();
                disposableIndexStatistics.assertStatsCount(false, false);
                break;
            }
            case 1: {
                PreparedStatement preparedStatement = this.prepareStatement(string);
                String[] stringArray = disposableIndexStatistics.getTableNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    preparedStatement.setString(1, stringArray[i]);
                    preparedStatement.executeUpdate();
                }
                disposableIndexStatistics.assertStatsCount(true, false);
                break;
            }
            case 2: {
                disposableIndexStatistics.assertStatsCount(true, false);
                break;
            }
            case 3: {
                int n;
                disposableIndexStatistics.assertStatsCount(true, false);
                PreparedStatement preparedStatement = this.prepareStatement(string);
                String[] stringArray = disposableIndexStatistics.getTableNames();
                for (n = 0; n < stringArray.length; ++n) {
                    preparedStatement.setString(1, stringArray[n]);
                    preparedStatement.executeUpdate();
                }
                try {
                    disposableIndexStatistics.assertStatsCount(true, true);
                }
                finally {
                    for (n = 0; n < stringArray.length; ++n) {
                        this.dropTable(stringArray[n]);
                    }
                }
                this.commit();
                break;
            }
        }
    }

    private class SingleChar
    extends Goal {
        private char c;
        private int option;
        private boolean foundOnce;

        public SingleChar(char c) {
            this.option = -1;
            this.foundOnce = false;
            this.c = c;
        }

        public SingleChar(char c, int n) {
            this.option = -1;
            this.foundOnce = false;
            this.c = c;
            this.option = n;
        }

        @Override
        public boolean matches(char c) {
            return c == this.c;
        }
    }

    private class CharRange
    extends Goal {
        private char[][] ranges;

        public CharRange(char[][] cArray) {
            this.ranges = (char[][])cArray.clone();
        }

        public CharRange(char[][] cArray, int n) {
            this.ranges = (char[][])cArray.clone();
            this.option = n;
        }

        @Override
        public boolean matches(char c) {
            for (int i = 0; i < this.ranges.length; ++i) {
                if (c < this.ranges[i][0] || c > this.ranges[i][1]) continue;
                return true;
            }
            return false;
        }
    }

    abstract class Goal {
        public static final int REPEAT = 0;
        int option = -1;
        boolean foundOnce = false;

        Goal() {
        }

        public abstract boolean matches(char var1);

        public boolean isRepeatable() {
            return this.option == 0;
        }

        public void setFoundOnce() {
            this.foundOnce = true;
        }

        public boolean foundOnce() {
            return this.foundOnce;
        }
    }
}

